/*
 * Decompiled with CFR 0.152.
 */
package charm.debug.inspect;

import charm.debug.inspect.GenericElement;
import charm.debug.inspect.InspectedElement;
import charm.debug.inspect.TypeVisitor;
import java.nio.ByteBuffer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class JTreeVisitor
extends TypeVisitor {
    DefaultMutableTreeNode current;
    DefaultMutableTreeNode top;
    DefaultMutableTreeNode last;
    JTree tree;

    public JTreeVisitor(ByteBuffer b, int start, String title) {
        super(b, start);
        this.last = this.top = new DefaultMutableTreeNode(title);
        this.current = this.top;
        this.tree = null;
    }

    @Override
    public void addElement(GenericElement e, String v) {
        this.last = new DefaultMutableTreeNode(new InspectedElement(e, v));
        this.current.add(this.last);
    }

    @Override
    public void push() {
        this.current = this.last;
    }

    @Override
    public void pop() {
        this.current = (DefaultMutableTreeNode)this.current.getParent();
    }

    @Override
    public Object getResult() {
        if (this.tree == null) {
            this.tree = new JTree(this.top);
            this.tree.setRootVisible(false);
            this.tree.expandRow(0);
        }
        return this.tree;
    }
}

