/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import charm.ccs.CcsServer;
import charm.debug.MemoryPanel;
import charm.debug.ParDebug;
import charm.debug.fmt.PList;
import charm.debug.pdata.MemoryPList;
import charm.debug.pdata.Slot;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Scrollable;

public class ScrollableMemory
extends JLabel
implements Scrollable {
    private static final int HOLE_PIXELS = 50;
    private int maxUnitIncrement = 1;
    private boolean missingPicture = false;
    private int pe;
    private MemoryPList data;
    private int verticalPixels;
    private int horizontalPixels;
    private int lineScan;
    private int lineWidth;
    private int lineStart;
    private int numLines;
    private int pixelsAvailable;
    private int memorySize;
    private int[] allocatedMemory;
    private int[] numAllocations;
    private int[] allocatedLeak;
    private int[] numLeaks;
    private long firstByte;
    private long lastByte;
    private MemoryPList.Hole[] holes;
    private Slot[] crossReference;
    private int[][] rgbnormal;
    private int[][] rgbleak;
    private int[][] rgbmod;
    private int[][] rgbnew;
    private int[][] rgbdim;
    private int[][] rgbdimleak;
    private int[] rgbselected;
    private int[] rgbhole;
    private Slot selectedSlot;
    private boolean selectDim = false;
    private Vector chareLists;
    public int viewX;
    public int viewY;

    public ScrollableMemory(MemoryPanel parent, int forPE, int scan, int lines, int horiz) {
        this.lineScan = scan;
        this.numLines = lines;
        this.horizontalPixels = horiz;
        this.pe = forPE;
        this.loadImage(false, 0);
        this.setHorizontalAlignment(0);
        this.setOpaque(true);
        this.setBackground(Color.black);
        this.setAutoscrolls(true);
    }

    public void loadImage(boolean isLeak, int low) {
        int i;
        if (isLeak) {
            CcsServer.writeInt(ParDebug.globals, ParDebug.globals.length - 8, low);
            CcsServer.writeInt(ParDebug.globals, ParDebug.globals.length - 4, this.pe);
            ParDebug.debugger.server.sendCcsRequestBytes("debug/memory/leak", ParDebug.globals, this.pe, true);
        }
        PList list = ParDebug.debugger.server.getPList("memory/list", this.pe);
        this.data = new MemoryPList();
        this.data.load(list);
        this.data.sort();
        this.firstByte = Long.MAX_VALUE;
        this.lastByte = Long.MIN_VALUE;
        for (i = 0; i < this.data.size(); ++i) {
            System.out.println("list " + i + " contains " + this.data.size(i) + " elements");
            if (this.data.size(i) == 0) continue;
            if (this.data.elementAt(i, 0).getLocation() < this.firstByte) {
                this.firstByte = this.data.elementAt(i, 0).getLocation();
            }
            if (this.data.elementAt(i, this.data.size(i) - 1).getLocation() <= this.lastByte) continue;
            this.lastByte = this.data.elementAt(i, this.data.size(i) - 1).getLocation() + (long)this.data.elementAt(i, this.data.size(i) - 1).getSize();
        }
        this.holes = this.data.findHoles();
        this.memorySize = (int)(this.lastByte - this.firstByte + 1L - this.holes[0].getSize());
        this.allocatedMemory = new int[6];
        this.numAllocations = new int[6];
        this.allocatedLeak = new int[6];
        this.numLeaks = new int[6];
        for (i = 0; i < 6; ++i) {
            this.numLeaks[i] = 0;
            this.allocatedLeak[i] = 0;
            this.numAllocations[i] = 0;
            this.allocatedMemory[i] = 0;
        }
        this.selectedSlot = null;
        this.resizeImage();
    }

    public void resizeImage(int scan, int lines, int horiz) {
        this.lineScan = scan;
        this.numLines = lines;
        this.horizontalPixels = horiz;
        this.resizeImage();
    }

    private void resizeImage() {
        int i;
        int j;
        int i2;
        this.lineWidth = this.lineScan * 3 / 4;
        this.lineStart = (this.lineScan - this.lineWidth) / 2;
        this.verticalPixels = this.numLines * this.lineScan;
        this.pixelsAvailable = this.verticalPixels / this.lineScan * this.horizontalPixels;
        this.crossReference = new Slot[this.pixelsAvailable];
        this.pixelsAvailable = (int)((long)this.pixelsAvailable - 50L * this.holes[0].getPosition());
        BufferedImage tmp = new BufferedImage(this.horizontalPixels, this.verticalPixels, 2);
        this.rgbnormal = new int[5][this.lineWidth];
        int color = -45747;
        for (i2 = 0; i2 < this.lineWidth; ++i2) {
            this.rgbnormal[0][i2] = color;
        }
        color = -2341563;
        for (i2 = 0; i2 < this.lineWidth; ++i2) {
            this.rgbnormal[1][i2] = color;
        }
        color = -10840321;
        for (i2 = 0; i2 < this.lineWidth; ++i2) {
            this.rgbnormal[2][i2] = color;
        }
        color = -19891;
        for (i2 = 0; i2 < this.lineWidth; ++i2) {
            this.rgbnormal[3][i2] = color;
        }
        color = -26881;
        for (i2 = 0; i2 < this.lineWidth; ++i2) {
            this.rgbnormal[4][i2] = color;
        }
        this.rgbleak = new int[5][this.lineWidth];
        color = -16711936;
        for (j = 0; j < 5; ++j) {
            for (i = 0; i < (int)(0.75 * (double)this.lineWidth); ++i) {
                this.rgbleak[j][i] = color;
            }
            for (i = (int)(0.75 * (double)this.lineWidth); i < this.lineWidth; ++i) {
                this.rgbleak[j][i] = this.rgbnormal[j][i];
            }
        }
        this.rgbmod = new int[5][this.lineWidth];
        color = -256;
        for (j = 0; j < 5; ++j) {
            for (i = 0; i < (int)(0.75 * (double)this.lineWidth); ++i) {
                this.rgbmod[j][i] = color;
            }
            for (i = (int)(0.75 * (double)this.lineWidth); i < this.lineWidth; ++i) {
                this.rgbmod[j][i] = this.rgbnormal[j][i];
            }
        }
        this.rgbnew = new int[5][this.lineWidth];
        color = -1514864896;
        for (j = 0; j < 5; ++j) {
            for (i = 0; i < (int)(0.75 * (double)this.lineWidth); ++i) {
                this.rgbnew[j][i] = color;
            }
            for (i = (int)(0.75 * (double)this.lineWidth); i < this.lineWidth; ++i) {
                this.rgbnew[j][i] = this.rgbnormal[j][i];
            }
        }
        this.rgbdim = new int[5][this.lineWidth];
        this.rgbdimleak = new int[5][this.lineWidth];
        for (j = 0; j < 5; ++j) {
            for (i = 0; i < this.lineWidth; ++i) {
                this.rgbdim[j][i] = this.rgbnormal[j][i] - Integer.MIN_VALUE;
                this.rgbdimleak[j][i] = this.rgbleak[j][i] - Integer.MIN_VALUE;
            }
        }
        this.rgbselected = new int[this.lineWidth];
        color = -101;
        for (i2 = 0; i2 < this.lineWidth; ++i2) {
            this.rgbselected[i2] = color;
        }
        this.rgbhole = new int[this.lineWidth];
        color = -4934476;
        for (i2 = 0; i2 < this.lineWidth; ++i2) {
            this.rgbhole[i2] = color;
        }
        for (i2 = 0; i2 < this.data.size(); ++i2) {
            int nextHole = this.holes[0].getPosition() > 0L ? 1 : 0;
            int lostMemory = 0;
            int additionalPixels = 0;
            for (int j2 = 0; j2 < this.data.size(i2); ++j2) {
                int pos;
                int ln;
                int lineEnd;
                int end;
                int line;
                int offset;
                Slot sl = this.data.elementAt(i2, j2);
                if (nextHole > 0 && this.holes[nextHole].getPosition() < sl.getLocation()) {
                    offset = (int)(this.holes[nextHole].getPosition() - this.firstByte - (long)lostMemory);
                    offset = (int)((long)offset * (long)this.pixelsAvailable / (long)this.memorySize);
                    line = (offset += additionalPixels) / this.horizontalPixels;
                    offset -= line * this.horizontalPixels;
                    end = (int)(this.holes[nextHole].getPosition() - this.firstByte - (long)lostMemory);
                    end = (int)((long)end * (long)this.pixelsAvailable / (long)this.memorySize);
                    lineEnd = (end += additionalPixels + 50) / this.horizontalPixels;
                    end -= lineEnd * this.horizontalPixels;
                    ln = line;
                    for (pos = offset; ln < lineEnd || pos < end; ++pos) {
                        if (pos == this.horizontalPixels) {
                            pos = 0;
                            ++ln;
                        }
                        tmp.setRGB(pos, ln * this.lineScan + this.lineStart, 1, this.lineWidth, this.rgbhole, 0, 1);
                    }
                    lostMemory = (int)((long)lostMemory + this.holes[nextHole].getSize());
                    additionalPixels += 50;
                    nextHole = this.holes[0].getPosition() > (long)nextHole ? nextHole + 1 : 0;
                }
                offset = (int)(sl.getLocation() - this.firstByte - (long)lostMemory);
                offset = (int)((long)offset * (long)this.pixelsAvailable / (long)this.memorySize);
                line = (offset += additionalPixels) / this.horizontalPixels;
                offset -= line * this.horizontalPixels;
                end = (int)(sl.getLocation() + (long)sl.getSize() - this.firstByte - (long)lostMemory);
                end = (int)((long)end * (long)this.pixelsAvailable / (long)this.memorySize);
                lineEnd = (end += additionalPixels) / this.horizontalPixels;
                end -= lineEnd * this.horizontalPixels;
                ln = line;
                for (pos = offset; ln < lineEnd || pos <= end; ++pos) {
                    if (pos == this.horizontalPixels) {
                        pos = 0;
                        ++ln;
                    }
                    if (sl.isLeak()) {
                        tmp.setRGB(pos, ln * this.lineScan + this.lineStart, 1, this.lineWidth, this.rgbleak[sl.getType()], 0, 1);
                    } else if (sl.isModified()) {
                        tmp.setRGB(pos, ln * this.lineScan + this.lineStart, 1, this.lineWidth, this.rgbmod[sl.getType()], 0, 1);
                    } else if (sl.isNewBlock()) {
                        tmp.setRGB(pos, ln * this.lineScan + this.lineStart, 1, this.lineWidth, this.rgbnew[sl.getType()], 0, 1);
                    } else {
                        tmp.setRGB(pos, ln * this.lineScan + this.lineStart, 1, this.lineWidth, this.rgbnormal[sl.getType()], 0, 1);
                    }
                    this.crossReference[ln * this.horizontalPixels + pos] = sl;
                }
            }
        }
        this.setIcon(new ImageIcon(tmp));
        this.selectSlot(this.selectedSlot);
        this.chareLists = null;
        this.dimByChareID(this.selectDim);
        this.maxUnitIncrement = this.lineScan;
    }

    private void drawSlot(Slot sl, int[] color) {
        this.drawSlot(sl, color, this.lineWidth);
    }

    private void drawSlot(Slot sl, int[] color, int lineW) {
        long lostMemory = 0L;
        int additionalPixels = 0;
        int index = 1;
        while ((long)index <= this.holes[0].getPosition() && this.holes[index].getPosition() < sl.getLocation()) {
            lostMemory += this.holes[index].getSize();
            additionalPixels += 50;
            ++index;
        }
        int offset = (int)(sl.getLocation() - this.firstByte - lostMemory);
        offset = (int)((long)offset * (long)this.pixelsAvailable / (long)this.memorySize);
        int line = (offset += additionalPixels) / this.horizontalPixels;
        offset -= line * this.horizontalPixels;
        int end = (int)(sl.getLocation() + (long)sl.getSize() - this.firstByte - lostMemory);
        end = (int)((long)end * (long)this.pixelsAvailable / (long)this.memorySize);
        int lineEnd = (end += additionalPixels) / this.horizontalPixels;
        end -= lineEnd * this.horizontalPixels;
        int ln = line;
        for (int pos = offset; ln < lineEnd || pos <= end; ++pos) {
            if (pos == this.horizontalPixels) {
                pos = 0;
                ++ln;
            }
            ((BufferedImage)((ImageIcon)this.getIcon()).getImage()).setRGB(pos, ln * this.lineScan + this.lineStart, 1, lineW, color, 0, 1);
        }
        this.repaint();
    }

    public void selectSlot(Slot sl) {
        if (this.selectedSlot != null) {
            if (this.selectedSlot.isLeak()) {
                this.drawSlot(this.selectedSlot, this.rgbleak[this.selectedSlot.getType()]);
            } else {
                this.drawSlot(this.selectedSlot, this.rgbnormal[this.selectedSlot.getType()]);
            }
        }
        if (this.selectDim) {
            Slot s;
            int i;
            Vector list;
            if (this.selectedSlot != null) {
                list = (Vector)this.chareLists.elementAt(this.selectedSlot.getChareID());
                for (i = 0; i < list.size(); ++i) {
                    s = (Slot)list.elementAt(i);
                    if (s.isLeak()) {
                        this.drawSlot(s, this.rgbdimleak[s.getType()]);
                        continue;
                    }
                    this.drawSlot(s, this.rgbdim[s.getType()]);
                }
            }
            if (sl != null) {
                list = (Vector)this.chareLists.elementAt(sl.getChareID());
                for (i = 0; i < list.size(); ++i) {
                    s = (Slot)list.elementAt(i);
                    if (s.isLeak()) {
                        this.drawSlot(s, this.rgbleak[s.getType()]);
                        continue;
                    }
                    this.drawSlot(s, this.rgbnormal[s.getType()]);
                }
            }
        }
        this.selectedSlot = sl;
        if (sl != null) {
            this.drawSlot(sl, this.rgbselected, this.lineWidth >> 1);
        }
    }

    public String memoryStatString() {
        NumberFormat f = NumberFormat.getInstance();
        StringBuffer buf = new StringBuffer("<html>Memory Usage: <table border=1><th><td>Num. alloc</td><td>Total size</td><td>Num. leaks</td><td>Leak size</td></th>");
        String[] names = new String[]{"Total", "Unknown", "System", "User", "Chare", "Message"};
        this.computeStatistics();
        for (int i = 0; i < 6; ++i) {
            buf.append("<tr><td>").append(names[i]).append("</td><td align=right>").append(f.format(this.numAllocations[i])).append("</td><td align=right>").append(f.format(this.allocatedMemory[i])).append("</td><td align=right>").append(f.format(this.numLeaks[i])).append("</td><td align=right>").append(f.format(this.allocatedLeak[i])).append("</td></tr>");
        }
        buf.append("</table></html>");
        return buf.toString();
    }

    public void dimByChareID(boolean dim) {
        Slot sl;
        int j;
        int i;
        if (dim && this.chareLists == null) {
            this.chareLists = new Vector();
            for (i = 0; i < this.data.size(); ++i) {
                for (j = 0; j < this.data.size(i); ++j) {
                    sl = this.data.elementAt(i, j);
                    int type = sl.getChareID();
                    if (this.chareLists.size() <= type) {
                        this.chareLists.setSize(type + 1);
                    }
                    if (this.chareLists.elementAt(type) == null) {
                        this.chareLists.setElementAt(new Vector(), type);
                    }
                    ((Vector)this.chareLists.elementAt(type)).add(sl);
                }
            }
        }
        if (dim) {
            for (i = 0; i < this.data.size(); ++i) {
                for (j = 0; j < this.data.size(i); ++j) {
                    sl = this.data.elementAt(i, j);
                    if (sl.isLeak()) {
                        this.drawSlot(sl, this.rgbdimleak[sl.getType()]);
                        continue;
                    }
                    this.drawSlot(sl, this.rgbdim[sl.getType()]);
                }
            }
        } else {
            for (i = 0; i < this.data.size(); ++i) {
                for (j = 0; j < this.data.size(i); ++j) {
                    sl = this.data.elementAt(i, j);
                    if (sl.isLeak()) {
                        this.drawSlot(sl, this.rgbleak[sl.getType()]);
                        continue;
                    }
                    this.drawSlot(sl, this.rgbnormal[sl.getType()]);
                }
            }
        }
        this.selectDim = dim;
        this.selectSlot(this.selectedSlot);
    }

    public Slot getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.missingPicture) {
            return new Dimension(320, 320);
        }
        return super.getPreferredSize();
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        int currentPosition = 0;
        currentPosition = orientation == 0 ? visibleRect.x : visibleRect.y;
        if (direction < 0) {
            int newPosition = currentPosition - currentPosition / this.maxUnitIncrement * this.maxUnitIncrement;
            return newPosition == 0 ? this.maxUnitIncrement : newPosition;
        }
        return (currentPosition / this.maxUnitIncrement + 1) * this.maxUnitIncrement - currentPosition;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.width - this.maxUnitIncrement;
        }
        return visibleRect.height - this.maxUnitIncrement;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public void setMaxUnitIncrement(int pixels) {
        this.maxUnitIncrement = pixels;
    }

    public int getPe() {
        return this.pe;
    }

    public int getBytes() {
        return this.memorySize;
    }

    public int getPixels() {
        return this.pixelsAvailable;
    }

    public int getNumLines() {
        return this.numLines;
    }

    public int getLineSize() {
        return this.lineScan;
    }

    public int getHPixels() {
        return this.horizontalPixels;
    }

    public Slot getMemorySlot(int x, int y) {
        int line = y / this.lineScan;
        int offset = y - line * this.lineScan;
        if (offset <= this.lineStart && line > 0 && this.crossReference[line * this.horizontalPixels + x] == this.crossReference[(line - 1) * this.horizontalPixels + x] || offset > this.lineStart + this.lineWidth && line < this.verticalPixels / this.lineScan && this.crossReference[line * this.horizontalPixels + x] == this.crossReference[(line + 1) * this.horizontalPixels + x]) {
            return this.crossReference[line * this.horizontalPixels + x];
        }
        if (offset <= this.lineStart || offset > this.lineStart + this.lineWidth) {
            return null;
        }
        return this.crossReference[line * this.horizontalPixels + x];
    }

    public void computeStatistics() {
        if (this.allocatedMemory[0] == 0) {
            int i;
            this.numAllocations[0] = this.data.size(0);
            for (i = 0; i < this.data.size(0); ++i) {
                Slot sl = this.data.elementAt(0, i);
                int n = sl.getType() + 1;
                this.numAllocations[n] = this.numAllocations[n] + 1;
                int n2 = sl.getType() + 1;
                this.allocatedMemory[n2] = this.allocatedMemory[n2] + sl.getSize();
                if (!sl.isLeak()) continue;
                int n3 = sl.getType() + 1;
                this.allocatedLeak[n3] = this.allocatedLeak[n3] + sl.getSize();
                int n4 = sl.getType() + 1;
                this.numLeaks[n4] = this.numLeaks[n4] + 1;
            }
            for (i = 0; i < 6; ++i) {
                this.numAllocations[0] = this.numAllocations[0] + this.numAllocations[i];
                this.allocatedLeak[0] = this.allocatedLeak[0] + this.allocatedLeak[i];
                this.numLeaks[0] = this.numLeaks[0] + this.numLeaks[i];
            }
        }
    }
}

