/*
 * Decompiled with CFR 0.152.
 */
package charm.debug;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class AllocationGraphDialog
extends JDialog
implements ActionListener,
DocumentListener {
    JComboBox peList;
    JTextField firstEvent;
    JTextField lastEvent;
    JLabel numEvents;
    JTextField barWidth;
    JTextField eventsPerBar;
    JLabel hPixels;
    JTextField vPixels;
    JButton ok;
    JButton cancel;
    boolean confirmed = false;

    AllocationGraphDialog(Frame parent, boolean modal, int nprocs) {
        super(parent, "Allocation Graph", modal);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel topPane = new JPanel();
        topPane.setLayout(new GridLayout(8, 2));
        JLabel textPeList = new JLabel("Processor number: ");
        topPane.add(textPeList);
        String[] pes = new String[nprocs];
        for (int i = 0; i < nprocs; ++i) {
            pes[i] = new Integer(i).toString();
        }
        this.peList = new JComboBox<String>(pes);
        this.peList.setSelectedIndex(0);
        topPane.add(this.peList);
        JLabel textFirstEvent = new JLabel("First event: ");
        topPane.add(textFirstEvent);
        this.firstEvent = new JTextField("1");
        this.firstEvent.addActionListener(this);
        this.firstEvent.getDocument().addDocumentListener(this);
        topPane.add(this.firstEvent);
        JLabel textLastEvent = new JLabel("Last event: ");
        topPane.add(textLastEvent);
        this.lastEvent = new JTextField("1");
        this.lastEvent.addActionListener(this);
        this.lastEvent.getDocument().addDocumentListener(this);
        topPane.add(this.lastEvent);
        JLabel textNumEvents = new JLabel("Total events: ");
        topPane.add(textNumEvents);
        int events = Integer.parseInt(this.lastEvent.getText()) - Integer.parseInt(this.firstEvent.getText()) + 1;
        this.numEvents = new JLabel("" + events);
        topPane.add(this.numEvents);
        JLabel textEventsPerBar = new JLabel("Events per bar: ");
        topPane.add(textEventsPerBar);
        this.eventsPerBar = new JTextField("1");
        this.eventsPerBar.addActionListener(this);
        this.eventsPerBar.getDocument().addDocumentListener(this);
        topPane.add(this.eventsPerBar);
        JLabel textBarWidth = new JLabel("Bar width: ");
        topPane.add(textBarWidth);
        this.barWidth = new JTextField("2");
        this.barWidth.addActionListener(this);
        this.barWidth.getDocument().addDocumentListener(this);
        topPane.add(this.barWidth);
        JLabel textHPixels = new JLabel("Horizontal pixels: ");
        topPane.add(textHPixels);
        int pixels = events * Integer.parseInt(this.barWidth.getText()) / Integer.parseInt(this.eventsPerBar.getText());
        this.hPixels = new JLabel("" + pixels);
        topPane.add(this.hPixels);
        JLabel textVPixels = new JLabel("Vertical pixels: ");
        topPane.add(textVPixels);
        this.vPixels = new JTextField("800");
        this.vPixels.addActionListener(this);
        topPane.add(this.vPixels);
        JPanel bottomPane = new JPanel();
        this.ok = new JButton("Ok");
        this.ok.setActionCommand("ok");
        this.ok.addActionListener(this);
        bottomPane.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.setActionCommand("cancel");
        this.cancel.addActionListener(this);
        bottomPane.add(this.cancel);
        this.getContentPane().add(topPane);
        this.getContentPane().add(bottomPane);
        this.pack();
        this.setResizable(false);
        this.setVisible(true);
    }

    public boolean confirmed() {
        return this.confirmed;
    }

    public int getPe() {
        return this.peList.getSelectedIndex();
    }

    public int getFirstEvent() {
        return Integer.parseInt(this.firstEvent.getText());
    }

    public int getLastEvent() {
        return Integer.parseInt(this.lastEvent.getText());
    }

    public int getEventsPerBar() {
        return Integer.parseInt(this.eventsPerBar.getText());
    }

    public int getBarWidth() {
        return Integer.parseInt(this.barWidth.getText());
    }

    @Override
    public int getWidth() {
        return Integer.parseInt(this.vPixels.getText());
    }

    @Override
    public int getHeight() {
        return Integer.parseInt(this.vPixels.getText());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ok") || e.getSource() == this.firstEvent || e.getSource() == this.lastEvent || e.getSource() == this.eventsPerBar || e.getSource() == this.barWidth || e.getSource() == this.vPixels) {
            try {
                if (this.peList.getSelectedIndex() >= 0 && Integer.parseInt(this.firstEvent.getText()) >= 0 && Integer.parseInt(this.lastEvent.getText()) >= Integer.parseInt(this.firstEvent.getText()) && Integer.parseInt(this.eventsPerBar.getText()) > 0 && Integer.parseInt(this.barWidth.getText()) > 0 && Integer.parseInt(this.vPixels.getText()) > 10) {
                    this.confirmed = true;
                    this.setVisible(false);
                } else if (Integer.parseInt(this.firstEvent.getText()) < 0) {
                    JOptionPane.showMessageDialog(this, "The first event must be positive", "Error", 0);
                    this.firstEvent.requestFocus();
                } else if (Integer.parseInt(this.lastEvent.getText()) < Integer.parseInt(this.firstEvent.getText())) {
                    JOptionPane.showMessageDialog(this, "The last event must be greater than the first event", "Error", 0);
                    this.lastEvent.requestFocus();
                } else if (Integer.parseInt(this.eventsPerBar.getText()) <= 0) {
                    JOptionPane.showMessageDialog(this, "The number of events per bar must be positive", "Error", 0);
                    this.eventsPerBar.requestFocus();
                } else if (Integer.parseInt(this.barWidth.getText()) <= 0) {
                    JOptionPane.showMessageDialog(this, "The width of the bars must be positive", "Error", 0);
                    this.barWidth.requestFocus();
                } else if (Integer.parseInt(this.vPixels.getText()) <= 10) {
                    JOptionPane.showMessageDialog(this, "The number of vertical pixels must be greater than 10", "Error", 0);
                    this.vPixels.requestFocus();
                }
            }
            catch (NumberFormatException ne) {
                JOptionPane.showMessageDialog(this, "All values must be positive integers", "Error", 0);
            }
        }
        if (e.getActionCommand().equals("cancel")) {
            this.setVisible(false);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updatePixels();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updatePixels();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    private void updatePixels() {
        try {
            int first = Integer.parseInt(this.firstEvent.getText());
            int last = Integer.parseInt(this.lastEvent.getText());
            if (first < 0 || last <= first) {
                throw new NumberFormatException();
            }
            int events = last - first;
            this.numEvents.setText("" + events);
        }
        catch (NumberFormatException ne) {
            this.numEvents.setText("??");
        }
        try {
            int events = Integer.parseInt(this.numEvents.getText());
            int size = Integer.parseInt(this.barWidth.getText());
            int epb = Integer.parseInt(this.eventsPerBar.getText());
            if (size <= 0 || epb <= 0) {
                throw new NumberFormatException();
            }
            int pixels = events * size / epb;
            this.hPixels.setText("" + pixels);
        }
        catch (NumberFormatException ne) {
            this.hPixels.setText("??");
        }
    }
}

