      SUBROUTINE DAXPY(N,DA,DX,INCX,DY,INCY)
C                                                                        
C     OVERWRITE DOUBLE PRECISION DY WITH DOUBLE PRECISION DA*DX + DY.    
C     FOR I = 0 TO N-1, REPLACE  DY(LY+I*INCY) WITH DA*DX(LX+I*INCX) +
C       DY(LY+I*INCY), WHERE LX = 1 IF INCX .GE. 0, ELSE LX = (-INCX)*N,
C       AND LY IS DEFINED IN A SIMILAR WAY USING INCY.
C                                                                        
      DOUBLE PRECISION DX(1),DY(1),DA                                    
      IF(N.LE.0.OR.DA.EQ.0.D0) RETURN                                    
      IF(INCX.EQ.INCY) IF(INCX-1) 5,20,60                                
    5 CONTINUE                                                           
C                                                                        
C        CODE FOR NONEQUAL OR NONPOSITIVE INCREMENTS.                    
C                                                                        
      IX = 1                                                             
      IY = 1                                                             
      IF(INCX.LT.0)IX = (-N+1)*INCX + 1                                  
      IF(INCY.LT.0)IY = (-N+1)*INCY + 1                                  
      DO 10 I = 1,N                                                      
        DY(IY) = DY(IY) + DA*DX(IX)                                      
        IX = IX + INCX                                                   
        IY = IY + INCY                                                   
   10 CONTINUE                                                           
      RETURN                                                             
C                                                                        
C        CODE FOR BOTH INCREMENTS EQUAL TO 1                             
C                                                                        
C                                                                        
C        CLEAN-UP LOOP SO REMAINING VECTOR LENGTH IS A MULTIPLE OF 4.    
C                                                                        
   20 M = MOD(N,4)
      IF( M .EQ. 0 ) GO TO 40                                            
      DO 30 I = 1,M                                                      
        DY(I) = DY(I) + DA*DX(I)                                         
   30 CONTINUE                                                           
      IF( N .LT. 4 ) RETURN                                              
   40 MP1 = M + 1                                                        
      DO 50 I = MP1,N,4                                                  
        DY(I) = DY(I) + DA*DX(I)                                         
        DY(I + 1) = DY(I + 1) + DA*DX(I + 1)                            
        DY(I + 2) = DY(I + 2) + DA*DX(I + 2)                             
        DY(I + 3) = DY(I + 3) + DA*DX(I + 3)                             
   50 CONTINUE                                                           
      RETURN                                                             
C                                                                        
C        CODE FOR EQUAL, POSITIVE, NONUNIT INCREMENTS.                   
C                                                                        
   60 CONTINUE                                                           
      NS = N*INCX                                                        
          DO 70 I=1,NS,INCX                                              
          DY(I) = DA*DX(I) + DY(I)                                       
   70     CONTINUE                                                       
      RETURN                                                             
      END                                                                
