/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.properties;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.xmind.ui.dialogs.PopupFilteredList;
import org.xmind.ui.properties.PropertyEditor;

public class MultiChoicePropertyEditor
extends PropertyEditor {
    private boolean filterable;
    private boolean allowsCustomizedValues;
    private Object input = null;
    private IStructuredContentProvider contentProvider = null;
    private ILabelProvider labelProvider = null;
    private Menu menu = null;
    private PopupFilteredList filterableList = null;
    private PopupFilteredList.PatternFilter patternFilter = null;
    private PopupFilteredList.IElementCreator elementCreator = null;
    private Object selectedElement = null;
    private long stamp_valueChangedByMenuItemSelection = 0L;
    private long stamp_valueChangedByListSelection = 0L;
    private Listener menuItemListener = new Listener(){

        public void handleEvent(Event event) {
            final long stamp = System.currentTimeMillis();
            MultiChoicePropertyEditor.this.stamp_valueChangedByMenuItemSelection = stamp;
            Display.getCurrent().timerExec(50, new Runnable(){

                @Override
                public void run() {
                    if (MultiChoicePropertyEditor.this.stamp_valueChangedByMenuItemSelection == stamp) {
                        MultiChoicePropertyEditor.this.stamp_valueChangedByMenuItemSelection = 0L;
                    }
                }
            });
            Object element = event.widget.getData();
            MultiChoicePropertyEditor.this.changeValue(element);
            MultiChoicePropertyEditor.this.fireApplyEditorValue();
        }
    };

    public MultiChoicePropertyEditor() {
        this(false, false);
    }

    public MultiChoicePropertyEditor(boolean filterable, boolean allowsCustomizedValues) {
        this.filterable = filterable;
        this.allowsCustomizedValues = allowsCustomizedValues;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setLabelProvider(ILabelProvider labelProvider) {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        this.labelProvider = labelProvider;
    }

    public void setPatternFilter(PopupFilteredList.PatternFilter patternFilter) {
        this.patternFilter = patternFilter;
    }

    public void setElementCreator(PopupFilteredList.IElementCreator elementCreator) {
        this.elementCreator = elementCreator;
    }

    @Override
    protected Control createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new FillLayout());
        composite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                MultiChoicePropertyEditor.this.handleDispose();
            }
        });
        return composite;
    }

    private void handleDispose() {
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
            this.labelProvider = null;
        }
    }

    @Override
    protected void setValueToWidget(Object value) {
        this.selectedElement = value;
    }

    @Override
    protected void activateWidget() {
        super.activateWidget();
        if (this.filterable) {
            this.showFilterableList();
        } else {
            this.showMenu();
        }
    }

    @Override
    public void setFocus() {
        if (!this.isShowingWidget()) {
            super.setFocus();
        }
    }

    private boolean isShowingWidget() {
        if (this.menu != null && !this.menu.isDisposed() && this.menu.isVisible()) {
            return true;
        }
        return this.filterableList != null && this.filterableList.getShell() != null && !this.filterableList.getShell().isDisposed() && this.filterableList.getShell().isVisible();
    }

    private void showMenu() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        if (this.menu == null || this.menu.isDisposed()) {
            this.menu = this.createMenu();
        }
        this.updateMenu(this.menu);
        if (this.menu.getItemCount() == 0) {
            return;
        }
        this.menu.setLocation(this.calculateMenuLocation());
        this.menu.setVisible(true);
    }

    private Menu createMenu() {
        Menu menu = new Menu((Decorations)this.getControl().getShell(), 8);
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                MultiChoicePropertyEditor.this.stamp_valueChangedByMenuItemSelection = 0L;
            }

            public void menuHidden(MenuEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MultiChoicePropertyEditor.this.getControl() == null || MultiChoicePropertyEditor.this.getControl().isDisposed()) {
                            return;
                        }
                        if (MultiChoicePropertyEditor.this.stamp_valueChangedByMenuItemSelection == 0L) {
                            MultiChoicePropertyEditor.this.fireCancelEditing();
                        }
                        MultiChoicePropertyEditor.this.stamp_valueChangedByMenuItemSelection = 0L;
                    }
                });
            }
        });
        return menu;
    }

    private void updateMenu(Menu menu) {
        Object[] elements = this.getElements();
        MenuItem[] oldItems = menu.getItems();
        int i = 0;
        while (i < elements.length) {
            Object data;
            MenuItem item;
            Object element = elements[i];
            MenuItem menuItem = item = i < oldItems.length ? oldItems[i] : null;
            if (item != null && element != (data = item.getData()) && (element == null || element.equals(data))) {
                item.dispose();
                item = null;
            }
            if (item == null) {
                item = new MenuItem(menu, 16, i);
                item.setData(element);
                item.addListener(13, this.menuItemListener);
            }
            item.setText(this.getText(element));
            item.setImage(this.getImage(element));
            item.setSelection(element == this.selectedElement || element != null && element.equals(this.selectedElement));
            ++i;
        }
    }

    private void showFilterableList() {
        if (this.getControl() == null || this.getControl().isDisposed()) {
            return;
        }
        if (this.filterableList == null) {
            this.filterableList = new PopupFilteredList(this.getControl().getShell(), 16);
            this.filterableList.setPermitsUnprovidedElement(this.allowsCustomizedValues);
            this.filterableList.setElementCreator(this.elementCreator);
            this.filterableList.addOpenListener(new IOpenListener(){

                public void open(OpenEvent event) {
                    final long stamp = System.currentTimeMillis();
                    MultiChoicePropertyEditor.this.stamp_valueChangedByListSelection = stamp;
                    Display.getCurrent().timerExec(50, new Runnable(){

                        @Override
                        public void run() {
                            if (MultiChoicePropertyEditor.this.stamp_valueChangedByListSelection == stamp) {
                                MultiChoicePropertyEditor.this.stamp_valueChangedByListSelection = 0L;
                            }
                        }
                    });
                    Object element = ((IStructuredSelection)event.getSelection()).getFirstElement();
                    MultiChoicePropertyEditor.this.changeValue(element);
                    MultiChoicePropertyEditor.this.fireApplyEditorValue();
                }
            });
        }
        this.filterableList.setPatternFilter(this.patternFilter);
        this.filterableList.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return MultiChoicePropertyEditor.this.getElements();
            }
        });
        this.filterableList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                return MultiChoicePropertyEditor.this.getImage(element);
            }

            public String getText(Object element) {
                return MultiChoicePropertyEditor.this.getText(element);
            }
        });
        this.filterableList.setDefaultSelection(this.selectedElement);
        this.filterableList.setInput(this.input);
        this.filterableList.setBoundsReference(this.calculateListReferenceBounds());
        this.filterableList.create();
        this.filterableList.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (MultiChoicePropertyEditor.this.getControl() == null || MultiChoicePropertyEditor.this.getControl().isDisposed()) {
                            return;
                        }
                        if (MultiChoicePropertyEditor.this.stamp_valueChangedByListSelection == 0L) {
                            MultiChoicePropertyEditor.this.fireCancelEditing();
                        }
                        MultiChoicePropertyEditor.this.stamp_valueChangedByListSelection = 0L;
                    }
                });
            }
        });
        this.stamp_valueChangedByListSelection = 0L;
        this.filterableList.open();
    }

    private String getText(Object element) {
        if (this.labelProvider != null) {
            return this.labelProvider.getText(element);
        }
        if (element == null) {
            return "";
        }
        return element.toString();
    }

    private Image getImage(Object element) {
        if (this.labelProvider != null) {
            return this.labelProvider.getImage(element);
        }
        return null;
    }

    private Object[] getElements() {
        if (this.contentProvider != null) {
            return this.contentProvider.getElements(this.input);
        }
        return new Object[0];
    }

    private Point calculateMenuLocation() {
        return this.getControl().toDisplay(0, 0);
    }

    private Rectangle calculateListReferenceBounds() {
        Rectangle r = this.getControl().getBounds();
        Point loc = this.getControl().toDisplay(0, 0);
        return new Rectangle(loc.x, loc.y - r.height, r.width, r.height);
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setBackground(color);
        }
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setForeground(color);
        }
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setFont(font);
        }
    }
}

