/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.mindmap;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.xmind.core.ITopic;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventRegister;
import org.xmind.gef.EditDomain;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.ui.mindmap.AbstractInfoItemContributor;
import org.xmind.ui.mindmap.IDrillDownTraceService;
import org.xmind.ui.mindmap.IInfoPart;
import org.xmind.ui.mindmap.ITopicPart;

public class DrillDownInfoItemContributor
extends AbstractInfoItemContributor {
    @Override
    public IAction createAction(ITopicPart topicPart, ITopic topic) {
        IViewer viewer = topicPart.getSite().getViewer();
        if (viewer != null && this.hasTraceService(viewer) && !topic.equals(viewer.getAdapter(ITopic.class)) && !topic.getChildren("detached").isEmpty()) {
            return new IconTipDrillDownAction(viewer, topic);
        }
        return null;
    }

    @Override
    public String getSVGFilePath(ITopic topic, IAction action) {
        return "platform:/plugin/org.xmind.ui.mindmap/icons/drill_down.svg";
    }

    private boolean hasTraceService(IViewer viewer) {
        if (viewer instanceof IGraphicalViewer) {
            return ((IGraphicalViewer)viewer).getService(IDrillDownTraceService.class) != null;
        }
        return false;
    }

    @Override
    protected void registerTopicEvent(ITopicPart topicPart, ITopic topic, ICoreEventRegister register) {
        register.register("topicAdd");
        register.register("topicRemove");
    }

    @Override
    protected void handleTopicEvent(IInfoPart infoPart, CoreEvent event) {
    }

    @Override
    protected void handleTopicEvent(ITopicPart topicPart, CoreEvent event) {
        if ("detached".equals(event.getData())) {
            topicPart.refresh();
        }
    }

    private static class IconTipDrillDownAction
    extends Action {
        private IViewer viewer;
        private ITopic topic;

        public IconTipDrillDownAction(IViewer viewer, ITopic topic) {
            this.viewer = viewer;
            this.topic = topic;
        }

        public void run() {
            EditDomain domain = this.viewer.getEditDomain();
            if (domain == null) {
                return;
            }
            IPart part = this.viewer.findPart((Object)this.topic);
            if (part == null) {
                return;
            }
            Request request = new Request("drill_down");
            request.setViewer(this.viewer);
            request.setPrimaryTarget(part);
            domain.handleRequest(request);
        }
    }
}

