/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.xmind.gef.draw2d.IAnchor;
import org.xmind.gef.draw2d.IAnchorListener;
import org.xmind.gef.draw2d.IReferencedFigure;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;

public abstract class AbstractAnchor
implements IAnchor,
FigureListener,
FreeformListener,
PropertyChangeListener {
    private List<IAnchorListener> listeners = null;
    private IFigure owner;
    private Set<String> propertiesToMove = null;

    protected AbstractAnchor() {
    }

    public AbstractAnchor(IFigure owner) {
        this.setOwner(owner);
    }

    protected void setOwner(IFigure owner) {
        if (owner == this.owner) {
            return;
        }
        if (this.getOwner() != null && this.hasAnchorListener()) {
            this.unhookOwner(this.getOwner());
        }
        this.owner = owner;
        if (this.getOwner() != null && this.hasAnchorListener()) {
            this.hookOwner(this.getOwner());
        }
    }

    protected void hookOwner(IFigure owner) {
        owner.addFigureListener((FigureListener)this);
        if (owner instanceof FreeformFigure) {
            ((FreeformFigure)owner).addFreeformListener((FreeformListener)this);
        }
        if (this.propertiesToMove != null) {
            for (String property : this.propertiesToMove) {
                owner.addPropertyChangeListener(property, (PropertyChangeListener)this);
            }
        }
    }

    protected void unhookOwner(IFigure owner) {
        owner.removeFigureListener((FigureListener)this);
        if (owner instanceof FreeformFigure) {
            ((FreeformFigure)owner).removeFreeformListener((FreeformListener)this);
        }
        if (this.propertiesToMove != null) {
            for (String property : this.propertiesToMove) {
                owner.removePropertyChangeListener(property, (PropertyChangeListener)this);
            }
        }
    }

    public PrecisionPoint getLocation(int orientation, double expansion) {
        switch (orientation) {
            case 8: {
                return this.getWest(expansion);
            }
            case 4: {
                return this.getSouth(expansion);
            }
            case 1: {
                return this.getNorth(expansion);
            }
        }
        return this.getEast(expansion);
    }

    protected PrecisionPoint getEast(double expansion) {
        PrecisionPoint ref = this.getReferencePoint();
        return this.getLocation(ref.x + 100.0, ref.y, expansion);
    }

    protected PrecisionPoint getNorth(double expansion) {
        PrecisionPoint ref = this.getReferencePoint();
        return this.getLocation(ref.x, ref.y - 100.0, expansion);
    }

    protected PrecisionPoint getSouth(double expansion) {
        PrecisionPoint ref = this.getReferencePoint();
        return this.getLocation(ref.x, ref.y + 100.0, expansion);
    }

    protected PrecisionPoint getWest(double expansion) {
        PrecisionPoint ref = this.getReferencePoint();
        return this.getLocation(ref.x - 100.0, ref.y, expansion);
    }

    public PrecisionPoint getLocation(PrecisionPoint reference, double expansion) {
        return this.getLocation(reference.x, reference.y, expansion);
    }

    public void addAnchorListener(IAnchorListener listener) {
        boolean hadListener = this.hasAnchorListener();
        if (this.listeners == null) {
            this.listeners = new ArrayList<IAnchorListener>();
        }
        this.listeners.add(listener);
        if (!hadListener && this.hasAnchorListener() && this.getOwner() != null) {
            this.hookOwner(this.getOwner());
        }
    }

    public IFigure getOwner() {
        return this.owner;
    }

    public PrecisionPoint getReferencePoint() {
        if (this.getOwner() == null) {
            return new PrecisionPoint();
        }
        if (this.getOwner() instanceof IReferencedFigure) {
            return new PrecisionPoint(((IReferencedFigure)this.getOwner()).getReference());
        }
        Rectangle r = this.getOwner().getBounds();
        return new PrecisionPoint((double)r.x + (double)r.width * 0.5, (double)r.y + (double)r.height * 0.5);
    }

    public void removeAnchorListener(IAnchorListener listener) {
        if (this.listeners == null) {
            return;
        }
        boolean hadListener = this.hasAnchorListener();
        this.listeners.remove(listener);
        if (hadListener && !this.hasAnchorListener() && this.getOwner() != null) {
            this.unhookOwner(this.getOwner());
        }
    }

    public void figureMoved(IFigure source) {
        this.fireAnchorMoved();
    }

    public void notifyFreeformExtentChanged() {
        this.fireAnchorMoved();
    }

    protected void fireAnchorMoved() {
        if (this.listeners == null) {
            return;
        }
        Object[] objectArray = this.listeners.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IAnchorListener)listener).anchorMoved(this);
            ++n2;
        }
    }

    protected boolean hasAnchorListener() {
        return this.listeners != null && !this.listeners.isEmpty();
    }

    public void addAnchorMoveProperty(String ... properties) {
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            this.addMoveProperty(property);
            ++n2;
        }
        this.fireAnchorMoved();
    }

    private void addMoveProperty(String property) {
        if (this.propertiesToMove == null) {
            this.propertiesToMove = new HashSet<String>();
        }
        if (!this.propertiesToMove.contains(property)) {
            if (this.getOwner() != null && this.hasAnchorListener()) {
                this.getOwner().addPropertyChangeListener(property, (PropertyChangeListener)this);
            }
            this.propertiesToMove.add(property);
        }
    }

    public void removeAnchorMoveProperty(String ... properties) {
        if (this.propertiesToMove == null) {
            return;
        }
        String[] stringArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            String property = stringArray[n2];
            this.removeMoveProperty(property);
            ++n2;
        }
        this.fireAnchorMoved();
    }

    private void removeMoveProperty(String property) {
        if (this.getOwner() != null) {
            this.getOwner().removePropertyChangeListener(property, (PropertyChangeListener)this);
        }
        this.propertiesToMove.remove(property);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.fireAnchorMoved();
    }
}

