/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.print.ui;

import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.List;
import org.netbeans.modules.print.ui.Paper;
import org.netbeans.modules.print.util.Config;
import org.netbeans.modules.print.util.UI;

final class Printer
implements Printable {
    private List<Paper> myPapers;

    Printer() {
    }

    void print(List<Paper> list) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        this.myPapers = list;
        if (printerJob == null) {
            return;
        }
        printerJob.setPrintable(this, Config.getDefault().getPageFormat());
        try {
            if (printerJob.printDialog()) {
                printerJob.print();
            }
        }
        catch (PrinterException printerException) {
            UI.printError(UI.i18n(Printer.class, "ERR_Printer_Problem", printerException.getLocalizedMessage()));
        }
        this.myPapers = null;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n == this.myPapers.size()) {
            return 1;
        }
        this.myPapers.get(n).print(graphics);
        return 0;
    }
}

