/*
 * Decompiled with CFR 0.152.
 */
package spin.off;

import javax.swing.SwingUtilities;
import spin.Evaluator;
import spin.Invocation;
import spin.off.AWTReflectDispatcherFactory;
import spin.off.Dispatcher;
import spin.off.DispatcherFactory;
import spin.off.SimpleStarter;
import spin.off.Starter;

public class SpinOffEvaluator
extends Evaluator {
    private static DispatcherFactory defaultDispatcherFactory = new AWTReflectDispatcherFactory();
    private static Starter defaultStarter = new SimpleStarter();
    private DispatcherFactory dispatcherFactory;
    private Starter starter;

    public SpinOffEvaluator() {
        this(defaultDispatcherFactory, defaultStarter);
    }

    public SpinOffEvaluator(DispatcherFactory dispatcherFactory) {
        this(dispatcherFactory, defaultStarter);
    }

    public SpinOffEvaluator(Starter starter) {
        this(defaultDispatcherFactory, starter);
    }

    public SpinOffEvaluator(DispatcherFactory dispatcherFactory, Starter starter) {
        this.dispatcherFactory = dispatcherFactory;
        this.starter = starter;
    }

    public final void evaluate(final Invocation invocation) throws Throwable {
        if (SwingUtilities.isEventDispatchThread()) {
            final Dispatcher dispatcher = this.dispatcherFactory.createDispatcher();
            this.starter.start(new Runnable(){

                public void run() {
                    invocation.evaluate();
                    dispatcher.stop();
                }
            });
            dispatcher.start();
            if (!invocation.isEvaluated()) {
                throw new Error("dispatcher stopped prematurely");
            }
        } else {
            invocation.evaluate();
        }
    }

    public static DispatcherFactory getDefaultDispatcherFactory() {
        return defaultDispatcherFactory;
    }

    public static void setDefaultDispatcherFactory(DispatcherFactory dispatcherFactory) {
        defaultDispatcherFactory = dispatcherFactory;
    }

    public static Starter getDefaultStarter() {
        return defaultStarter;
    }

    public static void setDefaultStarter(Starter starter) {
        defaultStarter = starter;
    }
}

