/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.pdf;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jabref.logic.pdf.PdfAnnotationImporter;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.metadata.FileDirectoryPreferences;
import org.jabref.model.pdf.FileAnnotation;

public class EntryAnnotationImporter {
    private final BibEntry entry;

    public EntryAnnotationImporter(BibEntry entry) {
        this.entry = entry;
    }

    private List<LinkedFile> getFilteredFileList() {
        return this.entry.getFiles().stream().filter(parsedFileField -> parsedFileField.getFileType().equalsIgnoreCase("pdf")).filter(parsedFileField -> !parsedFileField.isOnlineLink()).collect(Collectors.toList());
    }

    public Map<Path, List<FileAnnotation>> importAnnotationsFromFiles(BibDatabaseContext databaseContext, FileDirectoryPreferences fileDirectoryPreferences) {
        HashMap<Path, List<FileAnnotation>> annotations = new HashMap<Path, List<FileAnnotation>>();
        PdfAnnotationImporter importer = new PdfAnnotationImporter();
        for (LinkedFile linkedFile : this.getFilteredFileList()) {
            linkedFile.findIn(databaseContext, fileDirectoryPreferences).ifPresent(file -> annotations.put((Path)file, importer.importAnnotations((Path)file)));
        }
        return annotations;
    }
}

