/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.net;

import com.mashape.unirest.http.Unirest;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.jabref.logic.net.ProgressInputStream;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.util.FileHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLDownload {
    public static final String USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0";
    private static final Logger LOGGER = LoggerFactory.getLogger(URLDownload.class);
    private final URL source;
    private final Map<String, String> parameters = new HashMap<String, String>();
    private String postData = "";

    public URLDownload(String source) throws MalformedURLException {
        this(new URL(source));
    }

    public URLDownload(URL source) {
        this.source = source;
        this.addHeader("User-Agent", USER_AGENT);
    }

    public static void bypassSSLVerification() {
        LOGGER.warn("Fix SSL exceptions by accepting ALL certificates");
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(context.getSocketFactory());
        }
        catch (Exception e) {
            LOGGER.error("A problem occurred when bypassing SSL verification", e);
        }
    }

    public URL getSource() {
        return this.source;
    }

    public String getMimeType() {
        String contentType;
        Unirest.setDefaultHeader("User-Agent", "Mozilla/5.0 (Windows; U; WindowsNT 5.1; en-US; rv1.8.1.6) Gecko/20070725 Firefox/2.0.0.6");
        try {
            contentType = (String)((List)Unirest.head(this.source.toString()).asString().getHeaders().get("Content-Type")).get(0);
            if (contentType != null && !contentType.isEmpty()) {
                return contentType;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error getting MIME type of URL via HEAD request", e);
        }
        try {
            contentType = (String)((List)Unirest.get(this.source.toString()).asString().getHeaders().get("Content-Type")).get(0);
            if (contentType != null && !contentType.isEmpty()) {
                return contentType;
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error getting MIME type of URL via GET request", e);
        }
        try {
            URLConnection connection = new URL(this.source.toString()).openConnection();
            contentType = connection.getContentType();
            if (contentType != null && !contentType.isEmpty()) {
                return contentType;
            }
        }
        catch (IOException e) {
            LOGGER.debug("Error trying to get MIME type of local URI", e);
        }
        return "";
    }

    public boolean isMimeType(String type) {
        String mime = this.getMimeType();
        if (mime.isEmpty()) {
            return false;
        }
        return mime.startsWith(type);
    }

    public boolean isPdf() {
        return this.isMimeType("application/pdf");
    }

    public void addHeader(String key, String value) {
        this.parameters.put(key, value);
    }

    public void setPostData(String postData) {
        if (postData != null) {
            this.postData = postData;
        }
    }

    public String asString(Charset encoding) throws IOException {
        Throwable throwable = null;
        try (BufferedInputStream input = new BufferedInputStream(this.openConnection().getInputStream());){
            String string;
            StringWriter output = new StringWriter();
            Throwable throwable2 = null;
            try {
                this.copy(input, output, encoding);
                string = ((Object)output).toString();
            }
            catch (Throwable throwable3) {
                try {
                    try {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        URLDownload.$closeResource(throwable2, output);
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            URLDownload.$closeResource(throwable2, output);
            return string;
        }
    }

    public String asString() throws IOException {
        return this.asString(StandardCharsets.UTF_8);
    }

    public List<HttpCookie> getCookieFromUrl() throws IOException {
        CookieManager cookieManager = new CookieManager();
        CookieHandler.setDefault(cookieManager);
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        URLConnection con = this.openConnection();
        con.getHeaderFields();
        try {
            return cookieManager.getCookieStore().get(this.source.toURI());
        }
        catch (URISyntaxException e) {
            LOGGER.error("Unable to convert download URL to URI", e);
            return Collections.emptyList();
        }
    }

    public void toFile(Path destination) throws IOException {
        try (BufferedInputStream input = new BufferedInputStream(this.openConnection().getInputStream());){
            Files.copy(input, destination, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            LOGGER.warn("Could not copy input", e);
            throw e;
        }
    }

    public ProgressInputStream asInputStream() throws IOException {
        URLConnection urlConnection = this.openConnection();
        long fileSize = urlConnection.getContentLength();
        return new ProgressInputStream(new BufferedInputStream(urlConnection.getInputStream()), fileSize);
    }

    public Path toTemporaryFile() throws IOException {
        String sourcePath = this.source.getPath();
        String fileNameWithExtension = sourcePath.substring(sourcePath.lastIndexOf(47) + 1);
        String fileName = FileUtil.getBaseName(fileNameWithExtension);
        String extension = "." + FileHelper.getFileExtension(fileNameWithExtension).orElse("tmp");
        Path file = Files.createTempFile(fileName, extension, new FileAttribute[0]);
        this.toFile(file);
        return file;
    }

    public String toString() {
        return "URLDownload{source=" + this.source + '}';
    }

    private void copy(InputStream in, Writer out, Charset encoding) throws IOException {
        InputStream monitoredInputStream = in;
        InputStreamReader r = new InputStreamReader(monitoredInputStream, encoding);
        try (BufferedReader read = new BufferedReader(r);){
            String line;
            while ((line = read.readLine()) != null) {
                out.write(line);
                out.write("\n");
            }
        }
    }

    private URLConnection openConnection() throws IOException {
        int status;
        URLConnection connection = this.source.openConnection();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (!this.postData.isEmpty()) {
            connection.setDoOutput(true);
            Throwable throwable = null;
            try (DataOutputStream wr = new DataOutputStream(connection.getOutputStream());){
                wr.writeBytes(this.postData);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        if (connection instanceof HttpURLConnection && (status = ((HttpURLConnection)connection).getResponseCode()) != 200 && (status == 302 || status == 301 || status == 303)) {
            String string = connection.getHeaderField("Location");
            connection = new URLDownload(string).openConnection();
        }
        connection.connect();
        return connection;
    }
}

