/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.journals;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.jabref.logic.journals.Abbreviation;
import org.jabref.logic.util.OS;

public class AbbreviationWriter {
    private AbbreviationWriter() {
    }

    public static void writeOrCreate(Path path, List<Abbreviation> abbreviations, Charset encoding) throws IOException {
        try (OutputStream outStream = Files.newOutputStream(path, new OpenOption[0]);
             OutputStreamWriter writer = new OutputStreamWriter(outStream, encoding);){
            for (Abbreviation entry : abbreviations) {
                writer.write(entry.getName());
                writer.write(" = ");
                writer.write(entry.getAbbreviation());
                writer.write(OS.NEWLINE);
            }
        }
    }
}

