/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.importer.fetcher;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.http.client.utils.URIBuilder;
import org.jabref.logic.cleanup.MoveFieldCleanup;
import org.jabref.logic.formatter.bibtexfields.ClearFormatter;
import org.jabref.logic.formatter.bibtexfields.NormalizeNamesFormatter;
import org.jabref.logic.formatter.bibtexfields.RemoveBracesFormatter;
import org.jabref.logic.formatter.bibtexfields.RemoveNewlinesFormatter;
import org.jabref.logic.help.HelpFile;
import org.jabref.logic.importer.EntryBasedParserFetcher;
import org.jabref.logic.importer.FetcherException;
import org.jabref.logic.importer.IdBasedParserFetcher;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ParseException;
import org.jabref.logic.importer.Parser;
import org.jabref.logic.importer.SearchBasedParserFetcher;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.cleanup.FieldFormatterCleanup;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.util.DummyFileUpdateMonitor;
import org.jsoup.helper.StringUtil;

public class AstrophysicsDataSystem
implements IdBasedParserFetcher,
SearchBasedParserFetcher,
EntryBasedParserFetcher {
    private static String API_QUERY_URL = "http://adsabs.harvard.edu/cgi-bin/nph-basic_connect";
    private static String API_ENTRY_URL = "http://adsabs.harvard.edu/cgi-bin/nph-abs_connect";
    private static String API_DOI_URL = "http://adsabs.harvard.edu/doi/";
    private final String patternRemoveDOI = "^(doi:|DOI:)";
    private final ImportFormatPreferences preferences;

    public AstrophysicsDataSystem(ImportFormatPreferences preferences) {
        this.preferences = Objects.requireNonNull(preferences);
    }

    @Override
    public String getName() {
        return "SAO/NASA Astrophysics Data System";
    }

    private URIBuilder getBaseUrl(String apiUrl) throws URISyntaxException {
        URIBuilder uriBuilder = new URIBuilder(apiUrl);
        uriBuilder.addParameter("data_type", "BIBTEXPLUS");
        uriBuilder.addParameter("start_nr", String.valueOf(1));
        uriBuilder.addParameter("nr_to_return", String.valueOf(200));
        return uriBuilder;
    }

    @Override
    public URL getURLForQuery(String query) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = this.getBaseUrl(API_QUERY_URL);
        uriBuilder.addParameter("qsearch", query);
        return uriBuilder.build().toURL();
    }

    @Override
    public URL getURLForEntry(BibEntry entry) throws URISyntaxException, MalformedURLException, FetcherException {
        URIBuilder uriBuilder = this.getBaseUrl(API_ENTRY_URL);
        uriBuilder.addParameter("db_key", "AST");
        uriBuilder.addParameter("db_key", "PHY");
        uriBuilder.addParameter("db_key", "PRE");
        entry.getFieldOrAlias("title").ifPresent(title -> {
            uriBuilder.addParameter("ttl_logic", "OR");
            uriBuilder.addParameter("title", (String)title);
            uriBuilder.addParameter("ttl_syn", "YES");
            uriBuilder.addParameter("ttl_wt", "0.3");
            uriBuilder.addParameter("ttl_wgt", "YES");
        });
        entry.getFieldOrAlias("author").ifPresent(author -> {
            uriBuilder.addParameter("aut_logic", "OR");
            uriBuilder.addParameter("author", (String)author);
            uriBuilder.addParameter("aut_syn", "YES");
            uriBuilder.addParameter("aut_wt", "1.0");
            uriBuilder.addParameter("aut_wgt", "YES");
        });
        return uriBuilder.build().toURL();
    }

    @Override
    public URL getURLForID(String identifier) throws URISyntaxException, MalformedURLException, FetcherException {
        String key = identifier.replaceAll("^(doi:|DOI:)", "");
        URIBuilder uriBuilder = new URIBuilder(API_DOI_URL + key);
        uriBuilder.addParameter("data_type", "BIBTEXPLUS");
        return uriBuilder.build().toURL();
    }

    @Override
    public HelpFile getHelpPage() {
        return HelpFile.FETCHER_ADS;
    }

    @Override
    public Parser getParser() {
        return new BibtexParser(this.preferences, new DummyFileUpdateMonitor());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<BibEntry> performSearch(String query) throws FetcherException {
        if (StringUtil.isBlank(query)) {
            return Collections.emptyList();
        }
        try {
            URLConnection connection = this.getURLForQuery(query).openConnection();
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:56.0) Gecko/20100101 Firefox/56.0");
            try (InputStream stream = connection.getInputStream();){
                List<BibEntry> fetchedEntries = this.getParser().parseEntries(stream);
                fetchedEntries.forEach(this::doPostCleanup);
                List<BibEntry> list = fetchedEntries;
                return list;
            }
            catch (IOException e) {
                throw new FetcherException("An I/O exception occurred", e);
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new FetcherException("Search URI is malformed", e);
        }
        catch (IOException e) {
            throw new FetcherException("An I/O exception occurred", e);
        }
        catch (ParseException e) {
            throw new FetcherException("Error occurred when parsing entry", Localization.lang("Error occurred when parsing entry", new String[0]), e);
        }
    }

    @Override
    public void doPostCleanup(BibEntry entry) {
        new FieldFormatterCleanup("abstract", new RemoveBracesFormatter()).cleanup(entry);
        new FieldFormatterCleanup("abstract", new RemoveNewlinesFormatter()).cleanup(entry);
        new FieldFormatterCleanup("title", new RemoveBracesFormatter()).cleanup(entry);
        new FieldFormatterCleanup("author", new NormalizeNamesFormatter()).cleanup(entry);
        new FieldFormatterCleanup("adsnote", new ClearFormatter()).cleanup(entry);
        new MoveFieldCleanup("adsurl", "url").cleanup(entry);
        entry.setCommentsBeforeEntry("");
    }
}

