/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.openoffice;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jabref.Globals;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.logic.l10n.Localization;

class AdvancedCiteDialog {
    private static boolean defaultInPar = true;
    private boolean okPressed;
    private final JDialog diag;
    private final JTextField pageInfo = new JTextField(15);

    public AdvancedCiteDialog(JabRefFrame parent) {
        this.diag = new JDialog(parent, Localization.lang("Cite special", new String[0]), true);
        ButtonGroup bg = new ButtonGroup();
        JRadioButton inPar = new JRadioButton(Localization.lang("Cite selected entries between parenthesis", new String[0]));
        JRadioButton inText = new JRadioButton(Localization.lang("Cite selected entries with in-text citation", new String[0]));
        bg.add(inPar);
        bg.add(inText);
        if (defaultInPar) {
            inPar.setSelected(true);
        } else {
            inText.setSelected(true);
        }
        inPar.addChangeListener(changeEvent -> {
            defaultInPar = inPar.isSelected();
        });
        FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:pref", "pref, 4dlu, pref, 4dlu, pref"));
        builder.add(inPar).xyw(1, 1, 3);
        builder.add(inText).xyw(1, 3, 3);
        builder.add(Localization.lang("Extra information (e.g. page number)", new String[0]) + ":", new Object[0]).xy(1, 5);
        builder.add(this.pageInfo).xy(3, 5);
        builder.padding("10dlu, 10dlu, 10dlu, 10dlu", new Object[0]);
        this.diag.getContentPane().add((Component)builder.getPanel(), "Center");
        ButtonBarBuilder bb = new ButtonBarBuilder();
        bb.addGlue();
        JButton ok = new JButton(Localization.lang("OK", new String[0]));
        JButton cancel = new JButton(Localization.lang("Cancel", new String[0]));
        bb.addButton((JComponent)ok);
        bb.addButton((JComponent)cancel);
        bb.addGlue();
        bb.padding("5dlu, 5dlu, 5dlu, 5dlu", new Object[0]);
        this.diag.getContentPane().add((Component)bb.getPanel(), "South");
        this.diag.pack();
        ActionListener okAction = actionEvent -> {
            this.okPressed = true;
            this.diag.dispose();
        };
        ok.addActionListener(okAction);
        this.pageInfo.addActionListener(okAction);
        inPar.addActionListener(okAction);
        inText.addActionListener(okAction);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedCiteDialog.this.okPressed = false;
                AdvancedCiteDialog.this.diag.dispose();
            }
        };
        cancel.addActionListener(cancelAction);
        builder.getPanel().getInputMap(2).put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        builder.getPanel().getActionMap().put("close", cancelAction);
    }

    public void showDialog() {
        this.diag.setLocationRelativeTo(this.diag.getParent());
        this.diag.setVisible(true);
    }

    public boolean canceled() {
        return !this.okPressed;
    }

    public String getPageInfo() {
        return this.pageInfo.getText().trim();
    }

    public boolean isInParenthesisCite() {
        return defaultInPar;
    }
}

