/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import java.nio.file.Path;
import java.util.Optional;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.jabref.Globals;
import org.jabref.JabRefExecutorService;
import org.jabref.gui.BasePanel;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.collab.ChangeScanner;
import org.jabref.gui.collab.FileUpdatePanel;
import org.jabref.gui.dialogs.AutosaveUIManager;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.worker.AbstractWorker;
import org.jabref.logic.autosaveandbackup.AutosaveManager;
import org.jabref.logic.autosaveandbackup.BackupManager;
import org.jabref.logic.exporter.BibtexDatabaseWriter;
import org.jabref.logic.exporter.FileSaveSession;
import org.jabref.logic.exporter.SaveException;
import org.jabref.logic.exporter.SavePreferences;
import org.jabref.logic.exporter.SaveSession;
import org.jabref.logic.l10n.Encodings;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.shared.prefs.SharedDatabasePreferences;
import org.jabref.logic.util.StandardFileType;
import org.jabref.logic.util.io.FileBasedLock;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.event.ChangePropagation;
import org.jabref.model.database.shared.DatabaseLocation;
import org.jabref.model.entry.BibEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveDatabaseAction
extends AbstractWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveDatabaseAction.class);
    private final BasePanel panel;
    private final JabRefFrame frame;
    private boolean success;
    private boolean canceled;
    private boolean fileLockedError;
    private Optional<Path> filePath;

    public SaveDatabaseAction(BasePanel panel) {
        this.panel = panel;
        this.frame = panel.frame();
        this.filePath = Optional.empty();
    }

    public SaveDatabaseAction(BasePanel panel, Path filePath) {
        this(panel);
        this.filePath = Optional.ofNullable(filePath);
    }

    @Override
    public void init() throws Exception {
        this.success = false;
        this.canceled = false;
        this.fileLockedError = false;
        if (this.panel.getBibDatabaseContext().getDatabaseFile().isPresent()) {
            if (this.checkExternalModification()) {
                return;
            }
            this.panel.frame().output(Localization.lang("Saving library", new String[0]) + "...");
            this.panel.setSaving(true);
        } else if (this.filePath.isPresent()) {
            this.saveAs(this.filePath.get().toFile());
        } else {
            this.saveAs();
        }
    }

    @Override
    public void update() {
        if (this.success) {
            this.frame.setTabTitle(this.panel, this.panel.getTabTitle(), this.panel.getBibDatabaseContext().getDatabaseFile().get().getAbsolutePath());
            this.frame.output(Localization.lang("Saved library", new String[0]) + " '" + this.panel.getBibDatabaseContext().getDatabaseFile().get().getPath() + "'.");
            this.frame.setWindowTitle();
            this.frame.updateAllTabTitles();
        } else if (!this.canceled) {
            if (this.fileLockedError) {
                this.frame.output(Localization.lang("Could not save, file locked by another JabRef instance.", new String[0]));
            } else {
                this.frame.output(Localization.lang("Save failed", new String[0]));
            }
        }
    }

    @Override
    public void run() {
        if (this.canceled || !this.panel.getBibDatabaseContext().getDatabaseFile().isPresent()) {
            return;
        }
        try {
            this.panel.autoGenerateKeysBeforeSaving();
            if (FileBasedLock.waitForFileLock(this.panel.getBibDatabaseContext().getDatabaseFile().get().toPath())) {
                if (this.checkExternalModification()) {
                    return;
                }
                this.success = this.saveDatabase(this.panel.getBibDatabaseContext().getDatabaseFile().get(), false, this.panel.getBibDatabaseContext().getMetaData().getEncoding().orElse(Globals.prefs.getDefaultEncoding()));
                this.panel.updateTimeStamp();
            } else {
                this.success = false;
                this.fileLockedError = true;
            }
            this.panel.setSaving(false);
            if (this.success) {
                this.panel.getUndoManager().markUnchanged();
                this.panel.setNonUndoableChange(false);
                this.panel.setBaseChanged(false);
                this.panel.markExternalChangesAsResolved();
            }
        }
        catch (SaveException ex) {
            if (ex == SaveException.FILE_LOCKED) {
                this.success = false;
                this.fileLockedError = true;
                return;
            }
            LOGGER.error("Problem saving file", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean saveDatabase(File file, boolean selectedOnly, Charset encoding) throws SaveException {
        Object session;
        this.frame.block();
        try {
            SavePreferences prefs = Globals.prefs.loadForSaveFromPreferences().withEncoding(encoding);
            BibtexDatabaseWriter<SaveSession> databaseWriter = new BibtexDatabaseWriter<SaveSession>(FileSaveSession::new);
            session = selectedOnly ? databaseWriter.savePartOfDatabase(this.panel.getBibDatabaseContext(), this.panel.getSelectedEntries(), prefs) : databaseWriter.saveDatabase(this.panel.getBibDatabaseContext(), prefs);
            this.panel.registerUndoableChanges((SaveSession)session);
        }
        catch (UnsupportedCharsetException ex) {
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not save file.", new String[0]) + Localization.lang("Character encoding '%0' is not supported.", encoding.displayName()), Localization.lang("Save library", new String[0]), 0);
            throw new SaveException("rt");
        }
        catch (SaveException ex) {
            if (ex == SaveException.FILE_LOCKED) {
                throw ex;
            }
            if (ex.specificEntry()) {
                BibEntry entry = ex.getEntry();
                this.panel.highlightEntry(entry);
            } else {
                LOGGER.error("A problem occured when trying to save the file", ex);
            }
            JOptionPane.showMessageDialog(this.frame, Localization.lang("Could not save file.", new String[0]) + ".\n" + ex.getMessage(), Localization.lang("Save library", new String[0]), 0);
            throw new SaveException("rt");
        }
        finally {
            this.frame.unblock();
        }
        boolean success = true;
        if (!((SaveSession)session).getWriter().couldEncodeAll()) {
            FormBuilder builder = FormBuilder.create().layout(new FormLayout("left:pref, 4dlu, fill:pref", "pref, 4dlu, pref"));
            JTextArea ta = new JTextArea(((SaveSession)session).getWriter().getProblemCharacters());
            ta.setEditable(false);
            builder.add(Localization.lang("The chosen encoding '%0' could not encode the following characters:", ((SaveSession)session).getEncoding().displayName()), new Object[0]).xy(1, 1);
            builder.add(ta).xy(3, 1);
            builder.add(Localization.lang("What do you want to do?", new String[0]), new Object[0]).xy(1, 3);
            String tryDiff = Localization.lang("Try different encoding", new String[0]);
            int answer = JOptionPane.showOptionDialog(this.frame, builder.getPanel(), Localization.lang("Save library", new String[0]), 1, 2, null, new String[]{Localization.lang("Save", new String[0]), tryDiff, Localization.lang("Cancel", new String[0])}, tryDiff);
            if (answer == 1) {
                Object choice = JOptionPane.showInputDialog(this.frame, Localization.lang("Select encoding", new String[0]), Localization.lang("Save library", new String[0]), 3, null, Encodings.ENCODINGS_DISPLAYNAMES, encoding);
                if (choice != null) {
                    Charset newEncoding = Charset.forName((String)choice);
                    return this.saveDatabase(file, selectedOnly, newEncoding);
                }
                success = false;
            } else if (answer == 2) {
                success = false;
            }
        }
        try {
            if (success) {
                ((SaveSession)session).commit(file.toPath());
                this.panel.getBibDatabaseContext().getMetaData().setEncoding(encoding, ChangePropagation.DO_NOT_POST_EVENT);
                return success;
            }
            ((SaveSession)session).cancel();
            return success;
        }
        catch (SaveException e) {
            int ans = JOptionPane.showConfirmDialog(null, Localization.lang("Save failed during backup creation", new String[0]) + ". " + Localization.lang("Save without backup?", new String[0]), Localization.lang("Unable to create backup", new String[0]), 0);
            if (ans != 0) return false;
            ((SaveSession)session).setUseBackup(false);
            ((SaveSession)session).commit(file.toPath());
            this.panel.getBibDatabaseContext().getMetaData().setEncoding(encoding, ChangePropagation.DO_NOT_POST_EVENT);
            return success;
        }
    }

    public void runCommand() throws Exception {
        BasePanel.runWorker(this);
    }

    public void save() throws Exception {
        this.runCommand();
        this.frame.updateEnabledState();
    }

    public void saveAs() throws Exception {
        FXDialogService ds = new FXDialogService();
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.BIBTEX_DB).withDefaultExtension(StandardFileType.BIBTEX_DB).withInitialDirectory(Globals.prefs.get("workingDirectory")).build();
        Optional path = DefaultTaskExecutor.runInJavaFXThread(() -> ds.showFileSaveDialog(fileDialogConfiguration));
        if (!path.isPresent()) {
            this.canceled = true;
            return;
        }
        this.saveAs(((Path)path.get()).toFile());
    }

    public void saveAs(File file) throws Exception {
        BibDatabaseContext context = this.panel.getBibDatabaseContext();
        if (context.getLocation() == DatabaseLocation.SHARED) {
            new SharedDatabasePreferences(context.getDatabase().generateSharedDatabaseID()).putAllDBMSConnectionProperties(context.getDBMSSynchronizer().getConnectionProperties());
        }
        context.setDatabaseFile(file);
        if (file.getParent() != null) {
            Globals.prefs.put("workingDirectory", file.getParent());
        }
        this.runCommand();
        if (!this.success) {
            return;
        }
        Optional<Path> databasePath = context.getDatabasePath();
        if (databasePath.isPresent()) {
            Path oldFile = databasePath.get();
            context.setDatabaseFile(oldFile.toFile());
            AutosaveManager.shutdown(context);
            BackupManager.shutdown(context);
        } else {
            LOGGER.info("Old file not found, just creating a new file");
        }
        context.setDatabaseFile(file);
        this.panel.resetChangeMonitor();
        if (this.readyForAutosave(context)) {
            AutosaveManager autosaver = AutosaveManager.start(context);
            autosaver.registerListener(new AutosaveUIManager(this.panel));
        }
        if (this.readyForBackup(context)) {
            BackupManager.start(context);
        }
        context.getDatabaseFile().ifPresent(presentFile -> this.frame.getFileHistory().newFile(presentFile.getPath()));
        this.frame.updateEnabledState();
    }

    private boolean readyForAutosave(BibDatabaseContext context) {
        return (context.getLocation() == DatabaseLocation.SHARED || context.getLocation() == DatabaseLocation.LOCAL && Globals.prefs.getBoolean("localAutoSave")) && context.getDatabaseFile().isPresent();
    }

    private boolean readyForBackup(BibDatabaseContext context) {
        return context.getLocation() == DatabaseLocation.LOCAL && context.getDatabaseFile().isPresent();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private boolean checkExternalModification() {
        if (this.panel.isUpdatedExternally()) {
            Object[] opts = new String[]{Localization.lang("Review changes", new String[0]), Localization.lang("Save", new String[0]), Localization.lang("Cancel", new String[0])};
            int answer = JOptionPane.showOptionDialog(this.panel.frame(), Localization.lang("File has been updated externally. What do you want to do?", new String[0]), Localization.lang("File updated externally", new String[0]), 1, 3, null, opts, opts[0]);
            if (answer == 2) {
                this.canceled = true;
                return true;
            }
            if (answer == 0) {
                this.canceled = true;
                JabRefExecutorService.INSTANCE.execute(() -> {
                    if (!FileBasedLock.waitForFileLock(this.panel.getBibDatabaseContext().getDatabaseFile().get().toPath())) {
                        LOGGER.error("File locked, this will be trouble.");
                    }
                    ChangeScanner scanner = new ChangeScanner(this.panel.frame(), this.panel, this.panel.getBibDatabaseContext().getDatabaseFile().get(), this.panel.getTempFile());
                    JabRefExecutorService.INSTANCE.executeInterruptableTaskAndWait(scanner);
                    if (scanner.changesFound()) {
                        scanner.displayResult(resolved -> {
                            if (resolved) {
                                this.panel.markExternalChangesAsResolved();
                                SwingUtilities.invokeLater(() -> this.panel.getSidePaneManager().hide(FileUpdatePanel.class));
                            } else {
                                this.canceled = true;
                            }
                        });
                    }
                });
                return true;
            }
            if (this.panel.getBibDatabaseContext().getMetaData().isProtected()) {
                JOptionPane.showMessageDialog(this.frame, Localization.lang("Library is protected. Cannot save until external changes have been reviewed.", new String[0]), Localization.lang("Protected library", new String[0]), 0);
                this.canceled = true;
            } else {
                this.panel.markExternalChangesAsResolved();
                this.panel.getSidePaneManager().hide(FileUpdatePanel.class);
            }
        }
        return false;
    }
}

