/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.customjfx;

import com.sun.javafx.embed.EmbeddedSceneInterface;
import java.awt.event.InputMethodEvent;
import java.lang.reflect.Field;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Scene;
import org.jabref.gui.customjfx.support.InputMethodSupport;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.logic.util.OS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomJFXPanel
extends JFXPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CustomJFXPanel.class);
    private Field scenePeerField = null;

    private CustomJFXPanel() {
        try {
            this.scenePeerField = ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField("scenePeer");
            this.scenePeerField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            LOGGER.error("Could not access scenePeer Field", e);
        }
    }

    public static JFXPanel create() {
        return OS.LINUX ? new CustomJFXPanel() : new JFXPanel();
    }

    public static JFXPanel wrap(Scene scene) {
        CustomJFXPanel container = OS.LINUX ? new CustomJFXPanel() : new JFXPanel();
        DefaultTaskExecutor.runInJavaFXThread(() -> container.setScene(scene));
        return container;
    }

    protected void processInputMethodEvent(InputMethodEvent e) {
        if (e.getID() == 1100) {
            this.sendInputMethodEventToFX(e);
        }
    }

    private void sendInputMethodEventToFX(InputMethodEvent e) {
        String t = InputMethodSupport.getTextForEvent(e);
        int insertionIndex = 0;
        if (e.getCaret() != null) {
            insertionIndex = e.getCaret().getInsertionIndex();
        }
        EmbeddedSceneInterface myScencePeer = null;
        try {
            myScencePeer = (EmbeddedSceneInterface)this.scenePeerField.get((Object)this);
        }
        catch (IllegalAccessException | IllegalArgumentException ex) {
            LOGGER.error("Could not access scenePeer Field", ex);
        }
        myScencePeer.inputMethodEvent(javafx.scene.input.InputMethodEvent.INPUT_METHOD_TEXT_CHANGED, InputMethodSupport.inputMethodEventComposed(t, e.getCommittedCharacterCount()), t.substring(0, e.getCommittedCharacterCount()), insertionIndex);
    }
}

