/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.Experimental;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Languages;
import org.languagetool.Premium;
import org.languagetool.rules.spelling.morfologik.suggestions_ordering.SuggestionsOrdererConfig;
import org.languagetool.server.IllegalConfigurationException;
import org.languagetool.server.ServerTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPServerConfig {
    private static final Logger logger = LoggerFactory.getLogger(HTTPServerConfig.class);
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 8081;
    static final String LANGUAGE_MODEL_OPTION = "--languageModel";
    protected boolean verbose = false;
    protected boolean publicAccess = false;
    protected int port = 8081;
    protected int minPort;
    protected int maxPort;
    protected String allowOriginUrl = null;
    protected boolean logIp = true;
    protected String logIpMatchingPattern = "__logIPNowForLanguageTool__";
    protected URI serverURL = null;
    protected int maxTextLengthAnonymous = Integer.MAX_VALUE;
    protected int maxTextLengthLoggedIn = Integer.MAX_VALUE;
    protected int maxTextLengthPremium = Integer.MAX_VALUE;
    protected int maxTextHardLength = Integer.MAX_VALUE;
    protected long maxCheckTimeMillisAnonymous = -1L;
    protected long maxCheckTimeMillisLoggedIn = -1L;
    protected long maxCheckTimeMillisPremium = -1L;
    protected int maxCheckThreads = 10;
    protected int maxTextCheckerThreads;
    protected int textCheckerQueueSize = 8;
    protected Mode mode;
    protected File languageModelDir = null;
    protected boolean pipelineCaching = false;
    protected boolean pipelinePrewarming = false;
    protected int maxPipelinePoolSize;
    protected int pipelineExpireTime;
    protected File fasttextModel = null;
    protected File fasttextBinary = null;
    protected int requestLimit;
    protected int requestLimitInBytes;
    protected int timeoutRequestLimit;
    protected int requestLimitPeriodInSeconds;
    protected List<String> requestLimitWhitelistUsers;
    protected int requestLimitWhitelistLimit;
    protected int ipFingerprintFactor = 1;
    protected boolean trustXForwardForHeader;
    protected int maxWorkQueueSize;
    protected File rulesConfigFile = null;
    protected File remoteRulesConfigFile = null;
    protected int cacheSize = 0;
    protected long cacheTTLSeconds = 300L;
    protected float maxErrorsPerWordRate = 0.0f;
    protected int maxSpellingSuggestions = 0;
    protected List<String> blockedReferrers = new ArrayList<String>();
    protected boolean premiumAlways;
    protected boolean premiumOnly;
    protected String requestLimitAccessToken = null;
    boolean anonymousAccessAllowed = true;
    protected boolean gracefulDatabaseFailure = false;
    protected boolean restrictManagedAccounts = true;
    protected String dbDriver = null;
    protected String dbUrl = null;
    protected String dbUsername = null;
    protected String dbPassword = null;
    protected long dbTimeoutSeconds = 10L;
    protected int dbMaxConnections = 10;
    protected int databaseTimeoutRateThreshold = 100;
    protected int databaseErrorRateThreshold = 50;
    protected int databaseDownIntervalSeconds = 10;
    protected boolean dbLogging;
    protected boolean prometheusMonitoring = false;
    protected int prometheusPort = 9301;
    protected GlobalConfig globalConfig = new GlobalConfig();
    protected List<String> disabledRuleIds = new ArrayList<String>();
    protected boolean stoppable = false;
    protected String passwortLoginAccessListPath = "";
    @Nullable
    protected String redisHost = null;
    protected int redisPort = 6379;
    protected int redisDatabase = 0;
    protected boolean redisUseSSL = true;
    protected String redisCertificate;
    protected String redisKey;
    protected String redisKeyPassword;
    @Nullable
    protected String redisPassword = null;
    protected long redisDictTTL = 600L;
    protected long redisTimeout = 100L;
    protected long redisConnectionTimeout = 5000L;
    protected boolean redisUseSentinel = false;
    protected String sentinelHost;
    protected int sentinelPort = 26379;
    protected String sentinelPassword;
    protected String sentinelMasterId;
    protected boolean skipLoggingRuleMatches = false;
    protected boolean skipLoggingChecks = false;
    protected int slowRuleLoggingThreshold = -1;
    protected List<String> abTest = null;
    protected Pattern abTestClients = null;
    protected int abTestRollout = 100;
    protected File ngramLangIdentData;
    protected boolean localApiMode = false;
    protected String motherTongue = "en-US";
    protected List<String> preferredLanguages = new ArrayList<String>();
    protected int dictLimitUser = 0;
    protected int dictLimitTeam = 0;
    protected int styleGuideLimitUser = 0;
    protected int styleGuideLimitTeam = 0;
    private static final List<String> KNOWN_OPTION_KEYS = Arrays.asList("abTest", "abTestClients", "abTestRollout", "beolingusFile", "blockedReferrers", "cacheSize", "cacheTTLSeconds", "dbDriver", "dbPassword", "dbUrl", "dbUsername", "disabledRuleIds", "fasttextBinary", "fasttextModel", "grammalectePassword", "grammalecteServer", "grammalecteUser", "ipFingerprintFactor", "languageModel", "maxCheckThreads", "maxTextCheckerThreads", "textCheckerQueueSize", "maxCheckTimeMillis", "maxCheckTimeWithApiKeyMillis", "maxErrorsPerWordRate", "maxPipelinePoolSize", "maxSpellingSuggestions", "maxTextHardLength", "maxTextLength", "maxTextLengthWithApiKey", "maxWorkQueueSize", "pipelineCaching", "pipelineExpireTimeInSeconds", "pipelinePrewarming", "prometheusMonitoring", "prometheusPort", "remoteRulesFile", "requestLimit", "requestLimitInBytes", "requestLimitPeriodInSeconds", "requestLimitWhitelistUsers", "requestLimitWhitelistLimit", "rulesFile", "serverURL", "skipLoggingChecks", "skipLoggingRuleMatches", "timeoutRequestLimit", "trustXForwardForHeader", "keystore", "password", "maxTextLengthPremium", "maxTextLengthAnonymous", "maxTextLengthLoggedIn", "gracefulDatabaseFailure", "ngramLangIdentData", "dbTimeoutSeconds", "dbMaxConnections", "dbErrorRateThreshold", "dbTimeoutRateThreshold", "dbDownIntervalSeconds", "redisDatabase", "redisUseSSL", "redisTimeoutMilliseconds", "redisConnectionTimeoutMilliseconds", "anonymousAccessAllowed", "premiumAlways", "redisPassword", "redisHost", "redisCertificate", "redisKey", "redisKeyPassword", "redisUseSentinel", "sentinelHost", "sentinelPort", "sentinelPassword", "sentinelMasterId", "dbLogging", "premiumOnly", "nerUrl", "minPort", "maxPort", "localApiMode", "motherTongue", "preferredLanguages", "dictLimitUser", "dictLimitTeam", "styleGuideLimitUser", "styleGuideLimitTeam", "passwortLoginAccessListPath", "redisDictTTLSeconds", "requestLimitAccessToken");

    public void setPremiumOnly(boolean premiumOnly) {
        this.premiumOnly = premiumOnly;
    }

    public boolean isAnonymousAccessAllowed() {
        return this.anonymousAccessAllowed;
    }

    public boolean isRestrictManagedAccounts() {
        return this.restrictManagedAccounts;
    }

    public void setRestrictManagedAccounts(boolean restrictManagedAccounts) {
        this.restrictManagedAccounts = restrictManagedAccounts;
    }

    public HTTPServerConfig() {
        this(8081, false);
    }

    public HTTPServerConfig(int serverPort) {
        this(serverPort, false);
    }

    public HTTPServerConfig(int serverPort, boolean verbose) {
        this.port = serverPort;
        this.verbose = verbose;
    }

    HTTPServerConfig(String[] args) {
        block30: for (int i = 0; i < args.length; ++i) {
            if (args[i].matches("--[a-zA-Z]+=.+")) {
                System.err.println("WARNING: use `--option value`, not `--option=value`, parameters will be ignored otherwise: " + args[i]);
            }
            switch (args[i]) {
                case "--config": {
                    this.parseConfigFile(new File(args[++i]), !ArrayUtils.contains((Object[])args, (Object)LANGUAGE_MODEL_OPTION));
                    continue block30;
                }
                case "-p": 
                case "--port": {
                    this.port = Integer.parseInt(args[++i]);
                    continue block30;
                }
                case "-v": 
                case "--verbose": {
                    this.verbose = true;
                    continue block30;
                }
                case "--public": {
                    this.publicAccess = true;
                    continue block30;
                }
                case "--premiumAlways": {
                    if (!Premium.isPremiumVersion()) {
                        throw new IllegalArgumentException("Cannot use --premiumAlways with non-premium version");
                    }
                    this.premiumAlways = true;
                    System.out.println("*** Running in PREMIUM-ALWAYS mode, premium features are available without authentication");
                    continue block30;
                }
                case "--allow-origin": {
                    try {
                        this.allowOriginUrl = args[++i];
                        if (!this.allowOriginUrl.startsWith("--")) continue block30;
                        this.allowOriginUrl = "*";
                        --i;
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        this.allowOriginUrl = "*";
                    }
                    continue block30;
                }
                case "--languageModel": {
                    this.setLanguageModelDirectory(args[++i]);
                    continue block30;
                }
                case "--stoppable": {
                    this.stoppable = true;
                    continue block30;
                }
                case "--notLogIP": {
                    this.logIp = false;
                    continue block30;
                }
                case "--logIpMatchingPattern": {
                    try {
                        this.logIpMatchingPattern = args[++i];
                        if (!this.logIpMatchingPattern.startsWith("--")) continue block30;
                        throw new IllegalArgumentException("Missing argument for '--logIpMatchingPattern' (e.g. any random String)");
                    }
                    catch (ArrayIndexOutOfBoundsException e) {
                        throw new IllegalArgumentException("Missing argument for '--logIpMatchingPattern' (e.g. any random String)");
                    }
                }
                default: {
                    if (args[i].contains("=")) {
                        System.out.println("WARNING: unknown option: " + args[i] + " - please note that parameters are given as '--arg param', i.e. without '=' between argument and parameter");
                        continue block30;
                    }
                    System.out.println("WARNING: unknown option: " + args[i]);
                }
            }
        }
    }

    private void parseConfigFile(File file, boolean loadLangModel) {
        try {
            Properties props = new Properties();
            try (FileInputStream fis = new FileInputStream(file);){
                String nerUrl;
                String remoteRulesConfigFilePath;
                props.load(fis);
                this.maxTextHardLength = Integer.parseInt(this.getOptionalProperty(props, "maxTextHardLength", Integer.toString(Integer.MAX_VALUE)));
                this.maxTextLengthLoggedIn = this.maxTextLengthPremium = Integer.parseInt(this.getOptionalProperty(props, "maxTextLength", Integer.toString(Integer.MAX_VALUE)));
                this.maxTextLengthAnonymous = this.maxTextLengthPremium;
                this.maxTextLengthAnonymous = Integer.parseInt(this.getOptionalProperty(props, "maxTextLengthAnonymous", String.valueOf(this.maxTextLengthAnonymous)));
                this.maxTextLengthLoggedIn = Integer.parseInt(this.getOptionalProperty(props, "maxTextLengthLoggedIn", String.valueOf(this.maxTextLengthLoggedIn)));
                this.maxTextLengthPremium = Integer.parseInt(this.getOptionalProperty(props, "maxTextLengthPremium", String.valueOf(this.maxTextLengthPremium)));
                this.maxCheckTimeMillisLoggedIn = this.maxCheckTimeMillisPremium = (long)Integer.parseInt(this.getOptionalProperty(props, "maxCheckTimeMillis", "-1"));
                this.maxCheckTimeMillisAnonymous = this.maxCheckTimeMillisPremium;
                this.maxCheckTimeMillisAnonymous = Long.parseLong(this.getOptionalProperty(props, "maxCheckTimeMillisAnonymous", String.valueOf(this.maxCheckTimeMillisAnonymous)));
                this.maxCheckTimeMillisLoggedIn = Long.parseLong(this.getOptionalProperty(props, "maxCheckTimeMillisLoggedIn", String.valueOf(this.maxCheckTimeMillisLoggedIn)));
                this.maxCheckTimeMillisPremium = Long.parseLong(this.getOptionalProperty(props, "maxCheckTimeMillisPremium", String.valueOf(this.maxCheckTimeMillisPremium)));
                this.requestLimit = Integer.parseInt(this.getOptionalProperty(props, "requestLimit", "0"));
                this.requestLimitInBytes = Integer.parseInt(this.getOptionalProperty(props, "requestLimitInBytes", "0"));
                this.timeoutRequestLimit = Integer.parseInt(this.getOptionalProperty(props, "timeoutRequestLimit", "0"));
                this.requestLimitWhitelistUsers = Arrays.asList(this.getOptionalProperty(props, "requestLimitWhitelistUsers", "").split(",\\s*"));
                this.requestLimitWhitelistLimit = Integer.parseInt(this.getOptionalProperty(props, "requestLimitWhitelistLimit", "0"));
                this.pipelineCaching = Boolean.parseBoolean(this.getOptionalProperty(props, "pipelineCaching", "false").trim());
                this.pipelinePrewarming = Boolean.parseBoolean(this.getOptionalProperty(props, "pipelinePrewarming", "false").trim());
                this.maxPipelinePoolSize = Integer.parseInt(this.getOptionalProperty(props, "maxPipelinePoolSize", "5"));
                this.pipelineExpireTime = Integer.parseInt(this.getOptionalProperty(props, "pipelineExpireTimeInSeconds", "10"));
                this.requestLimitPeriodInSeconds = Integer.parseInt(this.getOptionalProperty(props, "requestLimitPeriodInSeconds", "0"));
                this.ipFingerprintFactor = Integer.parseInt(this.getOptionalProperty(props, "ipFingerprintFactor", "1"));
                this.trustXForwardForHeader = Boolean.valueOf(this.getOptionalProperty(props, "trustXForwardForHeader", "false").trim());
                this.maxWorkQueueSize = Integer.parseInt(this.getOptionalProperty(props, "maxWorkQueueSize", "0"));
                if (this.maxWorkQueueSize < 0) {
                    throw new IllegalArgumentException("maxWorkQueueSize must be >= 0: " + this.maxWorkQueueSize);
                }
                this.minPort = Integer.parseInt(this.getOptionalProperty(props, "minPort", "0"));
                this.maxPort = Integer.parseInt(this.getOptionalProperty(props, "maxPort", "0"));
                String url = this.getOptionalProperty(props, "serverURL", null);
                this.setServerURL(url);
                String langModel = this.getOptionalProperty(props, "languageModel", null);
                if (langModel != null && loadLangModel) {
                    this.setLanguageModelDirectory(langModel);
                }
                String fasttextModel = this.getOptionalProperty(props, "fasttextModel", null);
                String fasttextBinary = this.getOptionalProperty(props, "fasttextBinary", null);
                if (fasttextBinary != null && fasttextModel != null) {
                    this.setFasttextPaths(fasttextModel, fasttextBinary);
                }
                this.maxCheckThreads = Integer.parseInt(this.getOptionalProperty(props, "maxCheckThreads", "10"));
                if (this.maxCheckThreads < 1) {
                    throw new IllegalArgumentException("Invalid value for maxCheckThreads, must be >= 1: " + this.maxCheckThreads);
                }
                this.maxTextCheckerThreads = Integer.parseInt(this.getOptionalProperty(props, "maxTextCheckerThreads", "0"));
                if (this.maxTextCheckerThreads < 0) {
                    throw new IllegalArgumentException("Invalid value for maxTextCheckerThreads, must be >= 1: " + this.maxTextCheckerThreads);
                }
                this.textCheckerQueueSize = Integer.parseInt(this.getOptionalProperty(props, "textCheckerQueueSize", "8"));
                if (this.textCheckerQueueSize < 0) {
                    throw new IllegalArgumentException("Invalid value for textCheckerQueueSize, must be >= 1: " + this.textCheckerQueueSize);
                }
                boolean atdMode = this.getOptionalProperty(props, "mode", "LanguageTool").equalsIgnoreCase("AfterTheDeadline");
                if (atdMode) {
                    throw new IllegalArgumentException("The AfterTheDeadline mode is not supported anymore in LanguageTool 3.8 or later");
                }
                String rulesConfigFilePath = this.getOptionalProperty(props, "rulesFile", null);
                if (rulesConfigFilePath != null) {
                    this.rulesConfigFile = new File(rulesConfigFilePath);
                    if (!this.rulesConfigFile.exists() || !this.rulesConfigFile.isFile()) {
                        throw new RuntimeException("Rules Configuration file cannot be found: " + this.rulesConfigFile);
                    }
                }
                if ((remoteRulesConfigFilePath = this.getOptionalProperty(props, "remoteRulesFile", null)) != null) {
                    this.remoteRulesConfigFile = new File(remoteRulesConfigFilePath);
                    if (!this.remoteRulesConfigFile.exists() || !this.remoteRulesConfigFile.isFile()) {
                        throw new RuntimeException("Remote rules configuration file cannot be found: " + this.remoteRulesConfigFile);
                    }
                }
                this.cacheSize = Integer.parseInt(this.getOptionalProperty(props, "cacheSize", "0"));
                if (this.cacheSize < 0) {
                    throw new IllegalArgumentException("Invalid value for cacheSize: " + this.cacheSize + ", use 0 to deactivate cache");
                }
                if (props.containsKey("cacheTTLSeconds") && !props.containsKey("cacheSize")) {
                    throw new IllegalArgumentException("Use of cacheTTLSeconds without also setting cacheSize has no effect.");
                }
                this.cacheTTLSeconds = Integer.parseInt(this.getOptionalProperty(props, "cacheTTLSeconds", "300"));
                this.maxErrorsPerWordRate = Float.parseFloat(this.getOptionalProperty(props, "maxErrorsPerWordRate", "0"));
                this.maxSpellingSuggestions = Integer.parseInt(this.getOptionalProperty(props, "maxSpellingSuggestions", "0"));
                this.blockedReferrers = Arrays.asList(this.getOptionalProperty(props, "blockedReferrers", "").split(",\\s*"));
                String premiumAlwaysValue = props.getProperty("premiumAlways");
                if (premiumAlwaysValue != null) {
                    this.premiumAlways = Boolean.parseBoolean(premiumAlwaysValue.trim());
                    if (this.premiumAlways) {
                        System.out.println("*** Running in PREMIUM-ALWAYS mode");
                    }
                }
                this.premiumOnly = Boolean.valueOf(this.getOptionalProperty(props, "premiumOnly", "false").trim());
                if (this.premiumOnly) {
                    if (!Premium.isPremiumVersion()) {
                        throw new IllegalArgumentException("Cannot use premiumOnly=true with non-premium version");
                    }
                    System.out.println("*** Running in PREMIUM-ONLY mode");
                }
                this.anonymousAccessAllowed = Boolean.valueOf(this.getOptionalProperty(props, "anonymousAccessAllowed", "true").trim());
                if (!this.anonymousAccessAllowed) {
                    System.out.println("*** Running in RESTRICTED-ACCESS mode");
                }
                this.redisHost = this.getOptionalProperty(props, "redisHost", null);
                this.redisPort = Integer.parseInt(this.getOptionalProperty(props, "redisPort", "6379"));
                this.redisDatabase = Integer.parseInt(this.getOptionalProperty(props, "redisDatabase", "0"));
                this.redisUseSSL = Boolean.valueOf(this.getOptionalProperty(props, "redisUseSSL", "true").trim());
                this.redisPassword = this.getOptionalProperty(props, "redisPassword", null);
                this.redisDictTTL = Integer.parseInt(this.getOptionalProperty(props, "redisDictTTLSeconds", "600"));
                this.redisTimeout = Integer.parseInt(this.getOptionalProperty(props, "redisTimeoutMilliseconds", "100"));
                this.redisConnectionTimeout = Integer.parseInt(this.getOptionalProperty(props, "redisConnectionTimeoutMilliseconds", "5000"));
                this.redisCertificate = this.getOptionalProperty(props, "redisCertificate", null);
                this.redisKey = this.getOptionalProperty(props, "redisKey", null);
                this.redisKeyPassword = this.getOptionalProperty(props, "redisKeyPassword", null);
                this.redisUseSentinel = Boolean.parseBoolean(this.getOptionalProperty(props, "redisUseSentinel", "false").trim());
                this.sentinelHost = this.getOptionalProperty(props, "sentinelHost", null);
                this.sentinelPort = Integer.parseInt(this.getOptionalProperty(props, "sentinelPort", "26379"));
                this.sentinelPassword = this.getOptionalProperty(props, "sentinelPassword", null);
                this.sentinelMasterId = this.getOptionalProperty(props, "sentinelMasterId", null);
                this.gracefulDatabaseFailure = Boolean.parseBoolean(this.getOptionalProperty(props, "gracefulDatabaseFailure", "false").trim());
                this.dbDriver = this.getOptionalProperty(props, "dbDriver", null);
                this.dbUrl = this.getOptionalProperty(props, "dbUrl", null);
                this.dbUsername = this.getOptionalProperty(props, "dbUsername", null);
                this.dbPassword = this.getOptionalProperty(props, "dbPassword", null);
                this.dbTimeoutSeconds = Integer.parseInt(this.getOptionalProperty(props, "dbTimeoutSeconds", "10"));
                this.dbMaxConnections = Integer.parseInt(this.getOptionalProperty(props, "dbMaxConnections", "10"));
                this.databaseErrorRateThreshold = Integer.parseInt(this.getOptionalProperty(props, "dbErrorRateThreshold", "50"));
                this.databaseTimeoutRateThreshold = Integer.parseInt(this.getOptionalProperty(props, "dbTimeoutRateThreshold", "100"));
                this.databaseDownIntervalSeconds = Integer.parseInt(this.getOptionalProperty(props, "dbDownIntervalSeconds", "10"));
                this.dbLogging = Boolean.valueOf(this.getOptionalProperty(props, "dbLogging", "false").trim());
                this.passwortLoginAccessListPath = this.getOptionalProperty(props, "passwortLoginAccessListPath", "");
                this.prometheusMonitoring = Boolean.valueOf(this.getOptionalProperty(props, "prometheusMonitoring", "false").trim());
                this.prometheusPort = Integer.parseInt(this.getOptionalProperty(props, "prometheusPort", "9301"));
                this.skipLoggingRuleMatches = Boolean.valueOf(this.getOptionalProperty(props, "skipLoggingRuleMatches", "false").trim());
                this.skipLoggingChecks = Boolean.valueOf(this.getOptionalProperty(props, "skipLoggingChecks", "false").trim());
                if (this.dbLogging && (this.dbDriver == null || this.dbUrl == null || this.dbUsername == null || this.dbPassword == null)) {
                    throw new IllegalArgumentException("dbLogging can only be true if dbDriver, dbUrl, dbUsername, and dbPassword are all set");
                }
                this.slowRuleLoggingThreshold = Integer.valueOf(this.getOptionalProperty(props, "slowRuleLoggingThreshold", "-1"));
                this.disabledRuleIds = Arrays.asList(this.getOptionalProperty(props, "disabledRuleIds", "").split(",\\s*"));
                this.localApiMode = Boolean.parseBoolean(this.getOptionalProperty(props, "localApiMode", "false"));
                this.motherTongue = this.getOptionalProperty(props, "motherTongue", "en-US");
                String preferredLanguages = this.getOptionalProperty(props, "preferredLanguages", "").replace(" ", "");
                if (!preferredLanguages.equals("")) {
                    this.preferredLanguages = Arrays.asList(preferredLanguages.split(","));
                }
                this.dictLimitUser = Integer.valueOf(this.getOptionalProperty(props, "dictLimitUser", "0"));
                this.dictLimitTeam = Integer.valueOf(this.getOptionalProperty(props, "dictLimitTeam", "0"));
                this.styleGuideLimitUser = Integer.valueOf(this.getOptionalProperty(props, "styleGuideLimitUser", "0"));
                this.styleGuideLimitTeam = Integer.valueOf(this.getOptionalProperty(props, "styleGuideLimitTeam", "0"));
                this.requestLimitAccessToken = this.getOptionalProperty(props, "requestLimitAccessToken", null);
                this.globalConfig.setGrammalecteServer(this.getOptionalProperty(props, "grammalecteServer", null));
                this.globalConfig.setGrammalecteUser(this.getOptionalProperty(props, "grammalecteUser", null));
                this.globalConfig.setGrammalectePassword(this.getOptionalProperty(props, "grammalectePassword", null));
                String beolingusFile = this.getOptionalProperty(props, "beolingusFile", null);
                if (beolingusFile != null) {
                    if (new File(beolingusFile).exists()) {
                        this.globalConfig.setBeolingusFile(new File(beolingusFile));
                    } else {
                        throw new IllegalArgumentException("beolingusFile not found: " + beolingusFile);
                    }
                }
                if ((nerUrl = this.getOptionalProperty(props, "nerUrl", null)) != null) {
                    this.globalConfig.setNERUrl(nerUrl);
                    logger.info("Using NER service: " + this.globalConfig.getNerUrl());
                }
                for (Object o : props.keySet()) {
                    String key = (String)o;
                    if (KNOWN_OPTION_KEYS.contains(key) || key.matches("lang-[a-z]+-dictPath") || key.matches("lang-[a-z]+")) continue;
                    System.err.println("***** WARNING: ****");
                    System.err.println("Key '" + key + "' from configuration file '" + file + "' is unknown. Please check the key's spelling (case is significant).");
                    System.err.println("Known keys: " + KNOWN_OPTION_KEYS);
                }
                this.addDynamicLanguages(props);
                this.setAbTest(this.getOptionalProperty(props, "abTest", null));
                this.setAbTestClients(this.getOptionalProperty(props, "abTestClients", null));
                this.setAbTestRollout(Integer.parseInt(this.getOptionalProperty(props, "abTestRollout", "100")));
                String ngramLangIdentData = this.getOptionalProperty(props, "ngramLangIdentData", null);
                if (ngramLangIdentData != null) {
                    File dir = new File(ngramLangIdentData);
                    if (!dir.exists() || dir.isDirectory()) {
                        throw new IllegalArgumentException("ngramLangIdentData does not exist or is a directory (needs to be a ZIP file): " + ngramLangIdentData);
                    }
                    this.setNgramLangIdentData(dir);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load properties from '" + file + "'", e);
        }
    }

    private void addDynamicLanguages(Properties props) throws IOException {
        for (Object keyObj : props.keySet()) {
            String key = (String)keyObj;
            if (!key.startsWith("lang-") || key.contains("-dictPath")) continue;
            String code = key.substring("lang-".length());
            if (!code.contains("-") && code.length() != 2 && code.length() != 3) {
                throw new IllegalArgumentException("code is supposed to be a 2 (or rarely 3) character code (unless it uses a format with variant, like xx-YY): '" + code + "'");
            }
            String nameKey = "lang-" + code;
            String name = props.getProperty(nameKey);
            String dictPathKey = "lang-" + code + "-dictPath";
            String dictPath = props.getProperty(dictPathKey);
            if (dictPath == null) {
                throw new IllegalArgumentException(dictPathKey + " must be set");
            }
            File dictPathFile = new File(dictPath);
            if (!dictPathFile.exists() || !dictPathFile.isFile()) {
                throw new IllegalArgumentException("dictionary file does not exist or is not a file: '" + dictPath + "'");
            }
            ServerTools.print("Adding dynamic spell checker language " + name + ", code: " + code + ", dictionary: " + dictPath);
            Language lang = Languages.addLanguage((String)name, (String)code, (File)new File(dictPath));
            if (!new File(lang.getCommonWordsPath()).exists()) {
                throw new IllegalArgumentException("Common words path not found: '" + lang.getCommonWordsPath() + "'");
            }
            JLanguageTool lt = new JLanguageTool(lang);
            lt.check("test");
        }
    }

    public void setLanguageModelDirectory(String langModelDir) {
        SuggestionsOrdererConfig.setNgramsPath((String)langModelDir);
        this.languageModelDir = new File(langModelDir);
        if (!this.languageModelDir.exists() || !this.languageModelDir.isDirectory()) {
            throw new RuntimeException("LanguageModel directory not found or is not a directory: " + this.languageModelDir);
        }
    }

    void setFasttextPaths(String fasttextModelPath, String fasttextBinaryPath) {
        this.fasttextModel = new File(fasttextModelPath);
        this.fasttextBinary = new File(fasttextBinaryPath);
        if (!this.fasttextModel.exists() || this.fasttextModel.isDirectory()) {
            throw new RuntimeException("Fasttext model path not valid (file doesn't exist or is a directory): " + fasttextModelPath);
        }
        if (!this.fasttextBinary.exists() || this.fasttextBinary.isDirectory() || !this.fasttextBinary.canExecute()) {
            throw new RuntimeException("Fasttext binary path not valid (file doesn't exist, is a directory or not executable): " + fasttextBinaryPath);
        }
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isPublicAccess() {
        return this.publicAccess;
    }

    public int getPort() {
        return this.port;
    }

    public int getMinPort() {
        return this.minPort;
    }

    public int getMaxPort() {
        return this.maxPort;
    }

    @Nullable
    public String getAllowOriginUrl() {
        return this.allowOriginUrl;
    }

    public void setAllowOriginUrl(String allowOriginUrl) {
        this.allowOriginUrl = allowOriginUrl;
    }

    @Nullable
    public URI getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(@Nullable String url) {
        if (url != null) {
            try {
                this.serverURL = new URI(new URI(url).getPath());
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Could not parse provided serverURL: '" + url + "'", e);
            }
        } else {
            this.serverURL = null;
        }
    }

    public void setMaxTextLengthAnonymous(int len) {
        this.maxTextLengthAnonymous = len;
    }

    public void setMaxTextLengthLoggedIn(int len) {
        this.maxTextLengthLoggedIn = len;
    }

    public void setMaxTextLengthPremium(int len) {
        this.maxTextLengthPremium = len;
    }

    public void setMaxTextHardLength(int len) {
        this.maxTextHardLength = len;
    }

    int getMaxTextLengthAnonymous() {
        return this.maxTextLengthAnonymous;
    }

    int getMaxTextLengthLoggedIn() {
        return this.maxTextLengthLoggedIn;
    }

    int getMaxTextLengthPremium() {
        return this.maxTextLengthPremium;
    }

    int getMaxTextHardLength() {
        return this.maxTextHardLength;
    }

    public List<String> getRequestLimitWhitelistUsers() {
        return this.requestLimitWhitelistUsers;
    }

    public void setRequestLimitWhitelistUsers(List<String> requestLimitWhitelistUsers) {
        this.requestLimitWhitelistUsers = requestLimitWhitelistUsers;
    }

    public int getRequestLimitWhitelistLimit() {
        return this.requestLimitWhitelistLimit;
    }

    public void setRequestLimitWhitelistLimit(int requestLimitWhitelistLimit) {
        this.requestLimitWhitelistLimit = requestLimitWhitelistLimit;
    }

    int getRequestLimit() {
        return this.requestLimit;
    }

    int getTimeoutRequestLimit() {
        return this.timeoutRequestLimit;
    }

    int getRequestLimitInBytes() {
        return this.requestLimitInBytes;
    }

    int getRequestLimitPeriodInSeconds() {
        return this.requestLimitPeriodInSeconds;
    }

    public void setRequestLimit(int requestLimit) {
        this.requestLimit = requestLimit;
    }

    public void setRequestLimitPeriodInSeconds(int requestLimitPeriodInSeconds) {
        this.requestLimitPeriodInSeconds = requestLimitPeriodInSeconds;
    }

    public String getRequestLimitAccessToken() {
        return this.requestLimitAccessToken;
    }

    public void setRequestLimitAccessToken(String requestLimitAccessToken) {
        this.requestLimitAccessToken = requestLimitAccessToken;
    }

    int getIpFingerprintFactor() {
        return this.ipFingerprintFactor;
    }

    void setMaxCheckTimeMillisAnonymous(int maxCheckTimeMillis) {
        this.maxCheckTimeMillisAnonymous = maxCheckTimeMillis;
    }

    long getMaxCheckTimeMillisAnonymous() {
        return this.maxCheckTimeMillisAnonymous;
    }

    void setMaxCheckTimeMillisLoggedIn(int maxCheckTimeMillis) {
        this.maxCheckTimeMillisLoggedIn = maxCheckTimeMillis;
    }

    long getMaxCheckTimeMillisLoggedIn() {
        return this.maxCheckTimeMillisLoggedIn;
    }

    void setMaxCheckTimeMillisPremium(int maxCheckTimeMillis) {
        this.maxCheckTimeMillisPremium = maxCheckTimeMillis;
    }

    @Experimental
    long getMaxCheckTimeMillisPremium() {
        return this.maxCheckTimeMillisPremium;
    }

    @Nullable
    File getLanguageModelDir() {
        return this.languageModelDir;
    }

    @Nullable
    public File getFasttextModel() {
        return this.fasttextModel;
    }

    public void setFasttextModel(File model) {
        this.fasttextModel = Objects.requireNonNull(model);
    }

    @Nullable
    public File getFasttextBinary() {
        return this.fasttextBinary;
    }

    public void setFasttextBinary(File binary) {
        this.fasttextBinary = Objects.requireNonNull(binary);
    }

    Mode getMode() {
        return this.mode;
    }

    void setMaxCheckThreads(int maxCheckThreads) {
        this.maxCheckThreads = maxCheckThreads;
    }

    int getMaxCheckThreads() {
        return this.maxCheckThreads;
    }

    void setMaxTextCheckerThreads(int maxTextCheckerThreads) {
        this.maxTextCheckerThreads = maxTextCheckerThreads;
    }

    int getMaxTextCheckerThreads() {
        return this.maxTextCheckerThreads != 0 ? this.maxTextCheckerThreads : this.maxCheckThreads;
    }

    public int getTextCheckerQueueSize() {
        return this.textCheckerQueueSize;
    }

    public void setTextCheckerQueueSize(int textCheckerQueueSize) {
        this.textCheckerQueueSize = textCheckerQueueSize;
    }

    void setTrustXForwardForHeader(boolean trustXForwardForHeader) {
        this.trustXForwardForHeader = trustXForwardForHeader;
    }

    boolean getTrustXForwardForHeader() {
        return this.trustXForwardForHeader;
    }

    int getMaxWorkQueueSize() {
        return this.maxWorkQueueSize;
    }

    public boolean isPipelineCachingEnabled() {
        return this.pipelineCaching;
    }

    public boolean isPipelinePrewarmingEnabled() {
        return this.pipelinePrewarming;
    }

    public int getMaxPipelinePoolSize() {
        return this.maxPipelinePoolSize;
    }

    public int getPipelineExpireTime() {
        return this.pipelineExpireTime;
    }

    public void setPipelineCaching(boolean pipelineCaching) {
        this.pipelineCaching = pipelineCaching;
    }

    public void setPipelinePrewarming(boolean pipelinePrewarming) {
        this.pipelinePrewarming = pipelinePrewarming;
    }

    public void setMaxPipelinePoolSize(int maxPipelinePoolSize) {
        this.maxPipelinePoolSize = maxPipelinePoolSize;
    }

    public void setPipelineExpireTime(int pipelineExpireTime) {
        this.pipelineExpireTime = pipelineExpireTime;
    }

    int getCacheSize() {
        return this.cacheSize;
    }

    void setCacheSize(int sentenceCacheSize) {
        this.cacheSize = sentenceCacheSize;
    }

    long getCacheTTLSeconds() {
        return this.cacheTTLSeconds;
    }

    void setCacheTTLSeconds(long cacheTTLSeconds) {
        this.cacheTTLSeconds = cacheTTLSeconds;
    }

    float getMaxErrorsPerWordRate() {
        return this.maxErrorsPerWordRate;
    }

    int getMaxSpellingSuggestions() {
        return this.maxSpellingSuggestions;
    }

    @NotNull
    List<String> getBlockedReferrers() {
        return this.blockedReferrers;
    }

    void setBlockedReferrers(List<String> blockedReferrers) {
        this.blockedReferrers = Objects.requireNonNull(blockedReferrers);
    }

    @Nullable
    File getRulesConfigFile() {
        return this.rulesConfigFile;
    }

    @Nullable
    File getRemoteRulesConfigFile() {
        return this.remoteRulesConfigFile;
    }

    @Nullable
    String getDatabaseDriver() {
        return this.dbDriver;
    }

    void setDatabaseDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    @Nullable
    String getDatabaseUrl() {
        return this.dbUrl;
    }

    void setDatabaseUrl(String dbUrl) {
        this.dbUrl = dbUrl;
    }

    @Nullable
    String getDatabaseUsername() {
        return this.dbUsername;
    }

    void setDatabaseUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    @Nullable
    String getDatabasePassword() {
        return this.dbPassword;
    }

    void setDatabasePassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    void setDatabaseLogging(boolean logging) {
        this.dbLogging = logging;
    }

    boolean getDatabaseLogging() {
        return this.dbLogging;
    }

    public long getDbTimeoutSeconds() {
        return this.dbTimeoutSeconds;
    }

    public void setDbTimeoutSeconds(long dbTimeoutSeconds) {
        this.dbTimeoutSeconds = dbTimeoutSeconds;
    }

    public int getDatabaseTimeoutRateThreshold() {
        return this.databaseTimeoutRateThreshold;
    }

    public void setDatabaseTimeoutRateThreshold(int databaseTimeoutRateThreshold) {
        this.databaseTimeoutRateThreshold = databaseTimeoutRateThreshold;
    }

    public int getDatabaseErrorRateThreshold() {
        return this.databaseErrorRateThreshold;
    }

    public void setDatabaseErrorRateThreshold(int databaseErrorRateThreshold) {
        this.databaseErrorRateThreshold = databaseErrorRateThreshold;
    }

    public int getDatabaseDownIntervalSeconds() {
        return this.databaseDownIntervalSeconds;
    }

    public void setDatabaseDownIntervalSeconds(int databaseDownIntervalSeconds) {
        this.databaseDownIntervalSeconds = databaseDownIntervalSeconds;
    }

    public boolean getGracefulDatabaseFailure() {
        return this.gracefulDatabaseFailure;
    }

    public void setGracefulDatabaseFailure(boolean gracefulDatabaseFailure) {
        this.gracefulDatabaseFailure = gracefulDatabaseFailure;
    }

    public boolean isPrometheusMonitoring() {
        return this.prometheusMonitoring;
    }

    public int getPrometheusPort() {
        return this.prometheusPort;
    }

    @Nullable
    public String getRedisHost() {
        return this.redisHost;
    }

    public int getRedisPort() {
        return this.redisPort;
    }

    public int getRedisDatabase() {
        return this.redisDatabase;
    }

    public boolean isRedisUseSSL() {
        return this.redisUseSSL;
    }

    @Nullable
    public String getRedisPassword() {
        return this.redisPassword;
    }

    public long getRedisDictTTLSeconds() {
        return this.redisDictTTL;
    }

    public long getRedisTimeoutMilliseconds() {
        return this.redisTimeout;
    }

    public long getRedisConnectionMilliseconds() {
        return this.redisConnectionTimeout;
    }

    public int getSlowRuleLoggingThreshold() {
        return this.slowRuleLoggingThreshold;
    }

    boolean isSkipLoggingRuleMatches() {
        return this.skipLoggingRuleMatches;
    }

    public boolean isSkipLoggingChecks() {
        return this.skipLoggingChecks;
    }

    public List<String> getDisabledRuleIds() {
        return this.disabledRuleIds;
    }

    boolean isStoppable() {
        return this.stoppable;
    }

    public List<String> getAbTest() {
        return this.abTest;
    }

    public void setAbTest(@Nullable String abTest) {
        this.abTest = abTest != null && !abTest.trim().isEmpty() ? new ArrayList<String>(Arrays.asList(abTest.trim().split(","))) : Collections.emptyList();
    }

    @Experimental
    @Nullable
    public Pattern getAbTestClients() {
        return this.abTestClients;
    }

    @Experimental
    public void setAbTestClients(@Nullable String pattern) {
        this.abTestClients = pattern == null ? null : Pattern.compile(pattern);
    }

    @Experimental
    public void setAbTestRollout(int abTestRollout) {
        this.abTestRollout = abTestRollout;
    }

    @Experimental
    public int getAbTestRollout() {
        return this.abTestRollout;
    }

    public void setNgramLangIdentData(File ngramLangIdentData) {
        this.ngramLangIdentData = ngramLangIdentData;
    }

    @Nullable
    public File getNgramLangIdentData() {
        return this.ngramLangIdentData;
    }

    protected String getProperty(Properties props, String propertyName, File config) {
        String propertyValue = (String)props.get(propertyName);
        if (propertyValue == null || propertyValue.trim().isEmpty()) {
            throw new IllegalConfigurationException("Property '" + propertyName + "' must be set in " + config);
        }
        return propertyValue;
    }

    protected String getOptionalProperty(Properties props, String propertyName, String defaultValue) {
        String propertyValue = (String)props.get(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    boolean isPremiumAlways() {
        return this.premiumAlways;
    }

    void setPremiumAlways(boolean premiumAlways) {
        this.premiumAlways = premiumAlways;
    }

    public boolean isPremiumOnly() {
        return this.premiumOnly;
    }

    public boolean isRedisUseSentinel() {
        return this.redisUseSentinel;
    }

    public void setRedisUseSentinel(boolean redisUseSentinel) {
        this.redisUseSentinel = redisUseSentinel;
    }

    public String getSentinelHost() {
        return this.sentinelHost;
    }

    public void setSentinelHost(String sentinelHost) {
        this.sentinelHost = sentinelHost;
    }

    public int getSentinelPort() {
        return this.sentinelPort;
    }

    public void setSentinelPort(int sentinelPort) {
        this.sentinelPort = sentinelPort;
    }

    public String getSentinelPassword() {
        return this.sentinelPassword;
    }

    public void setSentinelPassword(String sentinelPassword) {
        this.sentinelPassword = sentinelPassword;
    }

    public String getSentinelMasterId() {
        return this.sentinelMasterId;
    }

    public void setSentinelMasterId(String sentinelMasterId) {
        this.sentinelMasterId = sentinelMasterId;
    }

    public String getRedisCertificate() {
        return this.redisCertificate;
    }

    public void setRedisCertificate(String redisCertificate) {
        this.redisCertificate = redisCertificate;
    }

    public String getRedisKey() {
        return this.redisKey;
    }

    public void setRedisKey(String redisKey) {
        this.redisKey = redisKey;
    }

    public String getRedisKeyPassword() {
        return this.redisKeyPassword;
    }

    public void setRedisKeyPassword(String redisKeyPassword) {
        this.redisKeyPassword = redisKeyPassword;
    }

    public String getPasswortLoginAccessListPath() {
        return this.passwortLoginAccessListPath;
    }

    public boolean isLocalApiMode() {
        return this.localApiMode;
    }

    public String getMotherTongue() {
        return this.motherTongue;
    }

    public List<String> getPreferedLanguages() {
        return this.preferredLanguages;
    }

    public int getDictLimitUser() {
        return this.dictLimitUser;
    }

    public int getDictLimitTeam() {
        return this.dictLimitTeam;
    }

    public int getStyleGuideLimitUser() {
        return this.styleGuideLimitUser;
    }

    public int getStyleGuideLimitTeam() {
        return this.styleGuideLimitTeam;
    }

    public int getDbMaxConnections() {
        return this.dbMaxConnections;
    }

    public void setDbMaxConnections(int dbMaxConnections) {
        this.dbMaxConnections = dbMaxConnections;
    }

    static enum Mode {
        LanguageTool;

    }
}

