/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.platform;

import java.net.URI;
import org.dita.dost.platform.ImportAction;
import org.dita.dost.platform.Plugin;
import org.dita.dost.platform.Value;
import org.dita.dost.util.FileUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.util.XMLUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

final class ImportXSLAction
extends ImportAction {
    ImportXSLAction() {
    }

    @Override
    public void getResult(ContentHandler buf) throws SAXException {
        for (Value value : this.valueSet) {
            if (value instanceof Value.PathValue) {
                Value.PathValue pathValue = (Value.PathValue)value;
                URI href = this.getHref(pathValue);
                buf.startElement("http://www.w3.org/1999/XSL/Transform", "import", "xsl:import", new XMLUtils.AttributesBuilder().add("href", href.toString()).build());
                buf.endElement("http://www.w3.org/1999/XSL/Transform", "import", "xsl:import");
                continue;
            }
            this.logger.error("XSLT import must be a file feature");
        }
    }

    private URI getHref(Value.PathValue value) {
        Plugin features = (Plugin)this.featureTable.get(value.pluginId());
        URI pluginDir = features.pluginDir().toURI();
        String path = value.getPath();
        URI templateFile = URLUtils.toFile(path).toURI().normalize();
        URI template = pluginDir.relativize(templateFile);
        if (value.pluginId() == null || template.isAbsolute()) {
            String templateFilePath = (String)this.paramTable.get("template");
            return URLUtils.toURI(FileUtils.getRelativeUnixPath(templateFilePath, path));
        }
        return URI.create("plugin:" + value.pluginId() + ":" + String.valueOf(template));
    }
}

