/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.util;

import java.util.Vector;
import net.yura.mobile.logging.Logger;

public class QueueProcessorThread
implements Runnable {
    public static boolean CHANGE_PRIORITY = true;
    private Vector inbox = new Vector();
    private boolean running;
    private Vector threads = new Vector(1);

    public QueueProcessorThread(String name) {
        this(name, 1);
    }

    public QueueProcessorThread(String name, int num) {
        if (num < 1) {
            throw new IllegalArgumentException("min 1 thread: " + num);
        }
        for (int c = 0; c < num; ++c) {
            this.threads.addElement(new Thread((Runnable)this, name + "-" + c));
        }
    }

    public void start() {
        this.running = true;
        for (int c = 0; c < this.threads.size(); ++c) {
            ((Thread)this.threads.elementAt(c)).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void kill() {
        QueueProcessorThread queueProcessorThread = this;
        synchronized (queueProcessorThread) {
            this.running = false;
            this.notifyAll();
        }
    }

    public void awaitTermination() throws InterruptedException {
        for (int c = 0; c < this.threads.size(); ++c) {
            ((Thread)this.threads.elementAt(c)).join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block13: {
            try {
                Logger.info("[QueueProcessorThread-" + Thread.currentThread().getName() + "] START DROP_PRIORITY==" + CHANGE_PRIORITY);
                if (CHANGE_PRIORITY) {
                    Thread.currentThread().setPriority(1);
                }
                while (this.running) {
                    Object object = null;
                    try {
                        QueueProcessorThread queueProcessorThread = this;
                        synchronized (queueProcessorThread) {
                            while (this.inbox.isEmpty()) {
                                if (!this.running) {
                                    break block13;
                                }
                                this.wait();
                            }
                            object = this.inbox.elementAt(0);
                            this.inbox.removeElementAt(0);
                        }
                        if (CHANGE_PRIORITY) {
                            Thread.yield();
                            Thread.sleep(0L);
                        }
                        this.process(object);
                        if (!CHANGE_PRIORITY) continue;
                        Thread.yield();
                        Thread.sleep(0L);
                    }
                    catch (InterruptedException ex) {
                        Logger.info("[QueueProcessorThread-" + Thread.currentThread().getName() + "] Interrupted");
                        break;
                    }
                    catch (Exception ex) {
                        Logger.warn("[QueueProcessorThread-" + Thread.currentThread().getName() + "] error processing " + object, ex);
                    }
                }
            }
            catch (Throwable t) {
                Logger.error("[QueueProcessorThread-" + Thread.currentThread().getName() + "] fatal error", t);
            }
        }
        Logger.info("[QueueProcessorThread-" + Thread.currentThread().getName() + "] Finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToInbox(Object obj) {
        QueueProcessorThread queueProcessorThread = this;
        synchronized (queueProcessorThread) {
            this.inbox.addElement(obj);
            this.notify();
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInbox() {
        QueueProcessorThread queueProcessorThread = this;
        synchronized (queueProcessorThread) {
            this.inbox.removeAllElements();
        }
    }

    public Vector getInbox() {
        return this.inbox;
    }

    public void process(Object object) throws Exception {
        ((Runnable)object).run();
    }
}

