/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.border;

import net.yura.mobile.gui.Font;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Component;

public class TitledBorder
implements Border {
    private static final int LEFT_OFFSET = 10;
    protected String title;
    protected Border border;
    protected Font titleFont;
    protected int titleColor = -16777216;

    public TitledBorder(Border border, String title, Font f) {
        this.border = border;
        if (this.border == null) {
            this.border = Component.empty;
        }
        this.titleFont = f;
        this.title = title;
    }

    public void paintBorder(Component c, Graphics2D g, int width, int height) {
        int topOffset = (this.getTop() - this.border.getTop()) / 2;
        int leftOffset = this.getLeft() + 10;
        g.translate(0, -topOffset);
        int[] clip = g.getClip();
        int fullHeight = height + topOffset + this.border.getTop() + this.border.getBottom();
        g.clipRect(-this.getLeft(), -this.border.getTop(), leftOffset, fullHeight);
        this.border.paintBorder(c, g, width, height + topOffset);
        g.setClip(clip);
        int textWidth = this.titleFont.getWidth(this.title) + 2;
        g.clipRect(textWidth + 10, -this.border.getTop(), width - 10 - textWidth + this.border.getRight(), fullHeight);
        this.border.paintBorder(c, g, width, height + topOffset);
        g.setClip(clip);
        g.clipRect(10, topOffset, textWidth, height + this.border.getBottom());
        this.border.paintBorder(c, g, width, height + topOffset);
        g.setClip(clip);
        g.translate(0, topOffset);
        g.setFont(this.titleFont);
        g.setColor(this.titleColor);
        g.drawString(this.title, 11, -this.getTop() + (this.getTop() - this.titleFont.getHeight()) / 2);
    }

    public int getTop() {
        return Math.max(this.border.getTop(), this.titleFont.getHeight());
    }

    public int getBottom() {
        return this.border.getBottom();
    }

    public int getRight() {
        return this.border.getRight();
    }

    public int getLeft() {
        return this.border.getLeft();
    }

    public boolean isBorderOpaque() {
        return this.border.isBorderOpaque();
    }
}

