/*
 * Decompiled with CFR 0.152.
 */
package org.me4se.psi.java1.media.video;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Image;
import javax.microedition.media.MediaException;
import javax.microedition.media.control.VideoControl;
import javax.microedition.midlet.ApplicationManager;
import org.me4se.psi.java1.media.video.VideoItem;

public class VideoControlImpl
implements VideoControl {
    public static final String VIDEO_FRAME_1 = "/tux_small1.jpg";
    public static final String VIDEO_FRAME_2 = "/tux_small2.jpg";
    public static final String LARGE_IMAGE = "/tux_large.jpg";
    int frameCount;
    Image[] video;
    Canvas targetCanvas;
    VideoItem videoItem;
    boolean fullScreen;
    int x;
    int y;
    boolean visible = false;

    public VideoControlImpl() {
        try {
            this.video = new Image[]{Image.createImage(VIDEO_FRAME_1), Image.createImage(VIDEO_FRAME_2)};
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public int getDisplayHeight() {
        return this.video[0].getHeight();
    }

    public int getDisplayWidth() {
        return this.video[0].getWidth();
    }

    public int getDisplayX() {
        return this.x;
    }

    public int getDisplayY() {
        return this.y;
    }

    public byte[] getSnapshot(String imageType) throws MediaException {
        try {
            int cnt;
            InputStream is = ApplicationManager.getInstance().openInputStream(LARGE_IMAGE);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[512];
            while ((cnt = is.read(buf)) > 0) {
                baos.write(buf, 0, cnt);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            MediaException mx = new MediaException(e.toString());
            mx.initCause(e);
            throw mx;
        }
    }

    public int getSourceHeight() {
        return 240;
    }

    public int getSourceWidth() {
        return 320;
    }

    public Object initDisplayMode(int mode, Object arg) {
        switch (mode) {
            case 0: {
                this.visible = true;
                return new VideoItem(this);
            }
            case 1: {
                this.targetCanvas = (Canvas)arg;
                return this.targetCanvas;
            }
        }
        throw new IllegalArgumentException("ME4SE: Unsupported video mode: " + mode);
    }

    public void setDisplayFullScreen(boolean fullScreenMode) throws MediaException {
        this.fullScreen = fullScreenMode;
        this.setDisplayLocation((this.targetCanvas.getWidth() - this.getDisplayWidth()) / 2, (this.targetCanvas.getHeight() - this.getDisplayHeight()) / 2);
    }

    public void setDisplayLocation(int x, int y) {
        this.x = x;
        this.y = y;
        System.out.println("ME4SE: VideoControl.setDispalyLocation(int x='" + x + "', y='" + y + "') called.");
    }

    public void setDisplaySize(int width, int height) throws MediaException {
        System.out.println("ME4SE: VideoControl.setDispalySize(int width='" + width + "', height='" + height + "') called but not supported.");
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        if (!visible && this.targetCanvas != null) {
            this.targetCanvas._setVideoControlData(this.x, this.y, null);
        }
    }

    Image getCurrentImage() {
        return this.video[this.frameCount % 20 == 0 ? 1 : 0];
    }

    public void tick() {
        ++this.frameCount;
        if (this.targetCanvas != null && this.visible) {
            this.targetCanvas._setVideoControlData(this.x, this.y, this.getCurrentImage());
        } else if (this.videoItem != null && this.visible) {
            this.videoItem.repaint();
        }
    }
}

