/*
 * Decompiled with CFR 0.152.
 */
package plugin.primitive.weaponprof;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pcgen.cdom.base.Converter;
import pcgen.cdom.enumeration.GroupingState;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.core.PlayerCharacter;
import pcgen.core.WeaponProf;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.PrimitiveToken;

public class TypeToken
implements PrimitiveToken<WeaponProf> {
    private static final Class<WeaponProf> WEAPONPROF_CLASS = WeaponProf.class;
    private CDOMGroupRef<WeaponProf> typeRef;

    @Override
    public String getTokenName() {
        return "TYPE";
    }

    @Override
    public <R> Collection<R> getCollection(PlayerCharacter pc, Converter<WeaponProf, R> c) {
        List<WeaponProf> profs = pc.getWeaponProfsInTarget(this.typeRef);
        ArrayList<R> returnList = new ArrayList<R>(profs.size() + 10);
        for (WeaponProf wp : profs) {
            returnList.addAll(c.convert(CDOMDirectSingleRef.getRef(wp)));
        }
        return returnList;
    }

    @Override
    public GroupingState getGroupingState() {
        return GroupingState.ANY;
    }

    @Override
    public Class<? super WeaponProf> getReferenceClass() {
        return WEAPONPROF_CLASS;
    }

    @Override
    public String getLSTformat(boolean useAny) {
        return this.typeRef.getLSTformat(useAny);
    }

    @Override
    public boolean initialize(LoadContext context, Class<WeaponProf> cl, String value, String args) {
        if (args != null) {
            return false;
        }
        this.typeRef = context.getReferenceContext().getCDOMTypeReference(WEAPONPROF_CLASS, value);
        return this.typeRef != null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof TypeToken) {
            TypeToken other = (TypeToken)obj;
            return this.typeRef.equals(other.typeRef);
        }
        return false;
    }

    public int hashCode() {
        return this.typeRef == null ? -11 : this.typeRef.hashCode();
    }
}

