/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.skill;

import pcgen.core.kit.KitSkill;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.rules.persistence.token.ParseResult;

public class CountToken
extends AbstractToken
implements CDOMPrimaryToken<KitSkill> {
    @Override
    public String getTokenName() {
        return "COUNT";
    }

    @Override
    public Class<KitSkill> getTokenClass() {
        return KitSkill.class;
    }

    @Override
    public ParseResult parseToken(LoadContext context, KitSkill kitSkill, String value) {
        try {
            Integer quan = Integer.valueOf(value);
            if (quan <= 0) {
                return new ParseResult.Fail(this.getTokenName() + " expected an integer > 0", context);
            }
            kitSkill.setCount(quan);
            return ParseResult.SUCCESS;
        }
        catch (NumberFormatException nfe) {
            return new ParseResult.Fail(this.getTokenName() + " expected an integer.  Tag must be of the form: " + this.getTokenName() + ":<int>", context);
        }
    }

    @Override
    public String[] unparse(LoadContext context, KitSkill kitSkill) {
        Integer bd = kitSkill.getCount();
        if (bd == null) {
            return null;
        }
        return new String[]{bd.toString()};
    }
}

