/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.add;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ChoiceSet;
import pcgen.cdom.base.ConcretePersistentTransitionChoice;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.base.PersistentChoiceActor;
import pcgen.cdom.base.PersistentTransitionChoice;
import pcgen.cdom.base.SelectableSet;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.base.UserSelection;
import pcgen.cdom.choiceset.AbilityRefChoiceSet;
import pcgen.cdom.content.CNAbility;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.Nature;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.CNAbilitySelection;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.ParsingSeparator;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractNonEmptyToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.rules.persistence.token.ParseResult;
import pcgen.util.enumeration.Visibility;

public class AbilityToken
extends AbstractNonEmptyToken<CDOMObject>
implements CDOMSecondaryToken<CDOMObject>,
PersistentChoiceActor<CNAbilitySelection> {
    private static final Class<CNAbilitySelection> CAT_ABILITY_SELECTION_CLASS = CNAbilitySelection.class;
    private static final Class<Ability> ABILITY_CLASS = Ability.class;
    private static final Class<AbilityCategory> ABILITY_CATEGORY_CLASS = AbilityCategory.class;

    @Override
    public String getParentToken() {
        return "ADD";
    }

    private String getFullName() {
        return this.getParentToken() + ":" + this.getTokenName();
    }

    @Override
    public String getTokenName() {
        return "ABILITY";
    }

    @Override
    protected ParseResult parseNonEmptyToken(LoadContext context, CDOMObject obj, String value) {
        Formula count;
        if (this.isEmpty(value)) {
            return new ParseResult.Fail("Value in " + this.getFullName() + " may not be empty", context);
        }
        ParsingSeparator sep = new ParsingSeparator(value, '|');
        String first = sep.next();
        if (!sep.hasNext()) {
            return new ParseResult.Fail("Syntax of ADD:" + this.getTokenName() + " requires 3 to 4 |: " + value, context);
        }
        String second = sep.next();
        if (!sep.hasNext()) {
            return new ParseResult.Fail("Syntax of ADD:" + this.getTokenName() + " requires a minimum of three | : " + value, context);
        }
        String third = sep.next();
        if (sep.hasNext()) {
            count = FormulaFactory.getFormulaFor(first);
            if (!count.isValid()) {
                return new ParseResult.Fail("Count in " + this.getTokenName() + " was not valid: " + count.toString(), context);
            }
            if (count.isStatic() && count.resolveStatic().doubleValue() <= 0.0) {
                return new ParseResult.Fail("Count in " + this.getFullName() + " must be > 0", context);
            }
            first = second;
            second = third;
            third = sep.next();
        } else {
            count = FormulaFactory.ONE;
        }
        if (sep.hasNext()) {
            return new ParseResult.Fail("Syntax of ADD:" + this.getTokenName() + " has max of four | when a count is not present: " + value, context);
        }
        CDOMSingleRef<AbilityCategory> acRef = context.getReferenceContext().getCDOMReference(ABILITY_CATEGORY_CLASS, first);
        Nature nature = Nature.valueOf(second);
        if (nature == null) {
            return new ParseResult.Fail(this.getFullName() + ": Invalid ability nature: " + second, context);
        }
        if (Nature.ANY.equals((Object)nature)) {
            return new ParseResult.Fail(this.getTokenName() + " refers to ANY Ability Nature, cannot be used in " + this.getTokenName() + ": " + value);
        }
        if (Nature.AUTOMATIC.equals((Object)nature)) {
            return new ParseResult.Fail(this.getTokenName() + " refers to AUTOMATIC Ability Nature, cannot be used in " + this.getTokenName() + ": " + value, context);
        }
        ParseResult pr = this.checkSeparatorsAndNonEmpty(',', third);
        if (!pr.passed()) {
            return pr;
        }
        ArrayList refs = new ArrayList();
        ParsingSeparator tok = new ParsingSeparator(third, ',');
        boolean allowStack = false;
        int dupChoices = 0;
        ReferenceManufacturer<Ability> rm = context.getReferenceContext().getManufacturer(ABILITY_CLASS, ABILITY_CATEGORY_CLASS, first);
        if (rm == null) {
            return new ParseResult.Fail("Could not get Reference Manufacturer for Category: " + first, context);
        }
        while (tok.hasNext()) {
            String token = tok.next();
            if ("STACKS".equals(token)) {
                if (allowStack) {
                    return new ParseResult.Fail(this.getFullName() + " found second stacking specification in value: " + value, context);
                }
                allowStack = true;
                continue;
            }
            if (token.startsWith("STACKS=")) {
                if (allowStack) {
                    return new ParseResult.Fail(this.getFullName() + " found second stacking specification in value: " + value, context);
                }
                allowStack = true;
                try {
                    dupChoices = Integer.parseInt(token.substring(7));
                }
                catch (NumberFormatException nfe) {
                    return new ParseResult.Fail("Invalid Stack number in " + this.getFullName() + ": " + value, context);
                }
                if (dupChoices > 0) continue;
                return new ParseResult.Fail("Invalid (less than 1) Stack number in " + this.getFullName() + ": " + value, context);
            }
            CDOMReference ab = "ALL".equals(token) ? rm.getAllReference() : TokenUtilities.getTypeOrPrimitive(rm, token);
            if (ab == null) {
                return new ParseResult.Fail("  Error was encountered while parsing " + this.getTokenName() + ": " + value + " had an invalid reference: " + token, context);
            }
            refs.add(ab);
        }
        if (refs.isEmpty()) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains no ability reference: " + value, context);
        }
        AbilityRefChoiceSet rcs = new AbilityRefChoiceSet(acRef, refs, nature);
        if (!rcs.getGroupingState().isValid()) {
            return new ParseResult.Fail("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + value, context);
        }
        ChoiceSet.AbilityChoiceSet cs = new ChoiceSet.AbilityChoiceSet(this.getTokenName(), rcs);
        StringBuilder title = new StringBuilder(50);
        if (!Nature.NORMAL.equals((Object)nature)) {
            title.append(nature.toString());
            title.append(' ');
        }
        title.append(first);
        title.append(" Choice");
        cs.setTitle(title.toString());
        ConcretePersistentTransitionChoice<CNAbilitySelection> tc = new ConcretePersistentTransitionChoice<CNAbilitySelection>(cs, count);
        context.getObjectContext().addToList(obj, ListKey.ADD, tc);
        tc.allowStack(allowStack);
        if (dupChoices != 0) {
            tc.setStackLimit(dupChoices);
        }
        tc.setChoiceActor(this);
        return ParseResult.SUCCESS;
    }

    @Override
    public String[] unparse(LoadContext context, CDOMObject obj) {
        Changes<PersistentTransitionChoice<?>> grantChanges = context.getObjectContext().getListChanges(obj, ListKey.ADD);
        Collection<PersistentTransitionChoice<?>> addedItems = grantChanges.getAdded();
        if (addedItems == null || addedItems.isEmpty()) {
            return null;
        }
        ArrayList<String> addStrings = new ArrayList<String>();
        for (TransitionChoice transitionChoice : addedItems) {
            SelectableSet cs = transitionChoice.getChoices();
            if (!this.getTokenName().equals(cs.getName()) || !CAT_ABILITY_SELECTION_CLASS.equals(cs.getChoiceClass())) continue;
            ChoiceSet.AbilityChoiceSet ascs = (ChoiceSet.AbilityChoiceSet)cs;
            Formula f = transitionChoice.getCount();
            if (f == null) {
                context.addWriteMessage("Unable to find " + this.getFullName() + " Count");
                return null;
            }
            if (f.isStatic() && f.resolveStatic().doubleValue() <= 0.0) {
                context.addWriteMessage("Count in " + this.getFullName() + " must be > 0");
                return null;
            }
            if (!cs.getGroupingState().isValid()) {
                context.addWriteMessage("Non-sensical " + this.getFullName() + ": Contains ANY and a specific reference: " + cs.getLSTformat());
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (!FormulaFactory.ONE.equals(f)) {
                sb.append(f).append("|");
            }
            sb.append(ascs.getCategory().getLSTformat(false));
            sb.append("|");
            sb.append((Object)ascs.getNature());
            sb.append("|");
            if (transitionChoice.allowsStacking()) {
                sb.append("STACKS");
                Integer stackLimit = transitionChoice.getStackLimit();
                if (stackLimit != null) {
                    if (stackLimit <= 0) {
                        context.addWriteMessage("Stack Limit in " + this.getFullName() + " must be > 0");
                        return null;
                    }
                    sb.append("=");
                    sb.append(stackLimit);
                }
                sb.append(",");
            }
            sb.append(cs.getLSTformat());
            addStrings.add(sb.toString());
        }
        return addStrings.toArray(new String[addStrings.size()]);
    }

    @Override
    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }

    @Override
    public void applyChoice(CDOMObject owner, CNAbilitySelection choice, PlayerCharacter pc) {
        CNAbility cna = choice.getCNAbility();
        Ability ab = cna.getAbility();
        AbilityCategory cat = (AbilityCategory)cna.getAbilityCategory();
        boolean isVirtual = Nature.VIRTUAL.equals((Object)cna.getNature());
        if (isVirtual) {
            pc.addSavedAbility(choice, UserSelection.getInstance(), UserSelection.getInstance());
        } else {
            pc.addAbility(choice, UserSelection.getInstance(), UserSelection.getInstance());
            pc.adjustAbilities(cat, ab.getSafe(ObjectKey.SELECTION_COST));
        }
    }

    @Override
    public boolean allow(CNAbilitySelection choice, PlayerCharacter pc, boolean allowStack) {
        CNAbility cna = choice.getCNAbility();
        Ability ability = cna.getAbility();
        if (!ability.getSafe(ObjectKey.VISIBILITY).equals((Object)Visibility.DEFAULT)) {
            return false;
        }
        boolean isVirtual = Nature.VIRTUAL.equals((Object)cna.getNature());
        if (!isVirtual && !ability.qualifies(pc, ability)) {
            return false;
        }
        String selection = choice.getSelection();
        return !AbilityUtilities.alreadySelected(pc, ability, selection, allowStack);
    }

    @Override
    public CNAbilitySelection decodeChoice(LoadContext context, String s) {
        return CNAbilitySelection.getAbilitySelectionFromPersistentFormat(s);
    }

    @Override
    public String encodeChoice(CNAbilitySelection choice) {
        return choice.getPersistentFormat();
    }

    @Override
    public void restoreChoice(PlayerCharacter pc, CDOMObject owner, CNAbilitySelection choice) {
    }

    @Override
    public void removeChoice(PlayerCharacter pc, CDOMObject owner, CNAbilitySelection choice) {
        CNAbility cna = choice.getCNAbility();
        Ability ab = cna.getAbility();
        AbilityCategory cat = (AbilityCategory)cna.getAbilityCategory();
        if (cna.getNature().equals((Object)Nature.NORMAL)) {
            pc.adjustAbilities(cat, ab.getSafe(ObjectKey.SELECTION_COST).negate());
            pc.removeAbility(choice, UserSelection.getInstance(), UserSelection.getInstance());
        } else {
            pc.removeSavedAbility(choice, UserSelection.getInstance(), UserSelection.getInstance());
        }
    }
}

