/*
 * Decompiled with CFR 0.152.
 */
package plugin.initiative;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import plugin.initiative.PObjectModel;

public class AttackModel
extends PObjectModel {
    private static final int SEGMENT_POSITION_TOHIT = 1;
    private static final int SEGMENT_POSITION_RANGE = 2;
    private static final int SEGMENT_POSITION_TYPE = 3;
    private static final int SEGMENT_POSITION_DAMAGE = 4;
    private static final int SEGMENT_POSITION_CRITRANGE = 5;
    private static final int SEGMENT_POSITION_CRITMULT = 6;
    private static final int SEGMENT_POSITION_HAND = 7;
    private static final int SEGMENT_POSITION_SIZE = 8;
    private static final int SEGMENT_POSITION_SPROP = 9;
    private String hand = null;
    private String range = null;
    private String size = null;
    private String specialProp = null;
    private String type = null;
    private List<String> critMultiple = null;
    private List<String> critRange = null;
    private List<String> damage = null;
    private List<String> toHit = null;
    private int firstOffHandAttack = -1;

    public AttackModel(String objectString) {
        super(objectString);
        this.setToHit(this.getStringValue(this.outputTokens, 1));
        this.setRange(this.getStringValue(this.outputTokens, 2));
        this.setType(this.getStringValue(this.outputTokens, 3));
        this.setDamage(this.getStringValue(this.outputTokens, 4));
        this.setCritRange(this.getStringValue(this.outputTokens, 5));
        this.setCritMultiple(this.getStringValue(this.outputTokens, 6));
        this.setHand(this.getStringValue(this.outputTokens, 7));
        this.setSize(this.getStringValue(this.outputTokens, 8));
        this.setSpecialProp(this.getStringValue(this.outputTokens, 9));
    }

    public int[] getBonusList() {
        int[] returnValue = null;
        if (this.toHit != null && this.toHit.size() > 0) {
            returnValue = new int[this.toHit.size()];
            for (int i = 0; i < this.toHit.size(); ++i) {
                returnValue[i] = AttackModel.getInt(this.toHit.get(i).substring(1));
            }
        }
        return returnValue;
    }

    public void setCritMultiple(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer tok = new StringTokenizer(string, "/");
            if (this.critMultiple == null) {
                this.critMultiple = new ArrayList<String>(tok.countTokens());
            } else {
                this.critMultiple.clear();
            }
            while (tok.hasMoreTokens()) {
                this.critMultiple.add(tok.nextToken());
            }
        } else {
            if (this.critMultiple == null) {
                this.critMultiple = new ArrayList<String>(1);
            } else {
                this.critMultiple.clear();
            }
            this.critMultiple.add("2");
        }
    }

    public String getCritMultiple() {
        return StringUtil.join(this.critMultiple, (String)"/");
    }

    public String getCritMultiple(int index) {
        String returnValue = null;
        int lookupAt = 0;
        lookupAt = this.firstOffHandAttack != -1 && index >= this.firstOffHandAttack ? 1 : 0;
        if (this.critMultiple != null && this.critMultiple.size() > lookupAt) {
            returnValue = this.critMultiple.get(lookupAt);
        } else if (this.critMultiple != null && this.critMultiple.size() > 0) {
            returnValue = this.critMultiple.get(0);
        }
        return returnValue;
    }

    public void setCritRange(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer tok = new StringTokenizer(string, "/");
            if (this.critRange == null) {
                this.critRange = new ArrayList<String>(tok.countTokens());
            } else {
                this.critRange.clear();
            }
            while (tok.hasMoreTokens()) {
                this.critRange.add(tok.nextToken());
            }
        } else {
            if (this.critRange == null) {
                this.critRange = new ArrayList<String>(1);
            } else {
                this.critRange.clear();
            }
            this.critRange.add("20");
        }
    }

    public String getCritRange() {
        return StringUtil.join(this.critRange, (String)"/");
    }

    public String getCritRange(int index) {
        String returnValue = null;
        int lookupAt = 0;
        lookupAt = this.firstOffHandAttack != -1 && index >= this.firstOffHandAttack ? 1 : 0;
        if (this.critRange != null && this.critRange.size() > lookupAt) {
            returnValue = this.critRange.get(lookupAt);
        } else if (this.critRange != null && this.critRange.size() > 0) {
            returnValue = this.critRange.get(0);
        }
        return returnValue;
    }

    public int getCritRangeMin(int index) {
        String aRange = new StringTokenizer(this.getCritRange(index), "-").nextToken();
        int returnValue = AttackModel.getInt(aRange);
        return returnValue;
    }

    public void setDamage(String string) {
        if (string != null && string.length() > 0) {
            StringTokenizer tok = new StringTokenizer(string, "/");
            if (this.damage == null) {
                this.damage = new ArrayList<String>(tok.countTokens());
            } else {
                this.damage.clear();
            }
            while (tok.hasMoreTokens()) {
                this.damage.add(tok.nextToken());
            }
            if (this.damage.size() > 1) {
                String damageDice = this.damage.get(0);
                if (damageDice.lastIndexOf("+") > 0) {
                    damageDice = damageDice.substring(0, damageDice.lastIndexOf("+"));
                } else if (damageDice.lastIndexOf("-") > 0) {
                    damageDice = damageDice.substring(0, damageDice.lastIndexOf("-"));
                }
                for (int i = 1; i < this.damage.size(); ++i) {
                    String secondaryDamage = this.damage.get(i);
                    if (!secondaryDamage.startsWith("+") && !secondaryDamage.startsWith("-")) continue;
                    this.damage.set(i, damageDice + secondaryDamage);
                }
            }
        } else {
            if (this.damage == null) {
                this.damage = new ArrayList<String>(1);
            } else {
                this.damage.clear();
            }
            this.damage.add("1");
        }
    }

    public String getDamage() {
        return StringUtil.join(this.damage, (String)"/");
    }

    public String getDamage(int index) {
        String returnValue = null;
        int lookupAt = 0;
        lookupAt = this.firstOffHandAttack != -1 && index >= this.firstOffHandAttack ? 1 : 0;
        if (this.damage != null && this.damage.size() > lookupAt) {
            returnValue = this.damage.get(lookupAt);
        } else if (this.damage != null && this.damage.size() > 0) {
            returnValue = this.damage.get(0);
        }
        return returnValue;
    }

    public void setHand(String string) {
        this.hand = string;
    }

    public String getHand() {
        return this.hand;
    }

    public void setRange(String string) {
        this.range = string == null || string.length() > 0 ? string : "0'";
    }

    public String getRange() {
        return this.range;
    }

    public int getRangeAsInt() {
        return AttackModel.getInt(this.range.replaceAll("\\D", ""));
    }

    public void setSize(String string) {
        this.size = string;
    }

    public String getSize() {
        return this.size;
    }

    public void setSpecialProp(String string) {
        this.specialProp = string;
    }

    public String getSpecialProp() {
        return this.specialProp;
    }

    public void setToHit(String string) {
        if (this.toHit == null) {
            this.toHit = new ArrayList<String>();
        } else {
            this.toHit.clear();
        }
        this.firstOffHandAttack = -1;
        StringTokenizer tok = new StringTokenizer(string, ";");
        int handCount = 0;
        int attackIndex = -1;
        while (tok.hasMoreTokens()) {
            ++handCount;
            StringTokenizer tok2 = new StringTokenizer(tok.nextToken(), "/");
            while (tok2.hasMoreTokens()) {
                ++attackIndex;
                if (handCount == 2 && this.firstOffHandAttack == -1) {
                    this.firstOffHandAttack = attackIndex;
                }
                this.toHit.add(tok2.nextToken());
            }
        }
    }

    public String getToHit() {
        StringBuilder sb = new StringBuilder();
        if (this.toHit != null && this.toHit.size() > 0) {
            for (int i = 0; i < this.toHit.size(); ++i) {
                if (sb.length() > 0) {
                    if (i == this.firstOffHandAttack) {
                        sb.append(";");
                    } else {
                        sb.append("/");
                    }
                }
                sb.append(this.toHit.get(i));
            }
        }
        return sb.toString();
    }

    public String getToHit(int index) {
        String returnValue = null;
        if (this.toHit != null && this.toHit.size() > index) {
            returnValue = this.toHit.get(index);
        }
        return returnValue;
    }

    public void setType(String string) {
        this.type = string;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public String toString() {
        String returnValue = this.getName() + " " + this.getToHit() + " " + this.getRange() + "/" + this.getType() + " (" + this.getDamage() + " " + this.getCritRange() + "/x" + this.getCritMultiple() + " " + this.getHand() + " " + this.getSize() + ("".equals(this.getSpecialProp()) ? "" : this.getSpecialProp()) + ")";
        return returnValue;
    }
}

