/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import pcgen.gui2.tools.Icons;
import plugin.dicebag.gui.DiceBagGridLayout;
import plugin.dicebag.gui.DiceBagModel;

public class DiceBagView
extends JInternalFrame
implements Observer {
    DiceBagModel m_bag = null;
    private BagListener m_bagListener = new BagListener();
    private BagTableModel m_tableModel = new BagTableModel();
    private JButton m_deleteSelected;
    private JButton m_editButton;
    private JButton m_moveDown;
    private JButton m_moveUp;
    private JButton m_rollButton;
    private JButton m_stopEditing;
    private JLabel m_exprFieldLabel;
    private JLabel m_exprResult;
    private JLabel m_nameFieldLabel;
    private JPanel m_center;
    private JPanel m_top;
    private JPanel m_topBottom;
    private JPanel m_topTop;
    private JScrollPane m_scrollPane;
    private JTable m_table;
    private JTextField m_exprField;
    private JTextField m_nameField;
    private List<JButton> m_diceButtons;

    public DiceBagView(DiceBagModel bag) {
        this.m_bag = bag;
        this.initComponents();
    }

    public DiceBagModel getBag() {
        return this.m_bag;
    }

    public void handleEdit(ActionEvent e) {
        this.setupEditMode();
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    private void setRollResult(String diceRoll, double result) {
        String resultString = null;
        resultString = result % 1.0 == 0.0 ? Integer.toString((int)Math.round(result)) : Double.toString(result);
        this.m_exprResult.setText("<html><b>" + diceRoll + ": " + resultString + "</b></html>");
    }

    private void cleanup() {
        this.m_top.removeAll();
        this.m_topTop.removeAll();
        this.m_topBottom.removeAll();
        this.m_center.removeAll();
        this.getContentPane().removeAll();
    }

    private void deleteRecords(ActionEvent e) {
        while (this.m_table.getSelectedRow() >= 0 && this.m_table.getSelectedRow() < this.m_bag.diceCount()) {
            this.m_bag.removeDie(this.m_table.getSelectedRow());
            this.m_tableModel.fireTableRowsDeleted(this.m_table.getSelectedRow(), this.m_table.getSelectedRow());
        }
    }

    private void initComponents() {
        this.setTitle(this.m_bag.getName());
        this.setResizable(true);
        this.setClosable(true);
        this.setMaximizable(true);
        this.setIconifiable(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.m_top = new JPanel();
        this.m_topTop = new JPanel();
        this.m_topBottom = new JPanel();
        this.m_center = new JPanel();
        this.m_top.setLayout(new GridLayout(2, 1));
        this.m_topTop.setLayout(new BoxLayout(this.m_topTop, 0));
        this.m_topBottom.setLayout(new BoxLayout(this.m_topBottom, 0));
        this.m_center.setLayout(new DiceBagGridLayout(0, 3, 1, 75, 100));
        this.m_center.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.m_rollButton = new JButton("Roll");
        this.m_rollButton.setActionCommand("ROLL");
        this.m_rollButton.addActionListener(this.m_bagListener);
        this.m_exprResult = new JLabel(" ");
        this.m_exprResult.setMinimumSize(new Dimension(50, this.m_exprResult.getMinimumSize().height));
        this.m_exprResult.setPreferredSize(new Dimension(50, this.m_exprResult.getPreferredSize().height));
        this.m_exprResult.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.m_exprResult.getMaximumSize().height));
        this.m_editButton = new JButton("Edit");
        this.m_editButton.setActionCommand("EDIT");
        this.m_editButton.addActionListener(this.m_bagListener);
        this.m_diceButtons = new ArrayList<JButton>();
        this.m_exprField = new JTextField();
        this.m_exprFieldLabel = new JLabel("Roll Expr: ");
        this.m_table = new JTable(this.m_tableModel);
        this.m_scrollPane = new JScrollPane(this.m_table);
        this.m_stopEditing = new JButton("Stop Editing");
        this.m_stopEditing.setActionCommand("STOP_EDITING");
        this.m_stopEditing.addActionListener(this.m_bagListener);
        this.m_deleteSelected = new JButton("Delete");
        this.m_deleteSelected.setActionCommand("DELETE");
        this.m_deleteSelected.addActionListener(this.m_bagListener);
        this.m_moveUp = new JButton("Move up");
        this.m_moveUp.setActionCommand("MOVE_UP");
        this.m_moveUp.addActionListener(this.m_bagListener);
        this.m_moveDown = new JButton("Move down");
        this.m_moveDown.setActionCommand("MOVE_DOWN");
        this.m_moveDown.addActionListener(this.m_bagListener);
        this.m_nameField = new JTextField();
        this.m_nameFieldLabel = new JLabel("Name: ");
        this.m_nameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DiceBagView.this.m_bag.setName(DiceBagView.this.m_nameField.getText());
                DiceBagView.this.setTitle(DiceBagView.this.m_nameField.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DiceBagView.this.m_bag.setName(DiceBagView.this.m_nameField.getText());
                DiceBagView.this.setTitle(DiceBagView.this.m_nameField.getText());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.setFrameIcon(Icons.gmgen_icon.getImageIcon());
        this.setupRollingMode();
        this.pack();
    }

    private void moveRecordsDown(ActionEvent e) {
        for (int row = this.m_table.getRowCount() - 2; row >= 0; --row) {
            if (row >= this.m_table.getRowCount() - 2 || !this.m_table.isRowSelected(row) || this.m_table.isRowSelected(row + 1)) continue;
            String die1 = this.m_bag.getDie(row);
            String die2 = this.m_bag.getDie(row + 1);
            this.m_bag.setDie(row + 1, die1);
            this.m_bag.setDie(row, die2);
            this.m_tableModel.fireTableRowsUpdated(row, row + 1);
            this.m_table.getSelectionModel().addSelectionInterval(row + 1, row + 1);
            this.m_table.getSelectionModel().removeSelectionInterval(row, row);
        }
    }

    private void moveRecordsUp(ActionEvent e) {
        for (int row = 0; row < this.m_table.getRowCount(); ++row) {
            if (row <= 0 || !this.m_table.isRowSelected(row) || this.m_table.isRowSelected(row - 1)) continue;
            String die1 = this.m_bag.getDie(row);
            String die2 = this.m_bag.getDie(row - 1);
            this.m_bag.setDie(row - 1, die1);
            this.m_bag.setDie(row, die2);
            this.m_tableModel.fireTableRowsUpdated(row - 1, row);
            this.m_table.getSelectionModel().addSelectionInterval(row - 1, row - 1);
            this.m_table.getSelectionModel().removeSelectionInterval(row, row);
        }
    }

    private void setupEditMode() {
        this.cleanup();
        this.getContentPane().add((Component)this.m_center, "Center");
        this.getContentPane().add((Component)this.m_top, "North");
        this.m_top.add(this.m_topTop);
        this.m_top.add(this.m_topBottom);
        this.m_nameField.setPreferredSize(new Dimension(100, this.m_nameField.getPreferredSize().height));
        this.m_topBottom.add(this.m_nameFieldLabel);
        this.m_topBottom.add(this.m_nameField);
        this.m_nameField.setText(this.m_bag.getName());
        if (this.m_center.getLayout() instanceof DiceBagGridLayout) {
            ((DiceBagGridLayout)this.m_center.getLayout()).setRows(1);
            ((DiceBagGridLayout)this.m_center.getLayout()).setColumns(1);
        }
        this.m_center.add(this.m_scrollPane);
        this.m_topTop.add(this.m_stopEditing);
        this.m_topTop.add(Box.createHorizontalStrut(5));
        this.m_topTop.add(this.m_deleteSelected);
        this.m_topTop.add(Box.createHorizontalStrut(5));
        this.m_topTop.add(this.m_moveUp);
        this.m_topTop.add(Box.createHorizontalStrut(5));
        this.m_topTop.add(this.m_moveDown);
        this.m_table.setPreferredScrollableViewportSize(new Dimension(this.m_table.getPreferredScrollableViewportSize().width, 200));
        this.getContentPane().validate();
        this.pack();
    }

    private void setupRollingMode() {
        this.cleanup();
        if (this.m_center.getLayout() instanceof DiceBagGridLayout) {
            ((DiceBagGridLayout)this.m_center.getLayout()).setRows(0);
            ((DiceBagGridLayout)this.m_center.getLayout()).setColumns(3);
        }
        this.getContentPane().add((Component)this.m_top, "North");
        this.getContentPane().add((Component)this.m_center, "Center");
        this.m_top.add(this.m_topTop);
        this.m_top.add(this.m_topBottom);
        this.m_topTop.add(this.m_exprFieldLabel);
        this.m_exprField.setPreferredSize(new Dimension(50, this.m_exprField.getPreferredSize().height));
        this.m_topTop.add(this.m_exprField);
        this.m_topTop.add(Box.createHorizontalStrut(10));
        this.m_topTop.add(this.m_rollButton);
        this.m_topBottom.add(this.m_exprResult);
        this.m_topBottom.add(Box.createHorizontalStrut(10));
        this.m_topBottom.add(this.m_editButton);
        for (int i = 0; i < this.m_bag.diceCount(); ++i) {
            JButton button = null;
            if (this.m_diceButtons.size() > i) {
                button = this.m_diceButtons.get(i);
            } else {
                button = new JButton(" ");
                button.setPreferredSize(new Dimension(100, button.getPreferredSize().height));
                button.addActionListener(this.m_bagListener);
                button.setActionCommand(Integer.toString(i));
                this.m_diceButtons.add(button);
            }
            button.setText(this.m_bag.getDie(i));
            this.m_center.add(button);
        }
        this.getContentPane().validate();
        this.pack();
    }

    private void stopEditing(ActionEvent e) {
        this.setupRollingMode();
    }

    private class BagTableModel
    extends AbstractTableModel {
        private BagTableModel() {
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int column) {
            return "Dice Expression";
        }

        @Override
        public int getRowCount() {
            return DiceBagView.this.m_bag.diceCount() + 1;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex >= 0 && rowIndex < this.getRowCount() - 1) {
                if (aValue == null || aValue.toString().length() == 0) {
                    DiceBagView.this.m_bag.removeDie(rowIndex);
                    this.fireTableRowsDeleted(rowIndex, rowIndex);
                } else {
                    DiceBagView.this.m_bag.setDie(rowIndex, aValue.toString());
                }
            } else if (rowIndex == this.getRowCount() - 1) {
                DiceBagView.this.m_bag.addDie(aValue.toString());
                this.fireTableRowsInserted(rowIndex, rowIndex);
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            String returnValue = null;
            if (rowIndex >= 0 && rowIndex < this.getRowCount() - 1) {
                returnValue = DiceBagView.this.m_bag.getDie(rowIndex);
            }
            return returnValue;
        }
    }

    private class BagListener
    implements ActionListener {
        private BagListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if ("ROLL".equals(command)) {
                DiceBagView.this.setRollResult(DiceBagView.this.m_exprField.getText(), DiceBagView.this.m_bag.rollDie(DiceBagView.this.m_exprField.getText()));
            } else if ("EDIT".equals(command)) {
                DiceBagView.this.handleEdit(e);
            } else if ("STOP_EDITING".equals(command)) {
                DiceBagView.this.stopEditing(e);
            } else if ("DELETE".equals(command)) {
                DiceBagView.this.deleteRecords(e);
            } else if ("MOVE_UP".equals(command)) {
                DiceBagView.this.moveRecordsUp(e);
            } else if ("MOVE_DOWN".equals(command)) {
                DiceBagView.this.moveRecordsDown(e);
            } else {
                try {
                    int index = Integer.parseInt(command);
                    DiceBagView.this.setRollResult(DiceBagView.this.m_bag.getDie(index), DiceBagView.this.m_bag.rollDie(index));
                }
                catch (NumberFormatException ex) {
                    System.err.println("Invalid command passed to BagListener.");
                    ex.printStackTrace();
                }
            }
        }
    }
}

