/*
 * Decompiled with CFR 0.152.
 */
package pcgen.util;

import java.io.File;
import java.io.IOException;
import pcgen.util.Logging;

public class FileHelper {
    private FileHelper() {
    }

    public static String findRelativePath(File base, File relative) {
        File relativeCanon;
        File testFile;
        try {
            testFile = base.getCanonicalFile();
            relativeCanon = relative.getCanonicalFile();
        }
        catch (IOException e) {
            return relative.getAbsolutePath();
        }
        if (!testFile.isDirectory()) {
            testFile = testFile.getParentFile();
        }
        if (!FileHelper.findRoot(testFile).equals(FileHelper.findRoot(relativeCanon))) {
            return relativeCanon.getAbsolutePath();
        }
        String relativePath = FileHelper.stripOffRoot(relativeCanon);
        StringBuilder dots = new StringBuilder();
        do {
            if (testFile.getParentFile() == null) {
                return dots.append(relativePath).toString();
            }
            String testPath = FileHelper.stripOffRoot(testFile);
            if (relativePath.indexOf(testPath) == 0) {
                if (testPath.length() >= relativePath.length()) {
                    Logging.log(Logging.WARNING, "Unable to get path for " + relative + " relative to " + base + ". Using absolute path.");
                    return relative.getAbsolutePath();
                }
                String pieceToKeep = relativePath.substring(testPath.length() + 1, relativePath.length());
                return dots.append(pieceToKeep).toString();
            }
            dots.append(".." + File.separator);
        } while ((testFile = testFile.getParentFile()) != null);
        return dots + relativePath;
    }

    private static String findRoot(File file) {
        File test = file;
        while (test.getParentFile() != null) {
            test = test.getParentFile();
        }
        return test.getAbsolutePath();
    }

    private static String stripOffRoot(File relative) {
        String root = FileHelper.findRoot(relative);
        return relative.getAbsolutePath().substring(root.length(), relative.getAbsolutePath().length());
    }
}

