/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.tabs.spells;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.apache.commons.lang.StringUtils;
import pcgen.facade.core.CharacterFacade;
import pcgen.facade.core.ClassFacade;
import pcgen.facade.core.SpellFacade;
import pcgen.facade.core.SpellSupportFacade;
import pcgen.facade.util.ListFacade;
import pcgen.gui2.filter.Filter;
import pcgen.gui2.filter.FilterBar;
import pcgen.gui2.filter.FilterButton;
import pcgen.gui2.filter.FilterUtilities;
import pcgen.gui2.filter.FilteredTreeViewTable;
import pcgen.gui2.filter.SearchFilterPanel;
import pcgen.gui2.tabs.CharacterInfoTab;
import pcgen.gui2.tabs.TabTitle;
import pcgen.gui2.tabs.models.CharacterComboBoxModel;
import pcgen.gui2.tabs.spells.ClassInfoHandler;
import pcgen.gui2.tabs.spells.QualifiedSpellTreeCellRenderer;
import pcgen.gui2.tabs.spells.SpellInfoHandler;
import pcgen.gui2.tabs.spells.SpellTreeViewModel;
import pcgen.gui2.tools.FlippingSplitPane;
import pcgen.gui2.tools.Icons;
import pcgen.gui2.tools.InfoPane;
import pcgen.gui2.util.JTreeViewTable;
import pcgen.system.LanguageBundle;
import pcgen.util.enumeration.Tab;

public class SpellBooksTab
extends FlippingSplitPane
implements CharacterInfoTab {
    private final TabTitle tabTitle = new TabTitle(Tab.SPELLBOOKS);
    private final FilteredTreeViewTable<CharacterFacade, SpellSupportFacade.SuperNode> availableTable = new FilteredTreeViewTable();
    private final JTreeViewTable<SpellSupportFacade.SuperNode> selectedTable = new JTreeViewTable();
    private final QualifiedSpellTreeCellRenderer spellRenderer = new QualifiedSpellTreeCellRenderer();
    private final JButton addButton = new JButton();
    private final JButton removeButton = new JButton();
    private final FilterButton<CharacterFacade, SpellSupportFacade.SuperNode> qFilterButton = new FilterButton("SpellBooksQualified");
    private final InfoPane spellsPane = new InfoPane(LanguageBundle.getString("InfoSpells.spell.info"));
    private final InfoPane classPane = new InfoPane(LanguageBundle.getString("InfoSpells.class.info"));
    private final JComboBox defaultBookCombo = new JComboBox();

    public SpellBooksTab() {
        super("SpellBooks");
        this.initComponents();
    }

    private void initComponents() {
        this.availableTable.setTreeCellRenderer(this.spellRenderer);
        this.selectedTable.setTreeCellRenderer(this.spellRenderer);
        FilterBar<Object, Object> filterBar = new FilterBar<Object, Object>();
        filterBar.addDisplayableFilter(new SearchFilterPanel());
        this.qFilterButton.setText(LanguageBundle.getString("in_igQualFilter"));
        filterBar.addDisplayableFilter(this.qFilterButton);
        FlippingSplitPane upperPane = new FlippingSplitPane("SpellBooksTop");
        JPanel availPanel = FilterUtilities.configureFilteredTreeViewPane(this.availableTable, filterBar);
        Box box = Box.createVerticalBox();
        box.add(Box.createVerticalStrut(5));
        Box hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(new JLabel(LanguageBundle.getString("InfoSpells.set.auto.book")));
        hbox.add(Box.createHorizontalGlue());
        box.add(hbox);
        box.add(Box.createVerticalStrut(5));
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.defaultBookCombo);
        hbox.add(Box.createHorizontalGlue());
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.addButton);
        hbox.add(Box.createHorizontalStrut(5));
        box.add(hbox);
        box.add(Box.createVerticalStrut(5));
        availPanel.add((Component)box, "South");
        upperPane.setLeftComponent(availPanel);
        box = Box.createVerticalBox();
        box.add(new JScrollPane(this.selectedTable));
        box.add(Box.createVerticalStrut(5));
        hbox = Box.createHorizontalBox();
        hbox.add(Box.createHorizontalStrut(5));
        hbox.add(this.removeButton);
        hbox.add(Box.createHorizontalGlue());
        box.add(hbox);
        box.add(Box.createVerticalStrut(5));
        upperPane.setRightComponent(box);
        upperPane.setResizeWeight(0.0);
        this.setTopComponent(upperPane);
        FlippingSplitPane bottomPane = new FlippingSplitPane("SpellBooksBottom");
        bottomPane.setLeftComponent(this.spellsPane);
        bottomPane.setRightComponent(this.classPane);
        this.setBottomComponent(bottomPane);
        this.setOrientation(0);
    }

    @Override
    public CharacterInfoTab.ModelMap createModels(CharacterFacade character) {
        CharacterInfoTab.ModelMap models = new CharacterInfoTab.ModelMap();
        models.put(TreeViewModelHandler.class, new TreeViewModelHandler(character));
        models.put(AddSpellAction.class, new AddSpellAction(character));
        models.put(RemoveSpellAction.class, new RemoveSpellAction(character));
        models.put(SpellInfoHandler.class, new SpellInfoHandler(character, this.availableTable, this.selectedTable, this.spellsPane));
        models.put(ClassInfoHandler.class, new ClassInfoHandler(character, this.availableTable, this.selectedTable, this.classPane));
        models.put(SpellBookModel.class, new SpellBookModel(character));
        models.put(SpellFilterHandler.class, new SpellFilterHandler(character));
        return models;
    }

    @Override
    public void restoreModels(CharacterInfoTab.ModelMap models) {
        models.get(SpellFilterHandler.class).install();
        models.get(TreeViewModelHandler.class).install();
        models.get(SpellInfoHandler.class).install();
        models.get(ClassInfoHandler.class).install();
        models.get(AddSpellAction.class).install();
        models.get(RemoveSpellAction.class).install();
        this.defaultBookCombo.setModel(models.get(SpellBookModel.class));
    }

    @Override
    public void storeModels(CharacterInfoTab.ModelMap models) {
        models.get(SpellInfoHandler.class).uninstall();
        models.get(ClassInfoHandler.class).uninstall();
        models.get(AddSpellAction.class).uninstall();
        models.get(RemoveSpellAction.class).uninstall();
        models.get(TreeViewModelHandler.class).uninstall();
    }

    @Override
    public TabTitle getTabTitle() {
        return this.tabTitle;
    }

    String getCurrentSpellBookName(CharacterFacade character) {
        Object firstElem;
        ListFacade<?> data;
        String spellList = "";
        Object selectedObject = this.selectedTable.getSelectedObject();
        if (selectedObject != null) {
            if (selectedObject instanceof SpellSupportFacade.SpellNode) {
                spellList = ((SpellSupportFacade.SpellNode)selectedObject).getRootNode().getName();
            } else if (selectedObject instanceof SpellSupportFacade.RootNode) {
                spellList = ((SpellSupportFacade.RootNode)selectedObject).getName();
            } else {
                JTree tree = this.selectedTable.getTree();
                TreePath path = tree.getSelectionPath();
                while (path.getParentPath() != null && path.getParentPath().getParentPath() != null) {
                    path = path.getParentPath();
                }
                spellList = path.getLastPathComponent().toString();
            }
        }
        if (StringUtils.isEmpty(spellList) && !(data = this.selectedTable.getTreeViewModel().getDataModel()).isEmpty() && (firstElem = data.getElementAt(0)) instanceof SpellSupportFacade.SpellNode) {
            spellList = ((SpellSupportFacade.SpellNode)firstElem).getRootNode().getName();
        }
        return spellList;
    }

    private class SpellFilterHandler
    implements Filter<CharacterFacade, SpellSupportFacade.SuperNode> {
        private final CharacterFacade character;

        public SpellFilterHandler(CharacterFacade character) {
            this.character = character;
        }

        public void install() {
            SpellBooksTab.this.qFilterButton.setFilter(this);
        }

        @Override
        public boolean accept(CharacterFacade context, SpellSupportFacade.SuperNode element) {
            if (element instanceof SpellSupportFacade.SpellNode) {
                SpellSupportFacade.SpellNode spellNode = (SpellSupportFacade.SpellNode)element;
                SpellFacade spell = spellNode.getSpell();
                ClassFacade pcClass = spellNode.getSpellcastingClass();
                return this.character.isQualifiedFor(spell, pcClass);
            }
            return true;
        }
    }

    private class TreeViewModelHandler {
        private final SpellTreeViewModel availableModel;
        private final SpellTreeViewModel selectedModel;
        private final CharacterFacade character;

        public TreeViewModelHandler(CharacterFacade character) {
            this.character = character;
            this.availableModel = new SpellTreeViewModel(character.getSpellSupport().getKnownSpellNodes(), false, "SpellBooksAva", character.getInfoFactory());
            this.selectedModel = new SpellTreeViewModel(character.getSpellSupport().getBookSpellNodes(), true, "SpellBooksSel", character.getInfoFactory());
        }

        public void install() {
            SpellBooksTab.this.spellRenderer.setCharacter(this.character);
            SpellBooksTab.this.availableTable.setTreeViewModel(this.availableModel);
            SpellBooksTab.this.selectedTable.setTreeViewModel(this.selectedModel);
        }

        public void uninstall() {
            SpellBooksTab.this.spellRenderer.setCharacter(null);
        }
    }

    private class RemoveSpellAction
    extends AbstractAction {
        private final CharacterFacade character;

        public RemoveSpellAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", Icons.Back16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = SpellBooksTab.this.selectedTable.getSelectedData();
            for (Object object : data) {
                if (!(object instanceof SpellSupportFacade.SpellNode)) continue;
                SpellSupportFacade.SpellNode node = (SpellSupportFacade.SpellNode)object;
                this.character.getSpellSupport().removeFromSpellBook(node, node.getRootNode().getName());
            }
        }

        public void install() {
            SpellBooksTab.this.selectedTable.addActionListener(this);
            SpellBooksTab.this.removeButton.setAction(this);
        }

        public void uninstall() {
            SpellBooksTab.this.selectedTable.removeActionListener(this);
        }
    }

    private class AddSpellAction
    extends AbstractAction {
        private final CharacterFacade character;

        public AddSpellAction(CharacterFacade character) {
            this.character = character;
            this.putValue("SmallIcon", Icons.Forward16.getImageIcon());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<Object> data = SpellBooksTab.this.availableTable.getSelectedData();
            String bookname = SpellBooksTab.this.getCurrentSpellBookName(this.character);
            for (Object object : data) {
                if (!(object instanceof SpellSupportFacade.SpellNode)) continue;
                this.character.getSpellSupport().addToSpellBook((SpellSupportFacade.SpellNode)object, bookname);
            }
        }

        public void install() {
            SpellBooksTab.this.availableTable.addActionListener(this);
            SpellBooksTab.this.addButton.setAction(this);
        }

        public void uninstall() {
            SpellBooksTab.this.availableTable.removeActionListener(this);
        }
    }

    private class SpellBookModel
    extends CharacterComboBoxModel<String> {
        private final SpellSupportFacade spellSupport;

        public SpellBookModel(CharacterFacade character) {
            this.spellSupport = character.getSpellSupport();
            this.setListFacade(this.spellSupport.getSpellbooks());
            this.setReference(this.spellSupport.getDefaultSpellBookRef());
        }

        @Override
        public void setSelectedItem(Object anItem) {
            this.spellSupport.setDefaultSpellBook((String)anItem);
        }
    }
}

