/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui2.facade;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.BodyStructure;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SystemCollections;
import pcgen.core.character.EquipSet;
import pcgen.core.character.EquipSlot;
import pcgen.core.display.CharacterDisplay;
import pcgen.facade.core.BodyStructureFacade;
import pcgen.facade.core.DataSetFacade;
import pcgen.facade.core.EquipmentFacade;
import pcgen.facade.core.EquipmentListFacade;
import pcgen.facade.core.EquipmentSetFacade;
import pcgen.facade.core.UIDelegate;
import pcgen.facade.util.DefaultListFacade;
import pcgen.facade.util.DefaultReferenceFacade;
import pcgen.facade.util.ListFacade;
import pcgen.facade.util.ReferenceFacade;
import pcgen.facade.util.event.ListEvent;
import pcgen.facade.util.event.ListListener;
import pcgen.gui2.facade.CharacterFacadeImpl;
import pcgen.gui2.facade.EquipmentListFacadeImpl;
import pcgen.gui2.facade.TodoFacadeImpl;
import pcgen.gui2.facade.TodoManager;
import pcgen.system.LanguageBundle;
import pcgen.util.Logging;
import pcgen.util.enumeration.Tab;

public class EquipmentSetFacadeImpl
implements EquipmentSetFacade,
EquipmentListFacade.EquipmentListListener,
ListListener<EquipmentFacade> {
    private final PlayerCharacter theCharacter;
    private final CharacterDisplay charDisplay;
    private EquipSet eqSet;
    private final UIDelegate delegate;
    private final TodoManager todoManager;
    private final DataSetFacade dataSet;
    private final EquipmentListFacadeImpl purchasedList;
    private List<EquipmentSetFacade.EquipmentTreeListener> listeners = new ArrayList<EquipmentSetFacade.EquipmentTreeListener>();
    private DefaultReferenceFacade<String> name;
    private EquipmentListFacadeImpl equippedItemsList;
    private Map<String, BodyStructure> bodyStructMap;
    private double totalWeight = 0.0;
    private DefaultListFacade<EquipmentSetFacade.EquipNode> nodeList;
    private Map<EquipSlot, EquipmentSetFacade.EquipNode> equipSlotNodeMap;
    private Map<String, EquipNodeImpl> naturalWeaponNodes;
    private Set<EquipNodeImpl> hiddenPhantomNodes;
    private CharacterFacadeImpl characterFacadeImpl;

    public EquipmentSetFacadeImpl(UIDelegate delegate, PlayerCharacter pc, EquipSet eqSet, DataSetFacade dataSet, EquipmentListFacadeImpl purchasedList, TodoManager todoManager, CharacterFacadeImpl characterFacadeImpl) {
        this.delegate = delegate;
        this.theCharacter = pc;
        this.todoManager = todoManager;
        this.characterFacadeImpl = characterFacadeImpl;
        this.charDisplay = pc.getDisplay();
        this.dataSet = dataSet;
        this.purchasedList = purchasedList;
        this.initForEquipSet(eqSet);
        purchasedList.addEquipmentListListener(this);
        purchasedList.addListListener(this);
    }

    private void initForEquipSet(EquipSet equipSet) {
        this.eqSet = equipSet;
        this.name = new DefaultReferenceFacade<String>(equipSet.getName());
        this.bodyStructMap = new HashMap<String, BodyStructure>();
        this.equippedItemsList = new EquipmentListFacadeImpl();
        this.naturalWeaponNodes = new HashMap<String, EquipNodeImpl>();
        this.hiddenPhantomNodes = new HashSet<EquipNodeImpl>();
        for (BodyStructureFacade bodyStruct : this.dataSet.getEquipmentLocations()) {
            this.bodyStructMap.put(bodyStruct.toString(), (BodyStructure)bodyStruct);
        }
        this.buildNodeList();
        ArrayList<EquipSet> equipList = new ArrayList<EquipSet>(this.charDisplay.getEquipSet());
        Collections.sort(equipList);
        this.createNaturalWeaponSlots();
        this.updateNaturalWeaponSlots();
        this.updatePhantomSlots();
        this.addChildrenToPath(equipSet.getIdPath(), equipList, null);
    }

    private void buildNodeList() {
        this.nodeList = new DefaultListFacade();
        this.equipSlotNodeMap = new LinkedHashMap<EquipSlot, EquipmentSetFacade.EquipNode>();
        int index = 0;
        for (BodyStructureFacade bodyStruct : this.dataSet.getEquipmentLocations()) {
            String structString = bodyStruct.toString();
            EquipNodeImpl node = new EquipNodeImpl((BodyStructure)bodyStruct, index++);
            this.nodeList.addElement(node);
            for (EquipSlot slot : SystemCollections.getUnmodifiableEquipSlotList()) {
                String bodyStructureName = slot.getBodyStructureName();
                String hands = "HANDS";
                if ("Ring".equalsIgnoreCase(slot.getSlotName()) || "Fingers".equalsIgnoreCase(slot.getSlotName())) {
                    bodyStructureName = "HANDS";
                }
                if (!bodyStructureName.equalsIgnoreCase(structString)) continue;
                if (slot.canContainType("WEAPON")) {
                    if (this.charDisplay.getHands() > 0) {
                        this.addEquipNodeForEquipSlot(node, this.createWeaponEquipSlot(slot, "Primary Hand"), true);
                    }
                    for (int i = 1; i < this.charDisplay.getHands(); ++i) {
                        if (i > 1) {
                            this.addEquipNodeForEquipSlot(node, this.createWeaponEquipSlot(slot, "Secondary Hand " + i), true);
                            continue;
                        }
                        this.addEquipNodeForEquipSlot(node, this.createWeaponEquipSlot(slot, "Secondary Hand"), true);
                    }
                    this.addEquipNodeForEquipSlot(node, this.createWeaponEquipSlot(slot, "Double Weapon"), true);
                    this.addEquipNodeForEquipSlot(node, this.createWeaponEquipSlot(slot, "Both Hands"), true);
                    this.addEquipNodeForEquipSlot(node, this.createWeaponEquipSlot(slot, "Unarmed"), true);
                    continue;
                }
                this.addEquipNodeForEquipSlot(node, slot, false);
            }
        }
    }

    private EquipSlot createWeaponEquipSlot(EquipSlot slot, String slotName) {
        EquipSlot wpnSlot = slot.clone();
        wpnSlot.setSlotName(slotName);
        return wpnSlot;
    }

    private void addEquipNodeForEquipSlot(EquipNodeImpl bodyStructNode, EquipSlot slot, boolean singleOnly) {
        EquipNodeImpl slotNode = new EquipNodeImpl(bodyStructNode, slot, singleOnly);
        this.nodeList.addElement(slotNode);
        this.equipSlotNodeMap.put(slot, slotNode);
    }

    private void addChildrenToPath(String idPath, List<EquipSet> equipList, EquipNodeImpl parent) {
        ArrayList<EquipNodeImpl> children = new ArrayList<EquipNodeImpl>();
        for (int iSet = 0; iSet < equipList.size(); ++iSet) {
            EquipSet es = equipList.get(iSet);
            if (!es.getParentIdPath().equals(idPath)) continue;
            EquipSlot slot = Globals.getEquipSlotByName(es.getName());
            EquipNodeImpl slotNode = (EquipNodeImpl)this.equipSlotNodeMap.get(slot);
            EquipNodeImpl parentNode = parent;
            if (parentNode == null) {
                if (slotNode != null) {
                    parentNode = (EquipNodeImpl)slotNode.getParent();
                } else {
                    for (EquipmentSetFacade.EquipNode scanNode : this.nodeList) {
                        if (scanNode.getNodeType() == EquipmentSetFacade.EquipNode.NodeType.BODY_SLOT && scanNode.toString().equals(es.getName())) {
                            parentNode = (EquipNodeImpl)scanNode;
                            break;
                        }
                        if (scanNode.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.PHANTOM_SLOT || !scanNode.toString().equals(es.getName())) continue;
                        parentNode = (EquipNodeImpl)scanNode.getParent();
                        slotNode = (EquipNodeImpl)scanNode;
                        slot = ((EquipNodeImpl)scanNode).getSlot();
                        break;
                    }
                }
            }
            if (parentNode != null) {
                EquipNodeImpl node = new EquipNodeImpl(parentNode, slot, es.getItem(), es.getIdPath());
                this.nodeList.addElement(node);
                if (slotNode != null && slotNode.getNodeType() == EquipmentSetFacade.EquipNode.NodeType.PHANTOM_SLOT && this.getNumFreeSlots(slotNode) <= 0) {
                    this.nodeList.removeElement(slotNode);
                    for (EquipmentSetFacade.EquipNode inompatNode : this.getIncompatibleWeaponSlots(slotNode)) {
                        this.nodeList.removeElement(inompatNode);
                    }
                }
                this.updateTotalQuantity(es.getItem(), es.getItem().getQty().intValue());
                children.add(node);
            } else {
                Logging.errorPrint("Could not find parent for " + es.getName() + " for item " + es.getItem() + " at path " + es.getIdPath());
            }
            equipList.remove(es);
            --iSet;
        }
        for (EquipNodeImpl equipNodeImpl : children) {
            this.addChildrenToPath(equipNodeImpl.getIdPath(), equipList, equipNodeImpl);
        }
    }

    protected void activateEquipSet() {
        this.theCharacter.setCalcEquipSetId(this.eqSet.getIdPath());
        this.theCharacter.setCalcEquipmentList();
        this.updateOutputOrder();
        this.theCharacter.setUseTempMods(this.eqSet.getUseTempMods());
        this.theCharacter.calcActiveBonuses();
        this.theCharacter.setDirty(true);
    }

    private void updateTotalWeight(Equipment equip, float quantity, BodyStructureFacade root) {
        if (!"Not Carried".equals(root.toString())) {
            equip.setNumberCarried(Float.valueOf(equip.getCarried().floatValue() + quantity));
            if (!"Carried".equals(root.toString())) {
                equip.setNumberEquipped((int)((float)equip.getNumberEquipped() + quantity));
            }
        }
        this.theCharacter.setCalcEquipmentList();
        if (!"Not Carried".equals(root.toString())) {
            this.totalWeight = this.charDisplay.totalWeight().floatValue();
        }
    }

    static String getNewIdPath(CharacterDisplay display, EquipSet parentSet) {
        String pid = "0";
        int newID = 0;
        if (parentSet != null) {
            pid = parentSet.getIdPath();
        }
        for (EquipSet es : display.getEquipSet()) {
            if (!es.getParentIdPath().equals(pid) || es.getId() <= newID) continue;
            newID = es.getId();
        }
        DecimalFormat format = parentSet != null ? new DecimalFormat("00") : new DecimalFormat("0");
        return pid + '.' + format.format(++newID);
    }

    private String shiftEquipSetsDown(EquipSet parentSet, EquipNodeImpl startingNode, Map<String, EquipNodeImpl> origPathToNode, Map<String, EquipSet> origPathToEquipSet) {
        DecimalFormat format;
        String pid = "0";
        DecimalFormat decimalFormat = format = parentSet != null ? new DecimalFormat("00") : new DecimalFormat("0");
        if (parentSet != null) {
            pid = parentSet.getIdPath();
        }
        String startingPath = startingNode.idPath;
        int startingId = EquipSet.getIdFromPath(startingPath);
        for (Map.Entry<String, EquipNodeImpl> entry : origPathToNode.entrySet()) {
            String origPath = entry.getKey();
            EquipNodeImpl node = entry.getValue();
            EquipSet es = origPathToEquipSet.get(origPath);
            int esId = es.getId();
            if (!es.getParentIdPath().equals(pid)) continue;
            if (esId >= startingId) {
                ++esId;
            }
            String newPath = pid + '.' + format.format(esId);
            es.setIdPath(newPath);
            this.updateContainerPath(origPath, newPath, origPathToNode, origPathToEquipSet);
            node.setIdPath(newPath);
            this.nodeList.modifyElement(node);
        }
        String newPath = pid + '.' + format.format(startingId);
        return newPath;
    }

    private void updateContainerPath(String parentOrigPath, String parentNewPath, Map<String, EquipNodeImpl> origPathToNode, Map<String, EquipSet> origPathToEquipSet) {
        for (Map.Entry<String, EquipSet> entry : origPathToEquipSet.entrySet()) {
            String origItemPath = entry.getKey();
            EquipSet itemEs = entry.getValue();
            if (!origItemPath.startsWith(parentOrigPath) || origItemPath.equals(parentOrigPath)) continue;
            String newItemPath = origItemPath.replace(parentOrigPath, parentNewPath);
            itemEs.setIdPath(newItemPath);
            EquipNodeImpl node = origPathToNode.get(origItemPath);
            if (node == null) continue;
            node.setIdPath(newItemPath);
            this.nodeList.modifyElement(node);
        }
    }

    private Map<String, EquipNodeImpl> buildPathNodeMap() {
        HashMap<String, EquipNodeImpl> pathMap = new HashMap<String, EquipNodeImpl>();
        for (EquipmentSetFacade.EquipNode node : this.nodeList) {
            if (!(node instanceof EquipNodeImpl) || ((EquipNodeImpl)node).getIdPath() == null) continue;
            EquipNodeImpl eni = (EquipNodeImpl)node;
            pathMap.put(eni.idPath, eni);
        }
        return pathMap;
    }

    private Map<String, EquipSet> buildPathEquipSetMap() {
        HashMap<String, EquipSet> esMap = new HashMap<String, EquipSet>();
        for (EquipSet es : this.charDisplay.getEquipSet()) {
            esMap.put(es.getIdPath(), es);
        }
        return esMap;
    }

    @Override
    public EquipmentFacade addEquipment(EquipmentSetFacade.EquipNode node, EquipmentFacade equipment, int quantity) {
        return this.addEquipment(node, equipment, quantity, null);
    }

    @Override
    public EquipmentFacade addEquipment(EquipmentSetFacade.EquipNode node, EquipmentFacade equipment, int quantity, EquipmentSetFacade.EquipNode beforeNode) {
        String locName;
        EquipSlot equipSlot;
        EquipSet parentEs;
        EquipNodeImpl parent;
        if (!(node instanceof EquipNodeImpl)) {
            return null;
        }
        if (!(equipment instanceof Equipment)) {
            return null;
        }
        Equipment item = (Equipment)equipment;
        EquipNodeImpl targetNode = (EquipNodeImpl)node;
        if (!this.canEquip(targetNode, equipment)) {
            this.delegate.showErrorMessage("PCGen", LanguageBundle.getFormattedString("in_equipCannotEquipToLocation", item.toString(), targetNode.toString()));
            return null;
        }
        switch (targetNode.getNodeType()) {
            case BODY_SLOT: {
                parent = targetNode;
                parentEs = this.eqSet;
                equipSlot = null;
                locName = parent.toString();
                break;
            }
            case PHANTOM_SLOT: {
                parent = (EquipNodeImpl)targetNode.getParent();
                parentEs = this.eqSet;
                equipSlot = targetNode.getSlot();
                locName = equipSlot.toString();
                break;
            }
            case EQUIPMENT: {
                parent = targetNode;
                parentEs = this.charDisplay.getEquipSetByIdPath(parent.getIdPath());
                equipSlot = targetNode.getSlot();
                locName = parent.toString();
                break;
            }
            default: {
                return null;
            }
        }
        if (!item.isContainer()) {
            for (EquipmentSetFacade.EquipNode existing : this.nodeList) {
                Equipment existingItem;
                if (!parent.equals(existing.getParent()) || existing.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT) continue;
                EquipNodeImpl existingImpl = (EquipNodeImpl)existing;
                if (equipSlot != null && !equipSlot.equals(existingImpl.getSlot()) || !(existingItem = (Equipment)existing.getEquipment()).equals(item)) continue;
                int totalQuantity = (int)(existingItem.getQty().floatValue() + (float)quantity);
                existingItem.setQty(totalQuantity);
                EquipSet es = this.charDisplay.getEquipSetByIdPath(((EquipNodeImpl)existing).getIdPath());
                es.setQty(Float.valueOf(es.getQty().floatValue() + (float)quantity));
                this.updateTotalWeight(existingItem, quantity, parent.getBodyStructure());
                this.fireQuantityChanged(existing);
                this.updateTotalQuantity(existingItem, quantity);
                this.updateNaturalWeaponSlots();
                this.updatePhantomSlots();
                return existingItem;
            }
        }
        String id = beforeNode != null && beforeNode instanceof EquipNodeImpl ? this.shiftEquipSetsDown(parentEs, (EquipNodeImpl)beforeNode, this.buildPathNodeMap(), this.buildPathEquipSetMap()) : EquipmentSetFacadeImpl.getNewIdPath(this.charDisplay, parentEs);
        Equipment newItem = item.clone();
        EquipSet newSet = new EquipSet(id, locName, newItem.getName(), newItem);
        newItem.setQty(quantity);
        newSet.setQty(Float.valueOf(quantity));
        this.theCharacter.addEquipSet(newSet);
        Equipment eqTarget = parentEs.getItem();
        if (eqTarget != null && eqTarget.isContainer()) {
            eqTarget.insertChild(this.theCharacter, newItem);
            newItem.setParent(eqTarget);
        }
        EquipNodeImpl itemNode = new EquipNodeImpl(parent, equipSlot, newItem, id);
        this.nodeList.addElement(itemNode);
        if (targetNode.getNodeType() == EquipmentSetFacade.EquipNode.NodeType.PHANTOM_SLOT && this.getNumFreeSlots(targetNode) <= 0) {
            this.nodeList.removeElement(targetNode);
            for (EquipmentSetFacade.EquipNode inompatNode : this.getIncompatibleWeaponSlots(targetNode)) {
                this.nodeList.removeElement(inompatNode);
            }
        }
        this.updateTotalWeight(newItem, quantity, parent.getBodyStructure());
        this.updateTotalQuantity(newItem, quantity);
        this.updateNaturalWeaponSlots();
        this.updateOutputOrder();
        this.theCharacter.calcActiveBonuses();
        this.updatePhantomSlots();
        this.characterFacadeImpl.postEquippingUpdates();
        return newItem;
    }

    @Override
    public boolean moveEquipment(EquipmentSetFacade.EquipNode node, int numRowsToMove) {
        EquipNodeImpl beforeNode;
        if (!(node instanceof EquipNodeImpl) || !(node.getBodyStructure() instanceof BodyStructure) || node.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT || node.getParent() == null) {
            return false;
        }
        if (numRowsToMove == 0) {
            return true;
        }
        BodyStructure bodyStruct = (BodyStructure)node.getBodyStructure();
        if (!bodyStruct.isHoldsAnyType()) {
            return false;
        }
        EquipNodeImpl equipNode = (EquipNodeImpl)node;
        ArrayList<EquipmentSetFacade.EquipNode> orderedEquipNodes = new ArrayList<EquipmentSetFacade.EquipNode>(this.nodeList.getContents());
        Collections.sort(orderedEquipNodes);
        int currLoc = orderedEquipNodes.indexOf(node);
        if (currLoc < 0) {
            return false;
        }
        boolean addAsLastChildOfParent = false;
        if (numRowsToMove < 0) {
            beforeNode = this.scanBackForNewLoc(equipNode, orderedEquipNodes, numRowsToMove * -1, currLoc);
        } else {
            beforeNode = this.scanForwardForNewLoc(equipNode, orderedEquipNodes, numRowsToMove, currLoc);
            addAsLastChildOfParent = beforeNode == null;
        }
        Map<String, EquipNodeImpl> origPathToNode = this.buildPathNodeMap();
        Map<String, EquipSet> origPathToEquipSet = this.buildPathEquipSetMap();
        this.nodeList.removeElement(equipNode);
        String origIdPath = equipNode.getIdPath();
        EquipSet parentEs = this.charDisplay.getEquipSetByIdPath(EquipSet.getParentPath(origIdPath));
        EquipSet nodeEs = this.charDisplay.getEquipSetByIdPath(origIdPath);
        String newIdPath = addAsLastChildOfParent ? EquipmentSetFacadeImpl.getNewIdPath(this.charDisplay, parentEs) : this.shiftEquipSetsDown(parentEs, beforeNode, origPathToNode, origPathToEquipSet);
        nodeEs.setIdPath(newIdPath);
        equipNode.setIdPath(newIdPath);
        this.nodeList.addElement(equipNode);
        this.updateContainerPath(origIdPath, newIdPath, origPathToNode, origPathToEquipSet);
        return true;
    }

    @Override
    public boolean sortEquipment(EquipmentSetFacade.EquipNode parentNode) {
        if (!(parentNode instanceof EquipNodeImpl) || !(parentNode.getBodyStructure() instanceof BodyStructure) || parentNode.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT && parentNode.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.BODY_SLOT) {
            return false;
        }
        BodyStructure bodyStruct = (BodyStructure)parentNode.getBodyStructure();
        if (!bodyStruct.isHoldsAnyType()) {
            return false;
        }
        String pid = ((EquipNodeImpl)parentNode).idPath;
        boolean isBodyStructure = parentNode.getBodyStructure() instanceof BodyStructure;
        ArrayList<EquipNodeImpl> childList = new ArrayList<EquipNodeImpl>();
        Map<String, EquipNodeImpl> origPathToNode = this.buildPathNodeMap();
        Map<String, EquipSet> origPathToEquipSet = this.buildPathEquipSetMap();
        for (Map.Entry<String, EquipNodeImpl> entry : origPathToNode.entrySet()) {
            String origPath = entry.getKey();
            EquipNodeImpl node = entry.getValue();
            EquipSet es = origPathToEquipSet.get(origPath);
            if (node.parent != parentNode) continue;
            childList.add(node);
            if (pid != null) continue;
            pid = es.getParentIdPath();
        }
        Collections.sort(childList, new EquipNameComparator());
        int id = isBodyStructure ? this.theCharacter.getNewChildId(pid) : 1;
        DecimalFormat format = new DecimalFormat("00");
        for (EquipNodeImpl childNode : childList) {
            String origPath = childNode.idPath;
            String newPath = pid + '.' + format.format(id);
            this.nodeList.removeElement(childNode);
            EquipSet es = origPathToEquipSet.get(origPath);
            es.setIdPath(newPath);
            this.updateContainerPath(origPath, newPath, origPathToNode, origPathToEquipSet);
            childNode.setIdPath(newPath);
            this.nodeList.addElement(childNode);
            ++id;
        }
        return true;
    }

    private EquipNodeImpl scanBackForNewLoc(EquipNodeImpl equipNode, List<EquipmentSetFacade.EquipNode> orderedEquipNodes, int numRowsToMove, int startRow) {
        int currIndex = startRow;
        int numRowsMoved = 0;
        String lastIdPath = equipNode.getIdPath();
        EquipNodeImpl lastRowNode = equipNode;
        while (currIndex > 0 && numRowsMoved < numRowsToMove) {
            EquipNodeImpl currRowNode;
            int currRowDepth;
            int lastDepth = EquipSet.getPathDepth(lastIdPath);
            if (lastDepth < (currRowDepth = (currRowNode = (EquipNodeImpl)orderedEquipNodes.get(--currIndex)).getIdPath() == null ? 0 : EquipSet.getPathDepth(currRowNode.getIdPath()))) continue;
            if (equipNode.getBodyStructure() != currRowNode.getBodyStructure() || equipNode.getParent() != currRowNode.getParent()) {
                return lastRowNode;
            }
            ++numRowsMoved;
            lastIdPath = currRowNode.getIdPath();
            lastRowNode = currRowNode;
        }
        return lastRowNode;
    }

    private EquipNodeImpl scanForwardForNewLoc(EquipNodeImpl equipNode, List<EquipmentSetFacade.EquipNode> orderedEquipNodes, int numRowsToMove, int startRow) {
        int currIndex = startRow;
        int numRowsMoved = 0;
        String lastIdPath = equipNode.getIdPath();
        EquipNodeImpl lastRowNode = equipNode;
        while (currIndex < orderedEquipNodes.size() && numRowsMoved <= numRowsToMove) {
            if (++currIndex == orderedEquipNodes.size()) {
                return null;
            }
            int lastDepth = EquipSet.getPathDepth(lastIdPath);
            EquipNodeImpl currRowNode = (EquipNodeImpl)orderedEquipNodes.get(currIndex);
            if (currRowNode.getIdPath() == null) {
                return null;
            }
            int currRowDepth = EquipSet.getPathDepth(currRowNode.getIdPath());
            if (lastDepth < currRowDepth) continue;
            if (equipNode.getBodyStructure() != currRowNode.getBodyStructure() || equipNode.getParent() != currRowNode.getParent()) {
                return null;
            }
            ++numRowsMoved;
            lastIdPath = currRowNode.getIdPath();
            lastRowNode = currRowNode;
        }
        return lastRowNode;
    }

    private void updateOutputOrder() {
        ArrayList<EquipmentSetFacade.EquipNode> orderedEquipNodes = new ArrayList<EquipmentSetFacade.EquipNode>(this.nodeList.getContents());
        Collections.sort(orderedEquipNodes);
        ArrayList<Equipment> processed = new ArrayList<Equipment>(orderedEquipNodes.size());
        int outputIndex = 1;
        for (EquipmentSetFacade.EquipNode equipNode : orderedEquipNodes) {
            Equipment equip;
            if (equipNode.getEquipment() == null || (equip = this.theCharacter.getEquipmentNamed(equipNode.getEquipment().toString())) == null || processed.contains(equip)) continue;
            equip.setOutputIndex(outputIndex++);
            processed.add(equip);
        }
    }

    @Override
    public EquipmentFacade removeEquipment(EquipmentSetFacade.EquipNode node, int quantity) {
        if (!(node instanceof EquipNodeImpl) || node.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT) {
            return null;
        }
        EquipNodeImpl targetNode = (EquipNodeImpl)node;
        EquipNodeImpl parentNode = (EquipNodeImpl)node.getParent();
        EquipSet eSet = this.charDisplay.getEquipSetByIdPath(targetNode.getIdPath());
        if (eSet == null) {
            Logging.errorPrint("No equipset found for node " + targetNode + " path " + targetNode.getIdPath());
            return null;
        }
        int newQty = (int)(eSet.getQty().floatValue() - (float)quantity);
        Equipment eqI = eSet.getItem();
        if (newQty <= 0) {
            EquipNodeImpl restoredNode;
            this.removeChildren(node);
            this.theCharacter.delEquipSet(eSet);
            this.nodeList.removeElement(targetNode);
            if (parentNode.getNodeType() == EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT) {
                Equipment eqP = eqI.getParent();
                if (eqP != null) {
                    eqP.removeChild(this.theCharacter, eqI);
                }
            } else if (targetNode.getSlot() != null && (restoredNode = (EquipNodeImpl)this.equipSlotNodeMap.get(targetNode.getSlot())) != null && !this.nodeList.containsElement(restoredNode)) {
                this.nodeList.addElement(0, restoredNode);
                this.addCompatWeaponSlots(restoredNode);
            }
        } else {
            eSet.setQty(Float.valueOf(newQty));
            this.fireQuantityChanged(targetNode);
        }
        this.updateTotalWeight(eqI, quantity * -1, targetNode.getBodyStructure());
        this.updateTotalQuantity(eqI, quantity * -1);
        this.updateNaturalWeaponSlots();
        this.theCharacter.calcActiveBonuses();
        this.updatePhantomSlots();
        return eqI;
    }

    private void removeChildren(EquipmentSetFacade.EquipNode parentNode) {
        if (!(parentNode instanceof EquipNodeImpl) || parentNode.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT) {
            return;
        }
        ArrayList<EquipmentSetFacade.EquipNode> equipToBeRemoved = new ArrayList<EquipmentSetFacade.EquipNode>(this.nodeList.getSize());
        for (EquipmentSetFacade.EquipNode node : this.nodeList) {
            if (node.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT || node.getParent() != parentNode) continue;
            equipToBeRemoved.add(node);
        }
        for (EquipmentSetFacade.EquipNode node : equipToBeRemoved) {
            this.removeEquipment(node, this.getQuantity(node));
        }
    }

    private List<EquipmentSetFacade.EquipNode> getIncompatibleWeaponSlots(EquipNodeImpl targetNode) {
        ArrayList<EquipmentSetFacade.EquipNode> wpnList = new ArrayList<EquipmentSetFacade.EquipNode>();
        if (targetNode.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.PHANTOM_SLOT) {
            return wpnList;
        }
        String[] incompatLocNames = new String[]{};
        String slotName = targetNode.getSlot().toString();
        if ("Primary Hand".equals(slotName)) {
            incompatLocNames = new String[]{"Both Hands", "Double Weapon"};
        } else if ("Secondary Hand".equals(slotName)) {
            incompatLocNames = new String[]{"Both Hands", "Double Weapon", "Shield"};
        } else if ("Shield".equals(slotName)) {
            incompatLocNames = new String[]{"Both Hands", "Double Weapon", "Secondary Hand"};
        } else if ("Both Hands".equals(slotName)) {
            incompatLocNames = new String[]{"Primary Hand", "Double Weapon", "Secondary Hand", "Shield"};
        } else if ("Double Weapon".equals(slotName)) {
            incompatLocNames = new String[]{"Primary Hand", "Both Hands", "Secondary Hand", "Shield"};
        }
        List<String> namesList = Arrays.asList(incompatLocNames);
        for (EquipSlot slot : this.equipSlotNodeMap.keySet()) {
            if (!namesList.contains(slot.toString())) continue;
            wpnList.add(this.equipSlotNodeMap.get(slot));
        }
        return wpnList;
    }

    private void addCompatWeaponSlots(EquipNodeImpl restoredNode) {
        List<EquipmentSetFacade.EquipNode> weaponSlots = this.getIncompatibleWeaponSlots(restoredNode);
        HashSet<EquipmentSetFacade.EquipNode> incompatNodes = new HashSet<EquipmentSetFacade.EquipNode>();
        for (EquipmentSetFacade.EquipNode equipNode : this.nodeList) {
            EquipSlot slot;
            if (equipNode.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT || !this.affectsWeaponSlots(equipNode) || (slot = ((EquipNodeImpl)equipNode).getSlot()) == null || this.equipSlotNodeMap.get(slot) == null) continue;
            incompatNodes.addAll(this.getIncompatibleWeaponSlots((EquipNodeImpl)this.equipSlotNodeMap.get(slot)));
        }
        weaponSlots.removeAll(incompatNodes);
        for (EquipmentSetFacade.EquipNode node : weaponSlots) {
            this.nodeList.addElement(0, node);
        }
    }

    private boolean affectsWeaponSlots(EquipmentSetFacade.EquipNode equipNode) {
        List<String> typeList = Arrays.asList(equipNode.getEquipment().getTypes());
        return typeList.contains("WEAPON") || typeList.contains("SHIELD");
    }

    private void updateTotalQuantity(Equipment item, int amtChanged) {
        for (EquipmentFacade equip : this.equippedItemsList) {
            if (!item.equals(equip)) continue;
            int newQty = this.equippedItemsList.getQuantity(equip) + amtChanged;
            if (newQty > 0) {
                this.equippedItemsList.setQuantity(equip, newQty);
            } else {
                this.equippedItemsList.removeElement(equip);
            }
            return;
        }
        this.equippedItemsList.addElement(item, amtChanged);
    }

    private void updateNaturalWeaponSlots() {
        if (this.pcHasUnequippedNaturalWeapons()) {
            for (EquipNodeImpl natWpnEquipNode : this.naturalWeaponNodes.values()) {
                if (this.nodeList.containsElement(natWpnEquipNode)) continue;
                this.nodeList.addElement(natWpnEquipNode);
            }
        } else {
            for (EquipNodeImpl natWpnEquipNode : this.naturalWeaponNodes.values()) {
                if (!this.nodeList.containsElement(natWpnEquipNode)) continue;
                this.nodeList.removeElement(natWpnEquipNode);
            }
        }
    }

    private void updatePhantomSlots() {
        HashSet<EquipmentSetFacade.EquipNode> nodesToBeRemoved = new HashSet<EquipmentSetFacade.EquipNode>();
        HashSet<EquipNodeImpl> presentPNs = new HashSet<EquipNodeImpl>();
        HashSet<EquipNodeImpl> neededPNs = new HashSet<EquipNodeImpl>();
        block4: for (EquipmentSetFacade.EquipNode equipNode : this.nodeList) {
            EquipNodeImpl nodeImpl = (EquipNodeImpl)equipNode;
            switch (equipNode.getNodeType()) {
                case PHANTOM_SLOT: {
                    if (this.getNumFreeSlots(equipNode) <= 0) {
                        nodesToBeRemoved.add(equipNode);
                        break;
                    }
                    presentPNs.add(nodeImpl);
                    break;
                }
                case EQUIPMENT: {
                    if (nodeImpl.getSlot() == null) break;
                    EquipNodeImpl parentNode = (EquipNodeImpl)this.equipSlotNodeMap.get(nodeImpl.getSlot());
                    if (parentNode == null || parentNode.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.PHANTOM_SLOT) continue block4;
                    int numFreeSlots = this.getNumFreeSlots(parentNode);
                    if (numFreeSlots < 0) {
                        this.todoManager.addTodo(new TodoFacadeImpl(Tab.INVENTORY, parentNode.toString(), "in_equipNodeOverfull", Tab.EQUIPPING.name(), 9));
                        break;
                    }
                    this.todoManager.removeTodo("in_equipNodeOverfull", parentNode.toString());
                    if (numFreeSlots <= 0) continue block4;
                    neededPNs.add(parentNode);
                    break;
                }
            }
        }
        for (EquipmentSetFacade.EquipNode equipNode : this.hiddenPhantomNodes) {
            if (this.getNumFreeSlots(equipNode) <= 0) continue;
            neededPNs.add((EquipNodeImpl)equipNode);
        }
        for (EquipmentSetFacade.EquipNode equipNode : nodesToBeRemoved) {
            this.nodeList.removeElement(equipNode);
            if (this.getQuantity(equipNode) > 0) continue;
            this.hiddenPhantomNodes.add((EquipNodeImpl)equipNode);
        }
        neededPNs.removeAll(presentPNs);
        for (EquipNodeImpl equipNodeImpl : neededPNs) {
            this.nodeList.addElement(0, equipNodeImpl);
            this.addCompatWeaponSlots(equipNodeImpl);
            this.hiddenPhantomNodes.remove(equipNodeImpl);
        }
    }

    public String getName() {
        return this.name.getReference();
    }

    @Override
    public boolean isContainer(EquipmentFacade equipment) {
        if (!(equipment instanceof Equipment)) {
            return false;
        }
        Equipment item = (Equipment)equipment;
        return item.isContainer();
    }

    @Override
    public void setName(String name) {
        this.name.setReference(name);
        this.eqSet.setName(name);
    }

    @Override
    public void addEquipmentTreeListener(EquipmentSetFacade.EquipmentTreeListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeEquipmentTreeListener(EquipmentSetFacade.EquipmentTreeListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public ReferenceFacade<String> getNameRef() {
        return this.name;
    }

    @Override
    public EquipmentListFacade getEquippedItems() {
        return this.equippedItemsList;
    }

    @Override
    public boolean canEquip(EquipmentSetFacade.EquipNode node, EquipmentFacade equipment) {
        BodyStructure root;
        EquipmentFacade parent;
        if (!(equipment instanceof Equipment) || node == null) {
            return false;
        }
        Equipment item = (Equipment)equipment;
        EquipmentSetFacade.EquipNode requiredLoc = this.getNaturalWeaponLoc(equipment);
        if (requiredLoc != null) {
            return this.validLocationForNaturalWeapon(node, item, requiredLoc);
        }
        if (node.getNodeType() == EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT && (parent = node.getEquipment()) instanceof Equipment && ((Equipment)parent).isContainer() && ((Equipment)parent).canContain(this.theCharacter, item) == 1) {
            return true;
        }
        if (node.getNodeType() == EquipmentSetFacade.EquipNode.NodeType.PHANTOM_SLOT) {
            if (!this.getNodes().containsElement(node)) {
                return false;
            }
            EquipSlot slot = ((EquipNodeImpl)node).getSlot();
            if (slot.canContainType(item.getType())) {
                if (item.isWeapon()) {
                    String slotName = slot.getSlotName();
                    if (item.isUnarmed() && slotName.equals("Unarmed")) {
                        return true;
                    }
                    if (item.isShield() && slotName.equals("Shield")) {
                        return true;
                    }
                    if (item.isWeaponOutsizedForPC(this.theCharacter)) {
                        return false;
                    }
                    if (slotName.startsWith("Both Hands")) {
                        return true;
                    }
                    if (item.isMelee() && item.isDouble() && slotName.equals("Double Weapon")) {
                        return true;
                    }
                    if (item.isWeaponOneHanded(this.theCharacter) && (slotName.equals("Primary Hand") || slotName.startsWith("Secondary Hand"))) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
        }
        if (node.getNodeType() == EquipmentSetFacade.EquipNode.NodeType.BODY_SLOT && (root = (BodyStructure)node.getBodyStructure()).isHoldsAnyType()) {
            return !root.isForbidden(item.getTrueTypeList(false));
        }
        return false;
    }

    private boolean validLocationForNaturalWeapon(EquipmentSetFacade.EquipNode node, Equipment equipment, EquipmentSetFacade.EquipNode naturalLoc) {
        if (equipment.isPrimaryNaturalWeapon()) {
            return this.naturalWeaponNodes.containsValue(node);
        }
        return node.equals(naturalLoc);
    }

    @Override
    public String getPreferredLoc(EquipmentFacade equipment) {
        EquipmentSetFacade.EquipNode reqNode = this.getNaturalWeaponLoc(equipment);
        if (reqNode != null) {
            return reqNode.toString();
        }
        for (EquipmentSetFacade.EquipNode node : this.equipSlotNodeMap.values()) {
            if (node.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.PHANTOM_SLOT || !this.canEquip(node, equipment)) continue;
            return node.toString();
        }
        return LanguageBundle.getString("in_other");
    }

    protected EquipmentSetFacade.EquipNode getNaturalWeaponLoc(EquipmentFacade equipment) {
        if (!(equipment instanceof Equipment) || equipment == null) {
            return null;
        }
        Equipment item = (Equipment)equipment;
        String locName = this.theCharacter.getNaturalWeaponLocation(item);
        if (locName != null) {
            return this.naturalWeaponNodes.get(locName);
        }
        return null;
    }

    protected void createNaturalWeaponSlots() {
        for (EquipSlot slot : SystemCollections.getUnmodifiableEquipSlotList()) {
            if (!slot.canContainType("WEAPON")) continue;
            for (EquipmentSetFacade.EquipNode node : this.nodeList) {
                if (node.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.BODY_SLOT || !slot.getBodyStructureName().equalsIgnoreCase(node.getBodyStructure().toString())) continue;
                this.createNaturalWeaponSlot(slot, node, "Natural-Primary");
                this.createNaturalWeaponSlot(slot, node, "Natural-Secondary");
                return;
            }
        }
    }

    private void createNaturalWeaponSlot(EquipSlot slot, EquipmentSetFacade.EquipNode node, String locName) {
        EquipSlot natWpnEquipSlot = this.createWeaponEquipSlot(slot, locName);
        EquipNodeImpl slotNode = new EquipNodeImpl((EquipNodeImpl)node, natWpnEquipSlot, true);
        this.naturalWeaponNodes.put(locName, slotNode);
    }

    private int getNumFreeSlots(EquipmentSetFacade.EquipNode slot) {
        if (slot.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.PHANTOM_SLOT) {
            return 0;
        }
        EquipNodeImpl node = (EquipNodeImpl)slot;
        int numPossible = this.getQuantity(node);
        int numUsed = 0;
        for (EquipmentSetFacade.EquipNode item : this.nodeList) {
            if (item.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT || ((EquipNodeImpl)item).getSlot() != node.getSlot()) continue;
            Equipment equip = (Equipment)item.getEquipment();
            numUsed += equip.getSlots(this.theCharacter);
        }
        return numPossible - numUsed;
    }

    @Override
    public void removeAllEquipment() {
        ArrayList<EquipmentSetFacade.EquipNode> equipToBeRemoved = new ArrayList<EquipmentSetFacade.EquipNode>(this.nodeList.getSize());
        for (EquipmentSetFacade.EquipNode node : this.nodeList) {
            if (node.getNodeType() != EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT || node.getParent().getNodeType() == EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT) continue;
            equipToBeRemoved.add(node);
        }
        for (EquipmentSetFacade.EquipNode node : equipToBeRemoved) {
            this.removeEquipment(node, this.getQuantity(node));
        }
    }

    public String toString() {
        return this.getName();
    }

    private void fireQuantityChanged(EquipmentSetFacade.EquipNode node) {
        EquipmentSetFacade.EquipmentTreeEvent event = null;
        for (EquipmentSetFacade.EquipmentTreeListener equipmentTreeListener : this.listeners) {
            if (event == null) {
                event = new EquipmentSetFacade.EquipmentTreeEvent(this, node);
            }
            equipmentTreeListener.quantityChanged(event);
        }
    }

    double getTotalWeight() {
        return this.totalWeight;
    }

    EquipSet getEquipSet() {
        return this.eqSet;
    }

    @Override
    public ListFacade<EquipmentSetFacade.EquipNode> getNodes() {
        return this.nodeList;
    }

    @Override
    public int getQuantity(EquipmentSetFacade.EquipNode equipNode) {
        EquipNodeImpl node = (EquipNodeImpl)equipNode;
        switch (node.getNodeType()) {
            case BODY_SLOT: {
                return 1;
            }
            case PHANTOM_SLOT: {
                String slotName = node.getSlot().toString();
                if ("Both Hands".equals(slotName)) {
                    return 1;
                }
                if ("Double Weapon".equals(slotName)) {
                    return 1;
                }
                return node.singleOnly ? 1 : node.getSlot().getSlotCount() + (int)this.theCharacter.getTotalBonusTo("SLOTS", node.getSlot().getSlotName());
            }
        }
        EquipSet parentEs = this.charDisplay.getEquipSetByIdPath(node.getIdPath());
        return parentEs == null ? 0 : parentEs.getQty().intValue();
    }

    @Override
    public String getLocation(EquipmentSetFacade.EquipNode equipNode) {
        EquipNodeImpl node = (EquipNodeImpl)equipNode;
        switch (node.getNodeType()) {
            case BODY_SLOT: {
                return node.toString();
            }
        }
        if (node.getSlot() != null) {
            return node.getSlot().toString();
        }
        return node.getBodyStructure().toString();
    }

    @Override
    public String getLocation(EquipmentFacade equip) {
        for (EquipmentSetFacade.EquipNode node : this.nodeList) {
            if (!equip.equals(node.getEquipment())) continue;
            switch (node.getNodeType()) {
                case PHANTOM_SLOT: 
                case EQUIPMENT: {
                    return this.getLocation(node);
                }
            }
            return node.getParent().toString();
        }
        return this.getPreferredLoc(equip);
    }

    private boolean pcHasUnequippedNaturalWeapons() {
        for (Equipment equipItem : this.theCharacter.getEquipmentMasterList()) {
            if (!equipItem.isNatural() || this.equippedItemsList.containsElement(equipItem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void elementAdded(ListEvent<EquipmentFacade> e) {
    }

    @Override
    public void elementRemoved(ListEvent<EquipmentFacade> e) {
        EquipmentFacade equipmentFacade = e.getElement();
        if (this.equippedItemsList.containsElement(equipmentFacade) && Logging.isDebugMode()) {
            Logging.debugPrint("Currently equipped item " + equipmentFacade + " is being removed.");
        }
        List<EquipNodeImpl> affectedList = this.findEquipmentNodes(equipmentFacade);
        for (EquipNodeImpl equipNode : affectedList) {
            EquipSet eSet = this.charDisplay.getEquipSetByIdPath(equipNode.getIdPath());
            if (eSet == null) continue;
            this.removeEquipment(equipNode, eSet.getQty().intValue());
        }
    }

    private List<EquipNodeImpl> findEquipmentNodes(EquipmentFacade equipmentFacade) {
        ArrayList<EquipNodeImpl> affectedList = new ArrayList<EquipNodeImpl>();
        for (EquipmentSetFacade.EquipNode node : this.nodeList) {
            if (!equipmentFacade.equals(node.getEquipment())) continue;
            affectedList.add((EquipNodeImpl)node);
        }
        return affectedList;
    }

    @Override
    public void elementsChanged(ListEvent<EquipmentFacade> e) {
        if (Logging.isDebugMode()) {
            Logging.debugPrint("Equip elementsChanged " + e);
        }
    }

    @Override
    public void elementModified(ListEvent<EquipmentFacade> e) {
    }

    @Override
    public void quantityChanged(EquipmentListFacade.EquipmentListEvent e) {
        int quantity;
        EquipmentFacade equipmentFacade = e.getEquipment();
        if (this.equippedItemsList.containsElement(equipmentFacade) && (quantity = this.purchasedList.getQuantity(equipmentFacade) - this.equippedItemsList.getQuantity(equipmentFacade)) < 0) {
            if (Logging.isDebugMode()) {
                Logging.debugPrint("Currently equipped item " + equipmentFacade + " is being partially removed " + quantity + " from " + this.equippedItemsList.getQuantity(equipmentFacade));
            }
            int numStillToRemove = -1 * quantity;
            List<EquipNodeImpl> affectedList = this.findEquipmentNodes(equipmentFacade);
            Collections.sort(affectedList, new EquipLocImportantComparator());
            for (EquipNodeImpl equipNode : affectedList) {
                EquipSet eSet = this.charDisplay.getEquipSetByIdPath(equipNode.getIdPath());
                if (eSet != null) {
                    int numToRemove = Math.min(eSet.getQty().intValue(), numStillToRemove);
                    this.removeEquipment(equipNode, numToRemove);
                    numStillToRemove -= numToRemove;
                }
                if (numStillToRemove > 0) continue;
                return;
            }
        }
    }

    public static class EquipNameComparator
    implements Comparator<EquipNodeImpl> {
        @Override
        public int compare(EquipNodeImpl node1, EquipNodeImpl node2) {
            return node1.getSortKey().compareTo(node2.getSortKey());
        }
    }

    public static class EquipLocImportantComparator
    implements Comparator<EquipNodeImpl> {
        @Override
        public int compare(EquipNodeImpl node1, EquipNodeImpl node2) {
            BodyStructureFacade bodyStruct2;
            BodyStructureFacade bodyStruct1 = node1.getBodyStructure();
            if (bodyStruct1 != (bodyStruct2 = node2.getBodyStructure())) {
                String[] locOrder;
                for (String locName : locOrder = new String[]{"Not Carried", "Carried", "Equipped"}) {
                    if (locName.equals(bodyStruct1.toString())) {
                        return -1;
                    }
                    if (!locName.equals(bodyStruct2.toString())) continue;
                    return 1;
                }
                return bodyStruct1.toString().compareTo(bodyStruct2.toString());
            }
            return node1.compareTo(node2);
        }
    }

    public static class EquipNodeImpl
    implements EquipmentSetFacade.EquipNode {
        private static final NumberFormat FMT = new DecimalFormat("00");
        private EquipmentSetFacade.EquipNode.NodeType nodeType;
        private BodyStructure bodyStructure;
        private Equipment equipment;
        private EquipNodeImpl parent;
        private String name;
        private EquipSlot slot;
        private String idPath;
        private String order;
        private boolean singleOnly = false;

        public EquipNodeImpl(BodyStructure bodyStructure, int order) {
            this.nodeType = EquipmentSetFacade.EquipNode.NodeType.BODY_SLOT;
            this.bodyStructure = bodyStructure;
            this.name = bodyStructure.toString();
            this.order = FMT.format(order);
        }

        public EquipNodeImpl(EquipNodeImpl parent, EquipSlot slot, boolean singleOnly) {
            this.nodeType = EquipmentSetFacade.EquipNode.NodeType.PHANTOM_SLOT;
            this.bodyStructure = parent.bodyStructure;
            this.slot = slot;
            this.name = slot.getSlotName();
            this.parent = parent;
            this.singleOnly = singleOnly;
        }

        public EquipNodeImpl(EquipNodeImpl parent, EquipSlot slot, Equipment equipment, String idPath) {
            this.nodeType = EquipmentSetFacade.EquipNode.NodeType.EQUIPMENT;
            this.bodyStructure = parent.bodyStructure;
            this.slot = slot;
            this.equipment = equipment;
            this.idPath = idPath;
            this.parent = parent;
            this.name = equipment.getDisplayName();
        }

        @Override
        public BodyStructureFacade getBodyStructure() {
            return this.bodyStructure;
        }

        @Override
        public EquipmentFacade getEquipment() {
            return this.equipment;
        }

        @Override
        public EquipmentSetFacade.EquipNode.NodeType getNodeType() {
            return this.nodeType;
        }

        @Override
        public EquipmentSetFacade.EquipNode getParent() {
            return this.parent;
        }

        EquipSlot getSlot() {
            return this.slot;
        }

        String getIdPath() {
            return this.idPath;
        }

        public void setIdPath(String idPath) {
            this.idPath = idPath;
        }

        String getSortKey() {
            StringBuilder sortKey = new StringBuilder(50);
            if (this.parent != null) {
                sortKey.append(this.parent.getSortKey());
            }
            switch (this.nodeType) {
                case BODY_SLOT: {
                    sortKey.append(this.order);
                    break;
                }
                case PHANTOM_SLOT: {
                    sortKey.append("|");
                    sortKey.append(this.slot.getSlotName());
                    break;
                }
                default: {
                    sortKey.append("|");
                    String objKey = this.equipment.get(StringKey.SORT_KEY);
                    if (objKey == null) {
                        objKey = this.equipment.getDisplayName();
                    }
                    sortKey.append(objKey);
                }
            }
            return sortKey.toString();
        }

        public String toString() {
            return this.name;
        }

        @Override
        public int compareTo(EquipmentSetFacade.EquipNode o) {
            if (o instanceof EquipNodeImpl) {
                String orderOther;
                EquipNodeImpl other = (EquipNodeImpl)o;
                String orderThis = this.getOrder(this);
                if (!orderThis.equals(orderOther = this.getOrder(other))) {
                    return orderThis.compareTo(orderOther);
                }
                if (this.getIdPath() != null && other.getIdPath() != null) {
                    return this.getIdPath().compareTo(other.getIdPath());
                }
                return this.getSortKey().compareTo(other.getSortKey());
            }
            return this.toString().compareTo(o.toString());
        }

        private String getOrder(EquipNodeImpl equipNodeImpl) {
            if (StringUtils.isNotBlank(equipNodeImpl.order)) {
                return equipNodeImpl.order;
            }
            EquipNodeImpl enParent = equipNodeImpl.parent;
            if (enParent != null) {
                return this.getOrder(enParent);
            }
            return "";
        }
    }
}

