/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.swing.JFrame;
import org.apache.commons.lang.SystemUtils;
import pcgen.base.util.RandomUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.MasterListInterface;
import pcgen.cdom.content.BaseDice;
import pcgen.cdom.content.CNAbilityFactory;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.ArmorProf;
import pcgen.core.BioSet;
import pcgen.core.Campaign;
import pcgen.core.Equipment;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PaperInfo;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.RollInfo;
import pcgen.core.RuleCheck;
import pcgen.core.SettingsHandler;
import pcgen.core.ShieldProf;
import pcgen.core.SizeAdjustment;
import pcgen.core.Skill;
import pcgen.core.SystemCollections;
import pcgen.core.UnitSet;
import pcgen.core.WeaponProf;
import pcgen.core.character.EquipSlot;
import pcgen.core.chooser.CDOMChooserFacadeImpl;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.facade.core.ChooserFacade;
import pcgen.gui2.facade.Gui2InfoFactory;
import pcgen.output.wrapper.CDOMObjectWrapper;
import pcgen.rules.context.AbstractReferenceContext;
import pcgen.rules.context.ConsolidatedListCommitStrategy;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.RuntimeLoadContext;
import pcgen.rules.context.RuntimeReferenceContext;
import pcgen.system.ConfigurationSettings;
import pcgen.system.PCGenSettings;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.enumeration.Load;
import pcgen.util.enumeration.VisionType;

public final class Globals {
    private static List<PlayerCharacter> pcList = new ArrayList<PlayerCharacter>();
    public static Race s_EMPTYRACE;
    public static final String javaVersion;
    public static final int javaVersionMajor;
    public static final int javaVersionMinor;
    private static final String defaultPcgPath;
    private static final List<String> custColumnWidth;
    private static SourceFormat sourceDisplay;
    private static int selectedPaper;
    private static Map<URI, Campaign> campaignMap;
    private static Map<String, Campaign> campaignNameMap;
    private static Map<String, Spell> spellMap;
    private static Map<String, String> eqSlotMap;
    private static List<Campaign> campaignList;
    private static JFrame rootFrame;
    private static final StringBuilder section15;
    private static boolean useGUI;
    public static final boolean isMacPlatform;
    public static final String defaultMacOptionsPath;
    private static final Comparator<CDOMObject> pObjectComp;
    public static final Comparator<CDOMObject> pObjectNameComp;
    public static final String[] EMPTY_STRING_ARRAY;
    private static LoadContext globalContext;
    private static boolean hasSpellPPCost;

    public static List<String> getAllowedGameModes() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getAllowedModes();
        }
        return new ArrayList<String>();
    }

    public static BioSet getBioSet() {
        return SettingsHandler.getGame().getBioSet();
    }

    public static Campaign getCampaignByURI(URI aName) {
        return Globals.getCampaignByURI(aName, true);
    }

    public static Campaign getCampaignByURI(URI aName, boolean complainOnError) {
        Campaign campaign = campaignMap.get(aName);
        if (campaign == null && complainOnError) {
            Logging.errorPrint("Could not find campaign by filename: " + aName);
        }
        return campaign;
    }

    public static List<Campaign> getCampaignList() {
        return campaignList;
    }

    public static Campaign getCampaignKeyed(String aKey) {
        Campaign campaign = Globals.getCampaignKeyedSilently(aKey);
        if (campaign == null) {
            Logging.errorPrint("Could not find campaign: " + aKey);
        }
        return campaign;
    }

    public static Campaign getCampaignKeyedSilently(String aKey) {
        for (Campaign campaign : Globals.getCampaignList()) {
            if (!campaign.getKeyName().equalsIgnoreCase(aKey)) continue;
            return campaign;
        }
        return null;
    }

    public static <T extends CDOMObject> List<T> getPObjectsOfType(Collection<T> aPObjectList, String aType) {
        ArrayList<CDOMObject> ret = new ArrayList<CDOMObject>(aPObjectList.size());
        ArrayList<String> typeList = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(aType, ".");
        while (tok.hasMoreTokens()) {
            typeList.add(tok.nextToken());
        }
        for (CDOMObject anObject : aPObjectList) {
            boolean match = false;
            for (String type : typeList) {
                boolean sense;
                boolean bl = sense = type.charAt(0) != '!';
                if (anObject.isType(type) == sense) {
                    match = true;
                    continue;
                }
                match = false;
                break;
            }
            if (!match) continue;
            ret.add(anObject);
        }
        ret.trimToSize();
        return ret;
    }

    public static void setCustColumnWidth(String fromTab, int col, int value) {
        boolean found = false;
        String cName = fromTab.concat(Integer.toString(col));
        String addMe = cName.concat("|").concat(Integer.toString(value));
        if (Globals.getCustColumnWidth().isEmpty()) {
            Globals.getCustColumnWidth().add(addMe);
        }
        int loopMax = Globals.getCustColumnWidth().size();
        for (int i = 0; i < loopMax; ++i) {
            StringTokenizer tTok;
            String tabName;
            String colWidth = Globals.getCustColumnWidth().get(i);
            if (colWidth == null || colWidth.length() == 0 || !cName.equals(tabName = (tTok = new StringTokenizer(colWidth, "|", false)).nextToken())) continue;
            Globals.getCustColumnWidth().set(i, addMe);
            found = true;
        }
        if (!found) {
            Globals.getCustColumnWidth().add(addMe);
        }
    }

    public static int getCustColumnWidth(String fromTab, int col) {
        int colSize = 0;
        String cName = fromTab.concat(Integer.toString(col));
        int loopMax = Globals.getCustColumnWidth().size();
        for (int i = 0; i < loopMax; ++i) {
            String tabName;
            StringTokenizer tTok = new StringTokenizer(Globals.getCustColumnWidth().get(i), "|", false);
            if (!tTok.hasMoreTokens() || !(tabName = tTok.nextToken()).equals(cName)) continue;
            colSize = Integer.parseInt(tTok.nextToken());
        }
        return colSize;
    }

    public static String getDefaultPath() {
        return ConfigurationSettings.getUserDir();
    }

    public static String getUserFilesPath() {
        return Globals.expandRelativePath(System.getProperty("user.home") + File.separator + ".pcgen");
    }

    public static String getDefaultSpellBook() {
        String book = null;
        if (SettingsHandler.getGame() != null) {
            book = SettingsHandler.getGame().getDefaultSpellBook();
        }
        return book;
    }

    public static EquipSlot getEquipSlotByName(String aName) {
        for (EquipSlot es : SystemCollections.getUnmodifiableEquipSlotList()) {
            if (!es.getSlotName().equals(aName)) continue;
            return es;
        }
        return null;
    }

    private static Map<String, String> getEquipSlotMap() {
        return eqSlotMap;
    }

    public static void setEquipSlotTypeCount(String aString, String aNum) {
        Globals.getEquipSlotMap().put(aString, aNum);
    }

    public static int getEquipSlotTypeCount(String aType) {
        String aNum = Globals.getEquipSlotMap().get(aType);
        if (aNum != null) {
            return Integer.parseInt(aNum);
        }
        return 0;
    }

    public static String getGameModeAlignmentText() {
        return SettingsHandler.getGame().getAlignmentText();
    }

    public static String getGameModePointPoolName() {
        return SettingsHandler.getGame().getPointPoolName();
    }

    public static boolean getGameModeHasPointPool() {
        return Globals.getGameModePointPoolName().length() != 0;
    }

    public static String getGameModeSpellRangeFormula(String aRange) {
        return SettingsHandler.getGame().getSpellRangeFormula(aRange);
    }

    public static UnitSet getGameModeUnitSet() {
        return SettingsHandler.getGame().getUnitSet();
    }

    public static List<String> getGlobalDeityList() {
        if (SettingsHandler.getGame() != null) {
            return SettingsHandler.getGame().getDeityList();
        }
        return new ArrayList<String>();
    }

    public static boolean isInGameMode(String gameMode) {
        return gameMode.length() == 0 || SettingsHandler.getGame() != null && gameMode.equalsIgnoreCase(SettingsHandler.getGame().getName());
    }

    public static void setPCList(List<PlayerCharacter> argPcList) {
        pcList = argPcList;
    }

    public static List<PlayerCharacter> getPCList() {
        return pcList;
    }

    public static int getPaperCount() {
        return SettingsHandler.getGame().getModeContext().getReferenceContext().getConstructedObjectCount(PaperInfo.class);
    }

    public static String getPaperInfo(int infoType) {
        return Globals.getPaperInfo(Globals.getSelectedPaper(), infoType);
    }

    public static String getPaperInfo(int idx, int infoType) {
        if (idx < 0 || idx >= SettingsHandler.getGame().getModeContext().getReferenceContext().getConstructedObjectCount(PaperInfo.class)) {
            return null;
        }
        PaperInfo pi = SettingsHandler.getGame().getModeContext().getReferenceContext().getItemInOrder(PaperInfo.class, idx);
        return pi.getPaperInfo(infoType);
    }

    public static void setRootFrame(JFrame frame) {
        rootFrame = frame;
    }

    public static JFrame getRootFrame() {
        return rootFrame;
    }

    public static StringBuilder getSection15() {
        return section15;
    }

    public static int getSelectedPaper() {
        return selectedPaper;
    }

    public static void setSourceDisplay(SourceFormat sourceType) {
        sourceDisplay = sourceType;
    }

    public static SourceFormat getSourceDisplay() {
        return sourceDisplay;
    }

    public static Spell getSpellKeyed(String aKey) {
        return Globals.getSpellMap().get(aKey);
    }

    public static Map<String, Spell> getSpellMap() {
        return Collections.unmodifiableMap(spellMap);
    }

    public static void addToSpellMap(String key, Spell spell) {
        spellMap.put(key, spell);
    }

    public static Object removeFromSpellMap(String key) {
        return spellMap.remove(key);
    }

    public static void setUseGUI(boolean aBool) {
        useGUI = aBool;
    }

    public static boolean getUseGUI() {
        return Globals.isUseGUI();
    }

    public static void addCampaign(Campaign campaign) {
        campaignMap.put(campaign.getSourceURI(), campaign);
        campaignList.add(campaign);
        Campaign oldCampaign = campaignNameMap.put(campaign.getName(), campaign);
        if (oldCampaign != null) {
            if (oldCampaign.getSourceURI().toString().equalsIgnoreCase(campaign.getSourceURI().toString())) {
                Logging.errorPrint("The campaign (" + campaign.getName() + ") was referenced with the incorrect case: " + oldCampaign.getSourceURI() + " vs " + campaign.getSourceURI());
            } else {
                Logging.errorPrint("Loaded Campaigns with matching names (" + campaign.getName() + ") at different Locations: " + oldCampaign.getSourceURI() + " " + campaign.getSourceURI());
            }
        }
    }

    public static String adjustDamage(String aDamage, int baseSize, int finalSize) {
        RollInfo bi;
        AbstractReferenceContext ref = Globals.getContext().getReferenceContext();
        BaseDice bd = ref.silentlyGetConstructedCDOMObject(BaseDice.class, aDamage);
        int multiplier = 0;
        List<RollInfo> steps = null;
        if (bd == null) {
            RollInfo aRollInfo = new RollInfo(aDamage);
            String baseDice = "1d" + Integer.toString(aRollInfo.sides);
            bd = ref.silentlyGetConstructedCDOMObject(BaseDice.class, baseDice);
            if (bd != null) {
                multiplier = aRollInfo.times;
            }
        } else {
            multiplier = 1;
        }
        if (bd == null) {
            bi = new RollInfo(aDamage);
        } else {
            if (baseSize < finalSize) {
                steps = bd.getUpSteps();
            } else if (baseSize > finalSize) {
                steps = bd.getDownSteps();
            } else {
                return aDamage;
            }
            int difference = Math.abs(baseSize - finalSize);
            int index = steps.size() > difference ? difference - 1 : steps.size() - 1;
            bi = steps.get(index);
        }
        if (multiplier > 1) {
            bi = new RollInfo(bi.toString());
            bi.times *= multiplier;
        }
        return bi.toString();
    }

    public static boolean canResizeHaveEffect(PlayerCharacter aPC, Equipment aEq, List<String> typeList) {
        if (typeList == null) {
            typeList = aEq.typeList();
        }
        ArrayList<String> upperTypeList = new ArrayList<String>(typeList.size());
        for (String type : typeList) {
            upperTypeList.add(type.toUpperCase());
        }
        List<String> resizeTypeList = SettingsHandler.getGame().getResizableTypeList();
        for (String rType : resizeTypeList) {
            if (!upperTypeList.contains(rType.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    public static boolean checkRule(String aKey) {
        RuleCheck rule = SettingsHandler.getGame().getModeContext().getReferenceContext().silentlyGetConstructedCDOMObject(RuleCheck.class, aKey);
        if (rule == null) {
            return false;
        }
        if (SettingsHandler.hasRuleCheck(aKey)) {
            return SettingsHandler.getRuleCheck(aKey);
        }
        return rule.getDefault();
    }

    public static void clearCampaignsForRefresh() {
        Globals.emptyLists();
        campaignMap.clear();
        campaignList.clear();
        hasSpellPPCost = false;
    }

    public static boolean displayListsHappy() {
        Level logLevel;
        boolean listsHappy = Globals.checkListsHappy();
        Level level = logLevel = listsHappy ? Logging.DEBUG : Logging.WARNING;
        if (Logging.isLoggable(logLevel)) {
            Logging.log(logLevel, "Number of objects loaded. The following should all be greater than 0:");
            Logging.log(logLevel, "Races=" + Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Race.class).size());
            Logging.log(logLevel, "Classes=" + Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCClass.class).size());
            Logging.log(logLevel, "Skills=" + Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Skill.class).size());
            Logging.log(logLevel, "Feats=" + Globals.getContext().getReferenceContext().getManufacturer(Ability.class, AbilityCategory.FEAT).getConstructedObjectCount());
            Logging.log(logLevel, "Equipment=" + Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Equipment.class).size());
            Logging.log(logLevel, "ArmorProfs=" + Globals.getContext().getReferenceContext().getConstructedCDOMObjects(ArmorProf.class).size());
            Logging.log(logLevel, "ShieldProfs=" + Globals.getContext().getReferenceContext().getConstructedCDOMObjects(ShieldProf.class).size());
            Logging.log(logLevel, "WeaponProfs=" + Globals.getContext().getReferenceContext().getConstructedCDOMObjects(WeaponProf.class).size());
            Logging.log(logLevel, "Kits=" + Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Kit.class).size());
            Logging.log(logLevel, "Templates=" + Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCTemplate.class).size());
        }
        return listsHappy;
    }

    public static boolean checkListsHappy() {
        boolean listsHappy = Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Race.class).size() != 0 && Globals.getContext().getReferenceContext().getConstructedCDOMObjects(PCClass.class).size() != 0 && Globals.getContext().getReferenceContext().getConstructedCDOMObjects(Equipment.class).size() != 0 && Globals.getContext().getReferenceContext().getConstructedCDOMObjects(WeaponProf.class).size() != 0;
        return listsHappy;
    }

    public static void emptyLists() {
        spellMap = new TreeMap<String, Spell>(String.CASE_INSENSITIVE_ORDER);
        VisionType.clearConstants();
        Equipment.clearEquipmentTypes();
        SettingsHandler.getGame().clearLoadContext();
        RaceType.clearConstants();
        Globals.createEmptyRace();
        CNAbilityFactory.reset();
        CDOMObjectWrapper.getInstance().clear();
    }

    public static void executePostExportCommandStandard(String fileName) {
        String postExportCommand = SettingsHandler.getPostExportCommandStandard();
        Globals.executePostExportCommand(fileName, postExportCommand);
    }

    public static void executePostExportCommandPDF(String fileName) {
        String postExportCommand = SettingsHandler.getPostExportCommandPDF();
        Globals.executePostExportCommand(fileName, postExportCommand);
    }

    private static void executePostExportCommand(String fileName, String postExportCommand) {
        ArrayList<String> aList = new ArrayList<String>();
        StringTokenizer aTok = new StringTokenizer(postExportCommand, " ");
        while (aTok.hasMoreTokens()) {
            aList.add(aTok.nextToken());
        }
        String[] cmdArray = new String[aList.size()];
        for (int idx = 0; idx < aList.size(); ++idx) {
            String s = (String)aList.get(idx);
            if (s.indexOf("%") > -1) {
                String beforeString = s.substring(0, s.indexOf("%"));
                String afterString = s.substring(s.indexOf("%") + 1);
                cmdArray[idx] = beforeString + fileName + afterString;
                continue;
            }
            cmdArray[idx] = s;
        }
        if (cmdArray.length > 0) {
            try {
                Runtime.getRuntime().exec(cmdArray);
            }
            catch (IOException ex) {
                Logging.errorPrint("Could not execute " + postExportCommand + " after exporting " + fileName, ex);
            }
        }
    }

    public static int rollHP(int min, int max, String name, int level, int totalLevel) {
        int roll;
        switch (SettingsHandler.getHPRollMethod()) {
            case 4: {
                roll = -1;
                break;
            }
            case 2: {
                roll = max - min;
                if ((totalLevel & 1) == 0 && (roll & 1) != 0) {
                    ++roll;
                }
                roll = min + roll / 2;
                break;
            }
            case 1: {
                roll = max;
                break;
            }
            case 3: {
                roll = min - 1 + (int)((double)(SettingsHandler.getHPPercent() * (max - min + 1)) / 100.0);
                break;
            }
            case 5: {
                roll = (int)Math.ceil((double)(min + max) / 2.0);
                break;
            }
            default: {
                roll = Math.abs(RandomUtil.getRandomInt(max - min + 1)) + min;
            }
        }
        return roll;
    }

    public static boolean selectPaper(String paperName) {
        for (int i = 0; i < SettingsHandler.getGame().getModeContext().getReferenceContext().getConstructedObjectCount(PaperInfo.class); ++i) {
            PaperInfo pi = SettingsHandler.getGame().getModeContext().getReferenceContext().getItemInOrder(PaperInfo.class, i);
            if (!pi.getName().equals(paperName)) continue;
            Globals.setSelectedPaper(i);
            PCGenSettings.getInstance().setProperty("papersize", paperName);
            return true;
        }
        Globals.setSelectedPaper(-1);
        return false;
    }

    public static void initPreferences() {
        if (selectedPaper != -1) {
            return;
        }
        String papersize = PCGenSettings.getInstance().initProperty("papersize", "A4");
        Globals.selectPaper(papersize);
    }

    public static void sortChooserLists(List availableList, List selectedList) {
        boolean nonPObjectInList = availableList.size() > 0 ? !(availableList.get(0) instanceof CDOMObject) : (selectedList.size() > 0 ? !(selectedList.get(0) instanceof CDOMObject) : false);
        if (nonPObjectInList) {
            Collections.sort(availableList);
            if (selectedList.size() > 0 && selectedList.get(0) != null) {
                Collections.sort(selectedList);
            }
        } else {
            Globals.sortPObjectListByName(availableList);
            Globals.sortPObjectListByName(selectedList);
        }
    }

    public static List<? extends CDOMObject> sortPObjectList(List<? extends CDOMObject> aList) {
        Collections.sort(aList, pObjectComp);
        return aList;
    }

    public static <T extends CDOMObject> List<T> sortPObjectListByName(List<T> aList) {
        Collections.sort(aList, pObjectNameComp);
        return aList;
    }

    static String getBonusFeatString() {
        List<String> bonusFeatLevels = SettingsHandler.getGame().getBonusFeatLevels();
        if (bonusFeatLevels == null || bonusFeatLevels.isEmpty()) {
            return "9999|0";
        }
        return bonusFeatLevels.get(0);
    }

    static int getBonusStatsForLevel(int level, PlayerCharacter aPC) {
        int num = 0;
        for (String s : SettingsHandler.getGame().getBonusStatLevels()) {
            num = Globals.bonusParsing(s, level, num, aPC);
        }
        return num;
    }

    public static <T> List<T> getChoiceFromList(String title, List<T> choiceList, List<T> selectedList, int pool, PlayerCharacter pc) {
        return Globals.getChoiceFromList(title, choiceList, selectedList, pool, false, false, pc);
    }

    public static <T> List<T> getChoiceFromList(String title, List<T> choiceList, List<T> selectedList, int pool, boolean forceChoice, boolean preferRadioSelection, PlayerCharacter pc) {
        List<Object> startingSelectedList = new ArrayList();
        if (selectedList != null) {
            startingSelectedList = selectedList;
        }
        CDOMChooserFacadeImpl<T> chooserFacade = new CDOMChooserFacadeImpl<T>(title, choiceList, startingSelectedList, pool);
        chooserFacade.setAllowsDups(false);
        chooserFacade.setRequireCompleteSelection(forceChoice);
        chooserFacade.setInfoFactory(new Gui2InfoFactory(pc));
        chooserFacade.setDefaultView(ChooserFacade.ChooserTreeViewType.NAME);
        chooserFacade.setPreferRadioSelection(preferRadioSelection);
        ChooserFactory.getDelegate().showGeneralChooser(chooserFacade);
        return chooserFacade.getFinalSelected();
    }

    static List<String> getCustColumnWidth() {
        return custColumnWidth;
    }

    static String getDefaultPcgPath() {
        return Globals.expandRelativePath(defaultPcgPath);
    }

    static String getFilepathsPath() {
        String aPath = System.getProperty("pcgen.filepaths");
        if (aPath == null) {
            aPath = System.getProperty("user.dir") + File.separator + "filepaths.ini";
        } else {
            File testPath = new File(Globals.expandRelativePath(aPath));
            if (testPath.exists() && testPath.isDirectory()) {
                aPath = testPath.getAbsolutePath() + File.separator + "filepaths.ini";
                testPath = new File(aPath);
            }
            if (testPath.exists() && !testPath.canWrite()) {
                Logging.errorPrint("WARNING: The filepaths file you specified is not updatable. Filepath changes will not be saved. File is " + testPath.getAbsolutePath());
            }
        }
        return Globals.expandRelativePath(aPath);
    }

    static String getFilterPath() {
        String aPath = System.getProperty("pcgen.filter");
        if (aPath == null) {
            aPath = Globals.getFilePath("filter.ini");
        } else {
            File testPath = new File(Globals.expandRelativePath(aPath));
            if (testPath.exists() && testPath.isDirectory()) {
                aPath = testPath.getAbsolutePath() + File.separator + "filter.ini";
                testPath = new File(aPath);
            }
            if (testPath.exists() && !testPath.canWrite()) {
                Logging.errorPrint("WARNING: The filter file you specified is not updatable. Filter changes will not be saved. File is " + testPath.getAbsolutePath());
            }
        }
        return Globals.expandRelativePath(aPath);
    }

    static String getOptionsPath() {
        String aPath = System.getProperty("pcgen.options");
        if (aPath == null) {
            aPath = Globals.getFilePath("options.ini");
        } else {
            File testPath = new File(Globals.expandRelativePath(aPath));
            if (testPath.exists() && testPath.isDirectory()) {
                aPath = testPath.getAbsolutePath() + File.separator + "options.ini";
                testPath = new File(aPath);
            }
            if (testPath.exists() && !testPath.canWrite()) {
                Logging.errorPrint("WARNING: The options file you specified is not updatable. Settings changes will not be saved. File is " + testPath.getAbsolutePath());
            }
        }
        return Globals.expandRelativePath(aPath);
    }

    public static int getSkillMultiplierForLevel(int level) {
        List<String> sml = SettingsHandler.getGame().getSkillMultiplierLevels();
        if (level > sml.size() || level <= 0) {
            return 1;
        }
        return Integer.parseInt(sml.get(level - 1));
    }

    public static String adjustDamage(String aDamage, SizeAdjustment baseSize, SizeAdjustment newSize) {
        if (aDamage.length() == 0) {
            return aDamage;
        }
        int baseIndex = baseSize.get(IntegerKey.SIZEORDER);
        int newIndex = newSize.get(IntegerKey.SIZEORDER);
        return Globals.adjustDamage(aDamage, baseIndex, newIndex);
    }

    public static double calcEncumberedMove(Load load, double unencumberedMove) {
        double encumberedMove;
        switch (load) {
            case LIGHT: {
                encumberedMove = unencumberedMove;
                break;
            }
            case MEDIUM: 
            case HEAVY: {
                if (CoreUtility.doublesEqual(unencumberedMove, 5.0)) {
                    encumberedMove = 5.0;
                    break;
                }
                if (CoreUtility.doublesEqual(unencumberedMove, 10.0)) {
                    encumberedMove = 5.0;
                    break;
                }
                encumberedMove = Math.floor(unencumberedMove / 15.0) * 10.0 + (double)((int)unencumberedMove % 15);
                break;
            }
            case OVERLOAD: {
                encumberedMove = 0.0;
                break;
            }
            default: {
                Logging.errorPrint("The load " + (Object)((Object)load) + " is not possible.");
                encumberedMove = 0.0;
            }
        }
        return encumberedMove;
    }

    static void initCustColumnWidth(List<String> l) {
        Globals.getCustColumnWidth().clear();
        Globals.getCustColumnWidth().addAll(l);
    }

    private static String getFilePath(String aString) {
        String fType = SettingsHandler.getFilePaths();
        if (fType == null || fType.equals("pcgen")) {
            return System.getProperty("user.dir") + File.separator + aString;
        }
        if (fType.equals("user")) {
            return System.getProperty("user.home") + File.separator + ".pcgen" + File.separator + aString;
        }
        if (fType.equals("mac_user")) {
            return System.getProperty("user.home") + "/Library/Preferences/pcgen" + File.separator + aString;
        }
        return fType + File.separator + aString;
    }

    private static void setSelectedPaper(int argSelectedPaper) {
        selectedPaper = argSelectedPaper;
    }

    private static boolean isUseGUI() {
        return useGUI;
    }

    private static int bonusParsing(String l, int level, int num, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(l, "|", false);
        int startLevel = Integer.parseInt(aTok.nextToken());
        String rangeLevelFormula = aTok.nextToken();
        int rangeLevel = aPC.getVariableValue(rangeLevelFormula, "").intValue();
        int numChoices = 1;
        if (aTok.hasMoreTokens()) {
            numChoices = Integer.parseInt(aTok.nextToken());
        }
        if (level == startLevel || level > startLevel && rangeLevel > 0 && (level - startLevel) % rangeLevel == 0) {
            num += numChoices;
        }
        return num;
    }

    public static void createEmptyRace() {
        if (s_EMPTYRACE == null) {
            s_EMPTYRACE = new Race();
            s_EMPTYRACE.setName("<none selected>");
            s_EMPTYRACE.addToListFor(ListKey.TYPE, Type.HUMANOID);
        }
        Globals.getContext().getReferenceContext().importObject(s_EMPTYRACE);
    }

    private static String expandRelativePath(String path) {
        if (path.startsWith("@")) {
            path = System.getProperty("user.dir") + File.separator + path.substring(1);
        }
        return path;
    }

    public static LoadContext getContext() {
        return SettingsHandler.getGame().getContext();
    }

    public static LoadContext getGlobalContext() {
        return globalContext;
    }

    public static MasterListInterface getMasterLists() {
        return SettingsHandler.getGame().getMasterLists();
    }

    public static boolean hasSpellPPCost() {
        return hasSpellPPCost;
    }

    static {
        javaVersion = System.getProperty("java.version");
        javaVersionMajor = Integer.valueOf(javaVersion.substring(0, javaVersion.indexOf(46)));
        javaVersionMinor = Integer.valueOf(javaVersion.substring(javaVersion.indexOf(46) + 1, javaVersion.lastIndexOf(46)));
        defaultPcgPath = Globals.getUserFilesPath() + File.separator + "characters";
        custColumnWidth = new ArrayList<String>();
        sourceDisplay = SourceFormat.LONG;
        selectedPaper = -1;
        campaignMap = new HashMap<URI, Campaign>();
        campaignNameMap = new HashMap<String, Campaign>();
        spellMap = new TreeMap<String, Spell>(String.CASE_INSENSITIVE_ORDER);
        eqSlotMap = new HashMap<String, String>();
        campaignList = new ArrayList<Campaign>(85);
        section15 = new StringBuilder(30000);
        useGUI = true;
        isMacPlatform = SystemUtils.IS_OS_MAC;
        defaultMacOptionsPath = System.getProperty("user.home") + "/Library/Preferences/pcgen";
        pObjectComp = new Comparator<CDOMObject>(){

            @Override
            public int compare(CDOMObject o1, CDOMObject o2) {
                return o1.getKeyName().compareToIgnoreCase(o2.getKeyName());
            }
        };
        pObjectNameComp = new Comparator<CDOMObject>(){

            @Override
            public int compare(CDOMObject o1, CDOMObject o2) {
                String key2;
                Collator collator = Collator.getInstance();
                String key1 = o1.get(StringKey.SORT_KEY);
                if (key1 == null) {
                    key1 = o1.getDisplayName();
                }
                if ((key2 = o2.get(StringKey.SORT_KEY)) == null) {
                    key2 = o2.getDisplayName();
                }
                if (!key1.equals(key2)) {
                    return collator.compare(key1, key2);
                }
                if (!o1.getDisplayName().equals(o2.getDisplayName())) {
                    return collator.compare(o1.getDisplayName(), o2.getDisplayName());
                }
                return collator.compare(o1.getKeyName(), o2.getKeyName());
            }
        };
        EMPTY_STRING_ARRAY = new String[0];
        globalContext = new RuntimeLoadContext(new RuntimeReferenceContext(), new ConsolidatedListCommitStrategy());
    }
}

