/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.formula;

import pcgen.base.formula.ReferenceFormula;

public class DividingFormula
implements ReferenceFormula<Integer> {
    private final int denominator;

    public DividingFormula(int denom) {
        if (denom == 0) {
            throw new IllegalArgumentException("Cannot build a DividingFormula that divides by Zero - will always cause an ArithmeticException when resolved");
        }
        this.denominator = denom;
    }

    @Override
    public Integer resolve(Number ... numbers) {
        if (numbers == null || numbers.length != 1) {
            throw new IllegalArgumentException("DividingFormula only has one back-reference");
        }
        return numbers[0].intValue() / this.denominator;
    }

    public String toString() {
        return "/" + this.denominator;
    }

    public int hashCode() {
        return this.denominator;
    }

    public boolean equals(Object obj) {
        return obj instanceof DividingFormula && ((DividingFormula)obj).denominator == this.denominator;
    }
}

