/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.lang;

import java.math.BigDecimal;

public final class NumberUtilities {
    private NumberUtilities() {
    }

    public static Number getNumber(String number) {
        if (number.length() < 8) {
            try {
                return Integer.valueOf(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return Double.valueOf(number);
    }

    public static Number getPreciseNumber(String number) {
        if (number.length() < 8) {
            try {
                return Integer.valueOf(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new BigDecimal(number);
    }

    public static Number add(Number a, Number b) {
        if (a instanceof Integer && b instanceof Integer) {
            return a.intValue() + b.intValue();
        }
        return a.doubleValue() + b.doubleValue();
    }

    public static Number divide(Number numerator, Number divisor) {
        if (numerator instanceof Integer && divisor instanceof Integer) {
            int num = numerator.intValue();
            int div = divisor.intValue();
            if (div != 0 && num % div == 0) {
                return num / div;
            }
        }
        return numerator.doubleValue() / divisor.doubleValue();
    }

    public static Number max(Number a, Number b) {
        return a.doubleValue() > b.doubleValue() ? (Number)a : (Number)b;
    }

    public static Number min(Number a, Number b) {
        return a.doubleValue() < b.doubleValue() ? (Number)a : (Number)b;
    }

    public static Number multiply(Number a, Number b) {
        if (a instanceof Integer && b instanceof Integer) {
            return a.intValue() * b.intValue();
        }
        return a.doubleValue() * b.doubleValue();
    }
}

