/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.internal;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.display.Displayable;
import java.text.NumberFormat;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CommonFormats {
    public static final String COMMA_DELIMITER = ", ";
    public static final String DASH_DELIMITER = " \u2013 ";
    public static final String DOT_DELIMITER = " \u2022 ";
    public static final String SLASH_DELIMITER = " / ";
    protected static final Pattern NON_WORD_PATTERN = Pattern.compile("\\W*");
    protected static final Pattern WORD_PATTERN = Pattern.compile("\\w+\\W*");
    protected static final Pattern WHITESPACE_PATTERN = Pattern.compile("[^\\s\\u202f]*");
    public static final String NO_VALUE_POSSIBLE = "\u00d7";
    public static final String ZERO = "\u2013";
    public static final String ALMOST_ZERO = "0";
    public static final String VALUE_UNKNOWN = "\u2026";

    protected CommonFormats() {
    }

    public static String dashed(Object ... items) {
        return CommonFormats.joinWithDashes(items);
    }

    public static String dotted(Object ... items) {
        return CommonFormats.joinWithDots(items);
    }

    public static String slashed(Object ... items) {
        return CommonFormats.joinWithSlashes(items);
    }

    public static String join(CharSequence delimiter, Object ... items) {
        Preconditions.checkNotBlank(delimiter, "The %s must not be null, empty, or whitespace.", "delimiter");
        if (items == null || items.length == 0) {
            return "";
        }
        return CommonFormats.join0(delimiter, Stream.of(items));
    }

    public static String join(CharSequence delimiter, List<? extends Object> items) {
        Preconditions.checkNotBlank(delimiter, "The %s must not be null, empty, or whitespace.", "delimiter");
        if (items == null || items.size() == 0) {
            return "";
        }
        return CommonFormats.join0(delimiter, items.stream());
    }

    public static String join(CharSequence delimiter, Stream<? extends Object> stream) {
        Preconditions.checkNotBlank(delimiter, "The %s must not be null, empty, or whitespace.", "delimiter");
        return CommonFormats.join0(delimiter, stream);
    }

    public static String joinWithCommas(Object ... items) {
        return CommonFormats.join0((CharSequence)COMMA_DELIMITER, items);
    }

    public static String joinWithCommas(List<? extends Object> items) {
        return CommonFormats.join0((CharSequence)COMMA_DELIMITER, items);
    }

    public static String joinWithCommas(Stream<? extends Object> stream) {
        return CommonFormats.join0((CharSequence)COMMA_DELIMITER, stream);
    }

    public static String joinWithDashes(Object ... items) {
        return CommonFormats.join0((CharSequence)DASH_DELIMITER, items);
    }

    public static String joinWithDashes(List<? extends Object> items) {
        return CommonFormats.join0((CharSequence)DASH_DELIMITER, items);
    }

    public static String joinWithDashes(Stream<? extends Object> items) {
        return CommonFormats.join0((CharSequence)DASH_DELIMITER, items);
    }

    public static String joinWithDots(Object ... items) {
        return CommonFormats.join0((CharSequence)DOT_DELIMITER, items);
    }

    public static String joinWithDots(List<? extends Object> items) {
        return CommonFormats.join0((CharSequence)DOT_DELIMITER, items);
    }

    public static String joinWithDots(Stream<? extends Object> items) {
        return CommonFormats.join0((CharSequence)DOT_DELIMITER, items);
    }

    public static String joinWithSlashes(Object ... items) {
        return CommonFormats.join0((CharSequence)SLASH_DELIMITER, items);
    }

    public static String joinWithSlashes(List<? extends Object> items) {
        return CommonFormats.join0((CharSequence)SLASH_DELIMITER, items);
    }

    public static String joinWithSlashes(Stream<? extends Object> stream) {
        return CommonFormats.join0((CharSequence)SLASH_DELIMITER, stream);
    }

    public static String formatNumber(long value) {
        return NumberFormat.getIntegerInstance().format(value);
    }

    public static String formatNumber(long value, String unit) {
        return CommonFormats.formatNumber(CommonFormats.formatNumber(value), unit);
    }

    public static String formatNumber(String number, String unit) {
        return number + '\u202f' + unit;
    }

    public static String formatFromTo(Object from, Object to, Object ... furtherLocations) {
        String separator = "\u202f\u2012\u202f";
        StringBuilder builder = new StringBuilder().append(from).append("\u202f\u2012\u202f").append(to);
        if (furtherLocations != null) {
            for (Object location : furtherLocations) {
                builder.append("\u202f\u2012\u202f").append(location);
            }
        }
        return builder.toString();
    }

    public static String formatObjectNo(Object object, String no) {
        return object + '\u202f' + no;
    }

    public static String formatDisplayable(Displayable object) {
        return object == null ? "" : object.getDisplayString();
    }

    private static String join0(CharSequence delimiter, Object ... items) {
        if (items == null || items.length == 0) {
            return "";
        }
        return CommonFormats.join0(delimiter, Stream.of(items));
    }

    private static String join0(CharSequence delimiter, List<? extends Object> items) {
        if (items == null || items.size() == 0) {
            return "";
        }
        return CommonFormats.join0(delimiter, items.stream());
    }

    private static String join0(CharSequence delimiter, Stream<? extends Object> stream) {
        return stream.filter(item -> item != null).map(Object::toString).filter(Strings::isNotBlank).collect(Collectors.joining(delimiter));
    }
}

