/*
 * Decompiled with CFR 0.152.
 */
package jrm.ui.profile;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableModelEvent;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import jrm.locale.Messages;
import jrm.misc.Settings;
import jrm.profile.Profile;
import jrm.profile.data.Anyware;
import jrm.profile.data.AnywareList;
import jrm.profile.data.AnywareListList;
import jrm.profile.data.AnywareStatus;
import jrm.profile.data.Device;
import jrm.profile.data.EntityStatus;
import jrm.profile.data.Machine;
import jrm.profile.data.MachineListList;
import jrm.profile.data.Software;
import jrm.profile.data.SoftwareList;
import jrm.profile.manager.Export;
import jrm.profile.manager.ProfileNFOMame;
import jrm.ui.basic.JRMFileChooser;
import jrm.ui.profile.filter.KeywordFilter;
import jrm.ui.progress.Progress;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.SerializationUtils;

public class ProfileViewer
extends JDialog {
    private JTable tableEntity;
    private JTable tableW;
    private JTable tableWL;
    private JTextField txtSearch;

    public ProfileViewer(Window owner, Profile profile) {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                Settings.setProperty("ProfileViewer.Bounds", Hex.encodeHexString(SerializationUtils.serialize((Serializable)ProfileViewer.this.getBounds())));
            }
        });
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(ProfileViewer.class.getResource("/jrm/resources/rom.png")));
        this.setTitle(Messages.getString("ProfileViewer.this.title"));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.5);
        splitPane.setOrientation(0);
        this.getContentPane().add((Component)splitPane, "Center");
        JPanel panelWare = new JPanel();
        splitPane.setLeftComponent(panelWare);
        panelWare.setLayout(new BorderLayout(0, 0));
        JSplitPane splitPaneWLW = new JSplitPane();
        splitPaneWLW.setOneTouchExpandable(true);
        splitPaneWLW.setContinuousLayout(true);
        splitPaneWLW.setResizeWeight(0.25);
        panelWare.add((Component)splitPaneWLW, "Center");
        this.tableEntity = new JTable();
        this.tableEntity.setPreferredScrollableViewportSize(new Dimension(1200, 300));
        this.tableEntity.setShowGrid(false);
        this.tableEntity.setShowHorizontalLines(false);
        this.tableEntity.setShowVerticalLines(false);
        this.tableEntity.setRowSelectionAllowed(false);
        this.tableEntity.setFillsViewportHeight(true);
        this.tableEntity.setAutoResizeMode(4);
        JPanel panelW = new JPanel();
        splitPaneWLW.setRightComponent(panelW);
        panelW.setLayout(new BorderLayout(0, 0));
        JToolBar toolBarW = new JToolBar();
        panelW.add((Component)toolBarW, "South");
        JToggleButton tglbtnMissingW = new JToggleButton("");
        tglbtnMissingW.setSelected(true);
        tglbtnMissingW.setToolTipText(Messages.getString("ProfileViewer.tglbtnMissingW.toolTipText"));
        tglbtnMissingW.setIcon(new ImageIcon(ProfileViewer.class.getResource("/jrm/resources/folder_closed_red.png")));
        toolBarW.add(tglbtnMissingW);
        JToggleButton tglbtnPartialW = new JToggleButton("");
        tglbtnPartialW.setSelected(true);
        tglbtnPartialW.setToolTipText(Messages.getString("ProfileViewer.tglbtnPartialW.toolTipText"));
        tglbtnPartialW.setIcon(new ImageIcon(ProfileViewer.class.getResource("/jrm/resources/folder_closed_orange.png")));
        toolBarW.add(tglbtnPartialW);
        JToggleButton tglbtnCompleteW = new JToggleButton("");
        tglbtnCompleteW.setSelected(true);
        tglbtnCompleteW.setIcon(new ImageIcon(ProfileViewer.class.getResource("/jrm/resources/folder_closed_green.png")));
        tglbtnCompleteW.setToolTipText(Messages.getString("ProfileViewer.tglbtnCompleteW.toolTipText"));
        toolBarW.add(tglbtnCompleteW);
        JPanel panel_1 = new JPanel();
        panel_1.setBorder(null);
        toolBarW.add(panel_1);
        GridBagLayout gbl_panel_1 = new GridBagLayout();
        gbl_panel_1.columnWidths = new int[]{286, 166, 0};
        gbl_panel_1.rowHeights = new int[]{20, 0};
        gbl_panel_1.columnWeights = new double[]{1.0, 0.0, Double.MIN_VALUE};
        gbl_panel_1.rowWeights = new double[]{1.0, Double.MIN_VALUE};
        panel_1.setLayout(gbl_panel_1);
        JLabel lblSearch = new JLabel(Messages.getString("ProfileViewer.lblSearch.text"));
        GridBagConstraints gbc_lblSearch = new GridBagConstraints();
        gbc_lblSearch.insets = new Insets(0, 0, 0, 5);
        gbc_lblSearch.anchor = 13;
        gbc_lblSearch.gridx = 0;
        gbc_lblSearch.gridy = 0;
        panel_1.add((Component)lblSearch, gbc_lblSearch);
        this.txtSearch = new JTextField();
        this.txtSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String search = ProfileViewer.this.txtSearch.getText();
                int row = ((AnywareList)ProfileViewer.this.tableW.getModel()).find(search);
                if (row >= 0) {
                    ProfileViewer.this.tableW.setRowSelectionInterval(row, row);
                    ProfileViewer.this.tableW.scrollRectToVisible(ProfileViewer.this.tableW.getCellRect(row, 0, true));
                }
            }
        });
        GridBagConstraints gbc_txtSearch = new GridBagConstraints();
        gbc_txtSearch.fill = 3;
        gbc_txtSearch.anchor = 17;
        gbc_txtSearch.gridx = 1;
        gbc_txtSearch.gridy = 0;
        panel_1.add((Component)this.txtSearch, gbc_txtSearch);
        this.txtSearch.setText("");
        this.txtSearch.setColumns(20);
        tglbtnMissingW.addItemListener(e -> this.setFilterW(tglbtnMissingW.isSelected(), tglbtnPartialW.isSelected(), tglbtnCompleteW.isSelected()));
        tglbtnPartialW.addItemListener(e -> this.setFilterW(tglbtnMissingW.isSelected(), tglbtnPartialW.isSelected(), tglbtnCompleteW.isSelected()));
        tglbtnCompleteW.addItemListener(e -> this.setFilterW(tglbtnMissingW.isSelected(), tglbtnPartialW.isSelected(), tglbtnCompleteW.isSelected()));
        JScrollPane scrollPaneW = new JScrollPane();
        panelW.add(scrollPaneW);
        this.tableW = new JTable();
        scrollPaneW.setViewportView(this.tableW);
        this.tableW.setPreferredScrollableViewportSize(new Dimension(600, 400));
        this.tableW.setFillsViewportHeight(true);
        this.tableW.setSelectionMode(0);
        this.tableW.setShowGrid(false);
        this.tableW.setShowHorizontalLines(false);
        this.tableW.setShowVerticalLines(false);
        this.tableW.setAutoResizeMode(4);
        JPopupMenu popupWMenu = new JPopupMenu();
        ProfileViewer.addPopup(this.tableW, popupWMenu);
        JMenuItem mntmCollectKeywords = new JMenuItem(Messages.getString("ProfileViewer.mntmCollectKeywords.text"));
        mntmCollectKeywords.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnywareList list = (AnywareList)ProfileViewer.this.tableW.getModel();
                Pattern pattern = Pattern.compile("^(.*?)(\\(.*\\))+");
                Pattern pattern_parenthesis = Pattern.compile("\\((.*?)\\)");
                Pattern pattern_split = Pattern.compile(",");
                Pattern pattern_alpha = Pattern.compile("^[a-zA-Z]*$");
                HashSet keywords = new HashSet();
                list.getFilteredStream().forEach(ware -> {
                    Matcher matcher = pattern.matcher(ware.getDescription());
                    if (matcher.find() && matcher.groupCount() > 1 && matcher.group(2) != null) {
                        Matcher matcher_parenthesis = pattern_parenthesis.matcher(matcher.group(2));
                        while (matcher_parenthesis.find()) {
                            Arrays.asList(pattern_split.split(matcher_parenthesis.group(1))).stream().map(s -> s.trim().toLowerCase()).filter(pattern_alpha.asPredicate()).forEach(keywords::add);
                        }
                    }
                });
                new KeywordFilter((Window)ProfileViewer.this, (String[])keywords.stream().sorted((s1, s2) -> s1.length() == s2.length() ? s1.compareToIgnoreCase((String)s2) : s1.length() - s2.length()).toArray(String[]::new), f -> {
                    ArrayList<String> filter = f.getFilter();
                    HashMap prefmap = new HashMap();
                    list.getFilteredStream().forEach(ware -> {
                        Matcher matcher = pattern.matcher(ware.getDescription());
                        keywords.clear();
                        if (matcher.find()) {
                            if (matcher.groupCount() > 1 && matcher.group(2) != null) {
                                Matcher matcher_parenthesis = pattern_parenthesis.matcher(matcher.group(2));
                                while (matcher_parenthesis.find()) {
                                    Arrays.asList(pattern_split.split(matcher_parenthesis.group(1))).stream().map(s -> s.trim().toLowerCase()).filter(pattern_alpha.asPredicate()).forEach(keywords::add);
                                }
                            }
                            ware.selected = false;
                            for (int i = 0; i < filter.size(); ++i) {
                                if (!keywords.contains(filter.get(i))) continue;
                                if (prefmap.containsKey(matcher.group(1))) {
                                    keypref pref = (keypref)prefmap.get(matcher.group(1));
                                    if (i < pref.order) {
                                        pref.clear();
                                        prefmap.put(matcher.group(1), new keypref(i, (Anyware)ware));
                                    } else if (i == pref.order) {
                                        pref.add(ware);
                                    }
                                } else {
                                    prefmap.put(matcher.group(1), new keypref(i, (Anyware)ware));
                                }
                                break;
                            }
                        } else if (!prefmap.containsKey(ware.getDescription().toString())) {
                            prefmap.put(ware.getDescription().toString(), new keypref(Integer.MAX_VALUE, (Anyware)ware));
                        }
                    });
                    list.fireTableChanged(new TableModelEvent(list, 0, list.getRowCount() - 1, -1, 0));
                });
            }
        });
        popupWMenu.add(mntmCollectKeywords);
        JMenuItem mntmSelectNone = new JMenuItem(Messages.getString("ProfileViewer.mntmSelectNone.text"));
        mntmSelectNone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnywareList list = (AnywareList)ProfileViewer.this.tableW.getModel();
                list.getFilteredStream().forEach(ware -> {
                    ware.selected = false;
                });
                list.fireTableChanged(new TableModelEvent(list, 0, list.getRowCount() - 1, -1, 0));
            }
        });
        popupWMenu.add(mntmSelectNone);
        JMenuItem mntmSelectAll = new JMenuItem(Messages.getString("ProfileViewer.mntmSelectAll.text"));
        mntmSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnywareList list = (AnywareList)ProfileViewer.this.tableW.getModel();
                list.getFilteredStream().forEach(ware -> {
                    ware.selected = true;
                });
                list.fireTableChanged(new TableModelEvent(list, 0, list.getRowCount() - 1, -1, 0));
            }
        });
        popupWMenu.add(mntmSelectAll);
        JMenuItem mntmSelectInvert = new JMenuItem(Messages.getString("ProfileViewer.mntmSelectInvert.text"));
        mntmSelectInvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnywareList list = (AnywareList)ProfileViewer.this.tableW.getModel();
                list.getFilteredStream().forEach(ware -> ware.selected ^= true);
                list.fireTableChanged(new TableModelEvent(list, 0, list.getRowCount() - 1, -1, 0));
            }
        });
        popupWMenu.add(mntmSelectInvert);
        JPanel panel = new JPanel();
        splitPaneWLW.setLeftComponent(panel);
        panel.setLayout(new BorderLayout(0, 0));
        JScrollPane scrollPaneWL = new JScrollPane();
        panel.add(scrollPaneWL);
        this.tableWL = new JTable();
        scrollPaneWL.setViewportView(this.tableWL);
        this.tableWL.setPreferredScrollableViewportSize(new Dimension(300, 400));
        this.tableWL.setModel(profile.machinelist_list);
        this.tableWL.setTableHeader(new JTableHeader(this.tableWL.getColumnModel()){

            @Override
            public String getToolTipText(MouseEvent e) {
                return this.columnModel.getColumn(this.columnModel.getColumnIndexAtX(e.getPoint().x)).getHeaderValue().toString();
            }
        });
        this.tableWL.setFillsViewportHeight(true);
        this.tableWL.setShowGrid(false);
        this.tableWL.setShowHorizontalLines(false);
        this.tableWL.setShowVerticalLines(false);
        this.tableWL.setSelectionMode(0);
        JPopupMenu popupMenu = new JPopupMenu();
        ProfileViewer.addPopup(this.tableWL, popupMenu);
        JMenu mnExportAll = new JMenu(Messages.getString("ProfileViewer.ExportAll"));
        popupMenu.add(mnExportAll);
        JMenu mnExportAllFiltered = new JMenu(Messages.getString("ProfileViewer.Filtered"));
        mnExportAll.add(mnExportAllFiltered);
        final JMenuItem mntmFilteredAsLogiqxDat = new JMenuItem(Messages.getString("ProfileViewer.AsLogiqxDat"));
        mnExportAllFiltered.add(mntmFilteredAsLogiqxDat);
        mntmFilteredAsLogiqxDat.addActionListener(e -> this.export(Export.ExportType.DATAFILE, true, null));
        final JMenuItem mntmFilteredAsMameDat = new JMenuItem(Messages.getString("ProfileViewer.AsMameDat"));
        mnExportAllFiltered.add(mntmFilteredAsMameDat);
        mntmFilteredAsMameDat.addActionListener(e -> this.export(Export.ExportType.MAME, true, null));
        final JMenuItem mntmFilteredAsSoftwareLists = new JMenuItem(Messages.getString("ProfileViewer.AsSWListsDat"));
        mnExportAllFiltered.add(mntmFilteredAsSoftwareLists);
        mntmFilteredAsSoftwareLists.addActionListener(e -> this.export(Export.ExportType.SOFTWARELIST, true, null));
        final JMenuItem mntmAllAsLogiqxDat = new JMenuItem(Messages.getString("ProfileViewer.AsLogiqxDat"));
        mntmAllAsLogiqxDat.setEnabled(false);
        mnExportAll.add(mntmAllAsLogiqxDat);
        mntmAllAsLogiqxDat.addActionListener(e -> this.export(Export.ExportType.DATAFILE, false, null));
        final JMenuItem mntmAllAsMameDat = new JMenuItem(Messages.getString("ProfileViewer.AsMameDat"));
        mntmAllAsMameDat.setEnabled(false);
        mnExportAll.add(mntmAllAsMameDat);
        mntmAllAsMameDat.addActionListener(e -> this.export(Export.ExportType.MAME, false, null));
        final JMenuItem mntmAllAsSoftwareLists = new JMenuItem(Messages.getString("ProfileViewer.AsSWListsDat"));
        mntmAllAsSoftwareLists.setEnabled(false);
        mnExportAll.add(mntmAllAsSoftwareLists);
        mntmAllAsSoftwareLists.addActionListener(e -> this.export(Export.ExportType.SOFTWARELIST, false, null));
        JMenu mnExportSelected = new JMenu(Messages.getString("ProfileViewer.ExportSelected"));
        popupMenu.add(mnExportSelected);
        JMenu mnExportSelectedFiltered = new JMenu(Messages.getString("ProfileViewer.Filtered"));
        mnExportSelected.add(mnExportSelectedFiltered);
        final JMenuItem mntmSelectedFilteredAsSoftwareList = new JMenuItem(Messages.getString("ProfileViewer.AsSWListDat"));
        mnExportSelectedFiltered.add(mntmSelectedFilteredAsSoftwareList);
        mntmSelectedFilteredAsSoftwareList.addActionListener(e -> this.export(Export.ExportType.SOFTWARELIST, true, (SoftwareList)this.tableWL.getModel().getValueAt(this.tableWL.getSelectedRow(), 0)));
        final JMenuItem mntmSelectedAsSoftwareLists = new JMenuItem(Messages.getString("ProfileViewer.AsSWListsDat"));
        mntmSelectedAsSoftwareLists.setEnabled(false);
        mnExportSelected.add(mntmSelectedAsSoftwareLists);
        mntmSelectedAsSoftwareLists.addActionListener(e -> this.export(Export.ExportType.SOFTWARELIST, false, (SoftwareList)this.tableWL.getModel().getValueAt(this.tableWL.getSelectedRow(), 0)));
        popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                boolean has_machines = Profile.curr_profile.machinelist_list.getList().stream().mapToInt(ml -> ml.getList().size()).sum() > 0;
                boolean has_filtered_machines = Profile.curr_profile.machinelist_list.getFilteredStream().mapToInt(m -> (int)m.countAll()).sum() > 0;
                boolean has_selected_swlist = ProfileViewer.this.tableWL.getSelectedRowCount() == 1 && ProfileViewer.this.tableWL.getModel() instanceof AnywareListList && ((AnywareListList)ProfileViewer.this.tableWL.getModel()).getValueAt(ProfileViewer.this.tableWL.getSelectedRow(), 0) instanceof SoftwareList;
                mntmAllAsMameDat.setEnabled(has_machines);
                mntmAllAsLogiqxDat.setEnabled(has_machines);
                mntmAllAsSoftwareLists.setEnabled(Profile.curr_profile.machinelist_list.softwarelist_list.size() > 0);
                mntmFilteredAsMameDat.setEnabled(has_filtered_machines);
                mntmFilteredAsLogiqxDat.setEnabled(has_filtered_machines);
                mntmFilteredAsSoftwareLists.setEnabled(Profile.curr_profile.machinelist_list.softwarelist_list.getFilteredStream().count() > 0L);
                mntmSelectedAsSoftwareLists.setEnabled(has_selected_swlist);
                mntmSelectedFilteredAsSoftwareList.setEnabled(has_selected_swlist);
            }
        });
        JToolBar toolBarWL = new JToolBar();
        panel.add((Component)toolBarWL, "South");
        JToggleButton tglbtnMissingWL = new JToggleButton("");
        tglbtnMissingWL.setSelected(true);
        tglbtnMissingWL.setIcon(new ImageIcon(ProfileViewer.class.getResource("/jrm/resources/disk_multiple_red.png")));
        tglbtnMissingWL.setToolTipText(Messages.getString("ProfileViewer.tglbtnMissingWL.toolTipText"));
        toolBarWL.add(tglbtnMissingWL);
        JToggleButton tglbtnPartialWL = new JToggleButton("");
        tglbtnPartialWL.setSelected(true);
        tglbtnPartialWL.setIcon(new ImageIcon(ProfileViewer.class.getResource("/jrm/resources/disk_multiple_orange.png")));
        tglbtnPartialWL.setToolTipText(Messages.getString("ProfileViewer.tglbtnPartialWL.toolTipText"));
        toolBarWL.add(tglbtnPartialWL);
        JToggleButton tglbtnCompleteWL = new JToggleButton("");
        tglbtnCompleteWL.setSelected(true);
        tglbtnCompleteWL.setIcon(new ImageIcon(ProfileViewer.class.getResource("/jrm/resources/disk_multiple_green.png")));
        tglbtnCompleteWL.setToolTipText(Messages.getString("ProfileViewer.tglbtnCompleteWL.toolTipText"));
        toolBarWL.add(tglbtnCompleteWL);
        tglbtnMissingWL.addItemListener(e -> this.setFilterWL(tglbtnMissingWL.isSelected(), tglbtnPartialWL.isSelected(), tglbtnCompleteWL.isSelected()));
        tglbtnPartialWL.addItemListener(e -> this.setFilterWL(tglbtnMissingWL.isSelected(), tglbtnPartialWL.isSelected(), tglbtnCompleteWL.isSelected()));
        tglbtnCompleteWL.addItemListener(e -> this.setFilterWL(tglbtnMissingWL.isSelected(), tglbtnPartialWL.isSelected(), tglbtnCompleteWL.isSelected()));
        this.tableWL.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                ListSelectionModel model = (ListSelectionModel)e.getSource();
                TableModel tablemodel = this.tableWL.getModel();
                if (model != null && tablemodel != null) {
                    if (!model.isSelectionEmpty()) {
                        AnywareList anywarelist = (AnywareList)tablemodel.getValueAt(model.getMinSelectionIndex(), 0);
                        anywarelist.reset();
                        this.tableW.setModel(anywarelist);
                        this.tableW.setTableHeader(new JTableHeader(this.tableW.getColumnModel()){

                            @Override
                            public String getToolTipText(MouseEvent e) {
                                return this.columnModel.getColumn(this.columnModel.getColumnIndexAtX(e.getPoint().x)).getHeaderValue().toString();
                            }
                        });
                        if (this.tableW.getRowCount() > 0) {
                            this.tableW.setRowSelectionInterval(0, 0);
                        }
                        for (int i = 0; i < this.tableW.getColumnModel().getColumnCount(); ++i) {
                            TableColumn column = this.tableW.getColumnModel().getColumn(i);
                            column.setCellRenderer(anywarelist.getColumnRenderer(i));
                            int width = anywarelist.getColumnWidth(i);
                            if (width > 0) {
                                column.setMinWidth(width / 2);
                                column.setPreferredWidth(width);
                                continue;
                            }
                            if (width >= 0) continue;
                            column.setMinWidth(-width);
                            column.setMaxWidth(-width);
                        }
                    } else {
                        this.tableW.setModel(new DefaultTableModel());
                        this.tableEntity.setModel(new DefaultTableModel());
                    }
                }
            }
        });
        this.tableW.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column;
                AnywareList tablemodel;
                Object obj;
                JTable target;
                int row;
                if (e.getClickCount() == 2 && (row = (target = (JTable)e.getSource()).getSelectedRow()) >= 0 && (obj = (tablemodel = (AnywareList)target.getModel()).getValueAt(row, column = target.columnAtPoint(e.getPoint()))) instanceof Anyware) {
                    Anyware ware = (Anyware)obj;
                    if (column > 1) {
                        row = tablemodel.find(ware);
                        if (row >= 0) {
                            target.setRowSelectionInterval(row, row);
                            target.scrollRectToVisible(target.getCellRect(row, 0, true));
                        }
                    } else if (ware.getStatus() == AnywareStatus.COMPLETE) {
                        if (Profile.curr_profile != null) {
                            Profile profile = Profile.curr_profile;
                            if (profile.nfo.mame.getStatus() == ProfileNFOMame.MameStatus.UPTODATE) {
                                ArrayList<String> rompaths;
                                ProfileNFOMame mame = profile.nfo.mame;
                                String[] args = null;
                                if (ware instanceof Software) {
                                    rompaths = new ArrayList<String>(Collections.singletonList(profile.getProperty("roms_dest_dir", "")));
                                    if (profile.getProperty("swroms_dest_dir_enabled", false)) {
                                        rompaths.add(profile.getProperty("swroms_dest_dir", ""));
                                    }
                                    if (profile.getProperty("disks_dest_dir_enabled", false)) {
                                        rompaths.add(profile.getProperty("disks_dest_dir", ""));
                                    }
                                    if (profile.getProperty("swdisks_dest_dir_enabled", false)) {
                                        rompaths.add(profile.getProperty("swdisks_dest_dir", ""));
                                    }
                                    System.out.println(((Software)ware).sl.getBaseName() + ", " + ((Software)ware).compatibility);
                                    JList<Machine> machines = new JList<Machine>(profile.machinelist_list.getSortedMachines(((Software)ware).sl.getBaseName(), ((Software)ware).compatibility).toArray(new Machine[0]));
                                    machines.setSelectionMode(0);
                                    if (machines.getModel().getSize() > 0) {
                                        machines.setSelectedIndex(0);
                                    }
                                    JOptionPane.showMessageDialog(ProfileViewer.this, machines);
                                    Machine machine = machines.getSelectedValue();
                                    if (machine != null) {
                                        String device = "";
                                        for (Device dev : machine.devices) {
                                            if (!Objects.equals(((Software)ware).parts.get((int)0).intrface, dev.intrface) || dev.instance == null) continue;
                                            device = "-" + dev.instance.name;
                                            break;
                                        }
                                        System.out.println("-> " + machine.getBaseName() + " " + device + " " + ware.getBaseName());
                                        args = new String[]{mame.getFile().getAbsolutePath(), machine.getBaseName(), device, ware.getBaseName(), "-homepath", mame.getFile().getParent(), "-rompath", rompaths.stream().collect(Collectors.joining(";"))};
                                    }
                                } else {
                                    rompaths = new ArrayList<String>(Collections.singletonList(profile.getProperty("roms_dest_dir", "")));
                                    if (profile.getProperty("disks_dest_dir_enabled", false)) {
                                        rompaths.add(profile.getProperty("disks_dest_dir", ""));
                                    }
                                    args = new String[]{mame.getFile().getAbsolutePath(), ware.getBaseName(), "-homepath", mame.getFile().getParent(), "-rompath", rompaths.stream().collect(Collectors.joining(";"))};
                                }
                                if (args != null) {
                                    ProcessBuilder pb = new ProcessBuilder(args).directory(mame.getFile().getParentFile()).redirectErrorStream(true).redirectOutput(new File(mame.getFile().getParentFile(), "JRomManager.log"));
                                    try {
                                        pb.start().waitFor();
                                    }
                                    catch (IOException | InterruptedException e1) {
                                        JOptionPane.showMessageDialog(ProfileViewer.this, e1.getMessage(), Messages.getString("ProfileViewer.Exception"), 0);
                                    }
                                }
                            } else {
                                JOptionPane.showMessageDialog(ProfileViewer.this, String.format(Messages.getString("ProfileViewer.MameNotAvailableOrObsolete"), new Object[]{profile.nfo.mame.getStatus()}), Messages.getString("ProfileViewer.Error"), 0);
                            }
                        } else {
                            JOptionPane.showMessageDialog(ProfileViewer.this, Messages.getString("ProfileViewer.NoProfile"), Messages.getString("ProfileViewer.Error"), 0);
                        }
                    } else {
                        JOptionPane.showMessageDialog(ProfileViewer.this, String.format(Messages.getString("ProfileViewer.CantLaunchIncompleteSet"), ware.getStatus()), Messages.getString("ProfileViewer.Error"), 0);
                    }
                }
            }
        });
        this.tableW.getSelectionModel().addListSelectionListener(e -> {
            if (!e.getValueIsAdjusting()) {
                ListSelectionModel model = (ListSelectionModel)e.getSource();
                TableModel tablemodel = this.tableW.getModel();
                if (model != null && tablemodel != null) {
                    if (!model.isSelectionEmpty()) {
                        Anyware anyware = (Anyware)tablemodel.getValueAt(model.getMinSelectionIndex(), 0);
                        anyware.reset();
                        this.tableEntity.setModel(anyware);
                        this.tableEntity.setTableHeader(new JTableHeader(this.tableEntity.getColumnModel()){

                            @Override
                            public String getToolTipText(MouseEvent e) {
                                return this.columnModel.getColumn(this.columnModel.getColumnIndexAtX(e.getPoint().x)).getHeaderValue().toString();
                            }
                        });
                        for (int i = 0; i < this.tableEntity.getColumnModel().getColumnCount(); ++i) {
                            TableColumn column = this.tableEntity.getColumnModel().getColumn(i);
                            column.setCellRenderer(anyware.getColumnRenderer(i));
                            int width = anyware.getColumnWidth(i);
                            if (width > 0) {
                                column.setMinWidth(width / 2);
                                column.setPreferredWidth(width);
                                continue;
                            }
                            if (width >= 0) continue;
                            Component component = column.getCellRenderer().getTableCellRendererComponent(this.tableEntity, null, false, false, 0, i);
                            int pixwidth = component.getFontMetrics(component.getFont()).stringWidth(String.format("%0" + -width + "d", 0));
                            column.setMinWidth(pixwidth / 2);
                            column.setPreferredWidth(pixwidth);
                            column.setMaxWidth(pixwidth);
                        }
                    } else {
                        this.tableEntity.setModel(new DefaultTableModel());
                    }
                }
            }
        });
        JPanel panelEntity = new JPanel();
        splitPane.setRightComponent(panelEntity);
        panelEntity.setLayout(new BorderLayout(0, 0));
        JToolBar toolBarEntity = new JToolBar();
        panelEntity.add((Component)toolBarEntity, "South");
        JToggleButton tglbtnBad = new JToggleButton("");
        tglbtnBad.setSelected(true);
        tglbtnBad.setIcon(new ImageIcon(ProfileViewer.class.getResource("/jrm/resources/icons/bullet_red.png")));
        tglbtnBad.setToolTipText(Messages.getString("ProfileViewer.tglbtnBad.toolTipText"));
        toolBarEntity.add(tglbtnBad);
        JToggleButton tglbtnOK = new JToggleButton("");
        tglbtnOK.setSelected(true);
        tglbtnOK.setToolTipText(Messages.getString("ProfileViewer.tglbtnOK.toolTipText"));
        tglbtnOK.setIcon(new ImageIcon(ProfileViewer.class.getResource("/jrm/resources/icons/bullet_green.png")));
        toolBarEntity.add(tglbtnOK);
        tglbtnBad.addItemListener(e -> this.setFilterE(tglbtnBad.isSelected(), tglbtnOK.isSelected()));
        tglbtnOK.addItemListener(e -> this.setFilterE(tglbtnBad.isSelected(), tglbtnOK.isSelected()));
        JScrollPane scrollPaneEntity = new JScrollPane();
        panelEntity.add((Component)scrollPaneEntity, "Center");
        scrollPaneEntity.setViewportView(this.tableEntity);
        this.reset(profile);
        this.pack();
        try {
            this.setBounds((Rectangle)SerializationUtils.deserialize((byte[])Hex.decodeHex(Settings.getProperty("ProfileViewer.Bounds", Hex.encodeHexString(SerializationUtils.serialize((Serializable)this.getBounds()))))));
        }
        catch (DecoderException e1) {
            e1.printStackTrace();
        }
        this.setVisible(true);
    }

    private void export(Export.ExportType type, boolean filtered, SoftwareList selection) {
        new Thread(() -> {
            FileNameExtensionFilter fnef = new FileNameExtensionFilter(Messages.getString("MainFrame.DatFile"), "xml", "dat");
            new JRMFileChooser<Void>(1, 0, Optional.ofNullable(Settings.getProperty("MainFrame.ChooseExeOrDatToExport", null)).map(File::new).orElse(null), null, Arrays.asList(fnef), Messages.getString("ProfileViewer.ChooseDestinationFile"), false).show(this, chooser -> {
                Progress progress = new Progress((Window)this);
                progress.setVisible(true);
                Settings.setProperty("MainFrame.ChooseExeOrDatToExport", chooser.getCurrentDirectory().getAbsolutePath());
                File selectedfile = chooser.getSelectedFile();
                File file = fnef.accept(selectedfile) ? selectedfile : new File(selectedfile.getAbsolutePath() + ".xml");
                new Export(Profile.curr_profile, file, type, filtered, selection, progress);
                progress.dispose();
                return null;
            });
        }).start();
    }

    public void setFilterWL(boolean missing, boolean partial, boolean complete) {
        EnumSet<AnywareStatus> filter = EnumSet.of(AnywareStatus.UNKNOWN);
        if (missing) {
            filter.add(AnywareStatus.MISSING);
        }
        if (partial) {
            filter.add(AnywareStatus.PARTIAL);
        }
        if (complete) {
            filter.add(AnywareStatus.COMPLETE);
        }
        ((AnywareListList)this.tableWL.getModel()).setFilter(filter);
        if (this.tableWL.getRowCount() > 0) {
            this.tableWL.setRowSelectionInterval(0, 0);
        }
    }

    public void setFilterW(boolean missing, boolean partial, boolean complete) {
        EnumSet<AnywareStatus> filter = EnumSet.of(AnywareStatus.UNKNOWN);
        if (missing) {
            filter.add(AnywareStatus.MISSING);
        }
        if (partial) {
            filter.add(AnywareStatus.PARTIAL);
        }
        if (complete) {
            filter.add(AnywareStatus.COMPLETE);
        }
        ((AnywareList)this.tableW.getModel()).setFilter(filter);
        if (this.tableW.getRowCount() > 0) {
            this.tableW.setRowSelectionInterval(0, 0);
        }
    }

    public void setFilterE(boolean ko, boolean ok) {
        EnumSet<EntityStatus> filter = EnumSet.of(EntityStatus.UNKNOWN);
        if (ko) {
            filter.add(EntityStatus.KO);
        }
        if (ok) {
            filter.add(EntityStatus.OK);
        }
        ((Anyware)this.tableEntity.getModel()).setFilter(filter);
        if (this.tableEntity.getRowCount() > 0) {
            this.tableEntity.setRowSelectionInterval(0, 0);
        }
    }

    public void clear() {
        this.tableEntity.setModel(new DefaultTableModel());
        this.tableW.setModel(new DefaultTableModel());
        this.tableWL.setModel(new DefaultTableModel());
    }

    public void reset(Profile profile) {
        MachineListList model = profile.machinelist_list;
        ((AnywareListList)model).reset();
        if (this.tableWL.getModel() != model) {
            this.tableWL.setModel(model);
        }
        for (int i = 0; i < this.tableWL.getColumnModel().getColumnCount(); ++i) {
            TableColumn column = this.tableWL.getColumnModel().getColumn(i);
            column.setCellRenderer(((AnywareListList)model).getColumnRenderer(i));
            int width = ((AnywareListList)model).getColumnWidth(i);
            if (width > 0) {
                column.setMinWidth(width / 2);
                column.setPreferredWidth(width);
                continue;
            }
            if (width >= 0) continue;
            column.setMinWidth(-width);
            column.setMaxWidth(-width);
        }
        if (this.tableWL.getRowCount() > 0) {
            this.tableWL.setRowSelectionInterval(0, 0);
        }
    }

    public void reload() {
        TableModel tablemodel = this.tableWL.getModel();
        if (tablemodel instanceof AnywareListList) {
            ((AnywareListList)tablemodel).fireTableChanged(new TableModelEvent(tablemodel, 0, ((AnywareListList)tablemodel).getRowCount() - 1, -1, 0));
        }
        if ((tablemodel = this.tableW.getModel()) instanceof AnywareList) {
            ((AnywareList)tablemodel).fireTableChanged(new TableModelEvent(tablemodel, 0, ((AnywareList)tablemodel).getRowCount() - 1, -1, 0));
        }
        if ((tablemodel = this.tableEntity.getModel()) instanceof Anyware) {
            ((Anyware)tablemodel).fireTableChanged(new TableModelEvent(tablemodel, 0, ((Anyware)tablemodel).getRowCount() - 1, -1, 0));
        }
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    private class keypref {
        int order;
        List<Anyware> wares = new ArrayList<Anyware>();

        private keypref(int order, Anyware ware) {
            this.order = order;
            this.add(ware);
        }

        private void add(Anyware ware) {
            ware.selected = true;
            this.wares.add(ware);
        }

        private void clear() {
            this.wares.forEach(w -> {
                w.selected = false;
            });
            this.wares.clear();
        }
    }
}

