/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.report;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.tree.TreeNode;
import jrm.misc.HTMLRenderer;
import jrm.profile.data.AnywareBase;
import jrm.profile.report.FilterOptions;
import jrm.profile.report.Note;
import jrm.profile.report.Report;

public abstract class Subject
implements TreeNode,
HTMLRenderer {
    protected final AnywareBase ware;
    protected final List<Note> notes;
    protected Report parent;

    public Subject(AnywareBase machine) {
        this.ware = machine;
        this.notes = new ArrayList<Note>();
    }

    Subject(AnywareBase machine, List<Note> notes) {
        this.ware = machine;
        this.notes = notes;
    }

    public abstract Subject clone(List<FilterOptions> var1);

    public boolean add(Note note) {
        note.parent = this;
        boolean result = this.notes.add(note);
        return result;
    }

    public String getWareName() {
        if (this.ware != null) {
            return this.ware.getFullName();
        }
        return "";
    }

    public abstract void updateStats();

    public abstract String toString();

    @Override
    public TreeNode getChildAt(int childIndex) {
        return this.notes.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.notes.size();
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.notes.indexOf(node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.notes.size() == 0;
    }

    public Enumeration<Note> children() {
        return Collections.enumeration(this.notes);
    }
}

