/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.data;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import jrm.profile.data.Anyware;
import jrm.profile.data.Device;
import jrm.profile.data.Disk;
import jrm.profile.data.Driver;
import jrm.profile.data.Input;
import jrm.profile.data.Rom;
import jrm.profile.data.Slot;
import jrm.profile.data.Systm;
import jrm.profile.data.SystmDevice;
import jrm.profile.data.SystmMechanical;
import jrm.profile.data.SystmStandard;
import jrm.profile.filter.CatVer;
import jrm.profile.filter.NPlayers;
import jrm.xml.EnhancedXMLStreamWriter;
import jrm.xml.SimpleAttribute;

public class Machine
extends Anyware
implements Serializable {
    public String romof = null;
    public String sampleof = null;
    public boolean isbios = false;
    public boolean ismechanical = false;
    public boolean isdevice = false;
    public final StringBuffer manufacturer = new StringBuffer();
    public final Driver driver = new Driver();
    public final Input input = new Input();
    public DisplayOrientation orientation = DisplayOrientation.any;
    public CabinetType cabinetType = CabinetType.upright;
    public final Map<String, SWList> swlists = new HashMap<String, SWList>();
    public final List<String> device_ref = new ArrayList<String>();
    public final HashMap<String, Machine> device_machines = new HashMap();
    public final List<Device> devices = new ArrayList<Device>();
    public final Map<String, Slot> slots = new HashMap<String, Slot>();
    public transient CatVer.SubCategory subcat = null;
    public transient NPlayers.NPlayer nplayer = null;

    @Override
    public Machine getParent() {
        return this.getParent(Machine.class);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public String getFullName(String filename) {
        return filename;
    }

    @Override
    public boolean isBios() {
        return this.isbios;
    }

    @Override
    public boolean isRomOf() {
        return this.romof != null;
    }

    public boolean isSoftMachine() {
        return this.swlists.size() > 0 || this.isClone() && this.getParent().swlists.size() > 0;
    }

    @Override
    public Systm.Type getType() {
        if (this.parent != null) {
            return ((Machine)this.parent).getType();
        }
        if (this.isbios) {
            return Systm.Type.BIOS;
        }
        if (this.ismechanical) {
            return Systm.Type.MECHANICAL;
        }
        if (this.isdevice) {
            return Systm.Type.DEVICE;
        }
        return Systm.Type.STANDARD;
    }

    @Override
    public Systm getSystem() {
        switch (this.getType()) {
            case BIOS: {
                if (this.parent != null) {
                    return this.getParent().getSystem();
                }
                return this;
            }
            case DEVICE: {
                return SystmDevice.DEVICE;
            }
            case MECHANICAL: {
                return SystmMechanical.MECHANICAL;
            }
        }
        return SystmStandard.STANDARD;
    }

    @Override
    public String toString() {
        return "[" + (Object)((Object)this.getType()) + "] " + this.description.toString();
    }

    public int isCompatible(String softwarelist, String compatibility) {
        if (compatibility != null && new HashSet<String>(Arrays.asList(compatibility.split(","))).contains(this.swlists.get((Object)softwarelist).filter)) {
            return this.swlists.get((Object)softwarelist).status == SWStatus.original ? 20 : 10;
        }
        return this.swlists.get((Object)softwarelist).status == SWStatus.original ? 2 : 1;
    }

    public void export(EnhancedXMLStreamWriter writer, boolean is_mame) throws XMLStreamException, IOException {
        if (is_mame) {
            writer.writeStartElement("machine", new SimpleAttribute("name", this.name), new SimpleAttribute("isbios", this.isbios ? "yes" : null), new SimpleAttribute("isdevice", this.isdevice ? "yes" : null), new SimpleAttribute("ismechanical", this.ismechanical ? "yes" : null), new SimpleAttribute("cloneof", this.cloneof), new SimpleAttribute("romof", this.romof), new SimpleAttribute("sampleof", this.sampleof));
            writer.writeElement("description", this.description, new SimpleAttribute[0]);
            if (this.year != null && this.year.length() > 0) {
                writer.writeElement("year", this.year, new SimpleAttribute[0]);
            }
            if (this.manufacturer != null && this.manufacturer.length() > 0) {
                writer.writeElement("manufacturer", this.manufacturer, new SimpleAttribute[0]);
            }
            for (Rom r : this.roms) {
                r.export(writer, is_mame);
            }
            for (Disk d : this.disks) {
                d.export(writer, is_mame);
            }
            for (SWList swlist : this.swlists.values()) {
                writer.writeElement("softwarelist", new SimpleAttribute("name", swlist.name), new SimpleAttribute("status", (Object)swlist.status), new SimpleAttribute("filter", swlist.filter));
            }
            if (this.driver != null) {
                writer.writeElement("driver", new SimpleAttribute("status", (Object)this.driver.getStatus()), new SimpleAttribute("emulation", (Object)this.driver.getEmulation()), new SimpleAttribute("cocktail", (Object)this.driver.getCocktail()), new SimpleAttribute("savestate", (Object)this.driver.getSaveState()));
            }
            writer.writeEndElement();
        } else {
            writer.writeStartElement("game", new SimpleAttribute("name", this.name), new SimpleAttribute("isbios", this.isbios ? "yes" : null), new SimpleAttribute("cloneof", this.cloneof), new SimpleAttribute("romof", this.romof), new SimpleAttribute("sampleof", this.sampleof));
            writer.writeElement("description", this.description, new SimpleAttribute[0]);
            if (this.year != null && this.year.length() > 0) {
                writer.writeElement("year", this.year, new SimpleAttribute[0]);
            }
            if (this.manufacturer != null && this.manufacturer.length() > 0) {
                writer.writeElement("manufacturer", this.manufacturer, new SimpleAttribute[0]);
            }
            for (Rom r : this.roms) {
                r.export(writer, is_mame);
            }
            for (Disk d : this.disks) {
                d.export(writer, is_mame);
            }
            writer.writeEndElement();
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Machine) {
            return this.name.equals(((Machine)obj).name);
        }
        return super.equals(obj);
    }

    @Override
    public CharSequence getDescription() {
        return this.description;
    }

    protected void getDevices(HashSet<Machine> machines, boolean excludeBios, boolean partial, boolean recurse) {
        if (!machines.contains(this)) {
            machines.add(this);
            if (!this.isBios() || !excludeBios) {
                this.getDevices(partial).forEach(m -> {
                    if (!recurse) {
                        machines.add((Machine)m);
                    } else {
                        m.getDevices(machines, excludeBios, partial, recurse);
                    }
                });
            }
        }
    }

    private Stream<Machine> getDevices(boolean partial) {
        if (partial) {
            return this.device_machines.values().stream().filter(device -> this.device_ref.contains(device.name));
        }
        return this.device_machines.values().stream();
    }

    @Override
    protected Stream<Rom> streamWithDevices(boolean excludeBios, boolean partial, boolean recurse) {
        HashSet<Machine> machines = new HashSet<Machine>();
        this.getDevices(machines, excludeBios, partial, recurse);
        return machines.stream().flatMap(m -> m.roms.stream());
    }

    public static enum CabinetType {
        any,
        upright,
        cocktail;

    }

    public static enum DisplayOrientation {
        any,
        horizontal,
        vertical;

    }

    public static enum SWStatus {
        original,
        compatible;

    }

    public class SWList
    implements Serializable {
        public String name;
        public SWStatus status;
        public String filter;
    }
}

