/*
 * Decompiled with CFR 0.152.
 */
package jrm.io.chd;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import jrm.io.chd.CHDHeader;
import jrm.io.chd.CHDHeaderIntf;
import jrm.io.chd.CHDHeaderV1;
import jrm.io.chd.CHDHeaderV2;
import jrm.io.chd.CHDHeaderV3;
import jrm.io.chd.CHDHeaderV4;
import jrm.io.chd.CHDHeaderV5;

public class CHDInfoReader
implements CHDHeaderIntf {
    CHDHeaderIntf header;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CHDInfoReader(File chdfile) throws FileNotFoundException, IOException {
        try (FileInputStream is = new FileInputStream(chdfile);){
            MappedByteBuffer bb = is.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, Math.min(1024L, chdfile.length()));
            CHDHeader header = new CHDHeader(bb);
            this.header = header;
            if (!header.isValidTag()) return;
            switch (header.getVersion()) {
                case 1: {
                    this.header = new CHDHeaderV1(bb, header);
                    return;
                }
                case 2: {
                    this.header = new CHDHeaderV2(bb, header);
                    return;
                }
                case 3: {
                    this.header = new CHDHeaderV3(bb, header);
                    return;
                }
                case 4: {
                    this.header = new CHDHeaderV4(bb, header);
                    return;
                }
                case 5: {
                    this.header = new CHDHeaderV5(bb, header);
                    return;
                }
            }
            return;
        }
    }

    @Override
    public String getSHA1() {
        return this.header.getSHA1();
    }

    @Override
    public String getMD5() {
        return this.header.getMD5();
    }

    @Override
    public boolean isValidTag() {
        return this.header.isValidTag();
    }

    @Override
    public int getLen() {
        return this.header.getLen();
    }

    @Override
    public int getVersion() {
        return this.header.getVersion();
    }
}

