/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Board;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Game;
import megamek.common.HitData;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IStartingPositions;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.options.IOption;
import megamek.common.util.BoardUtilities;
import megamek.server.Server;

public class ScenarioLoader {
    private File m_scenFile;
    private Vector<DamagePlan> m_vDamagePlans = new Vector();
    private Vector<CritHitPlan> m_vCritHitPlans = new Vector();
    private Vector<SetAmmoPlan> m_vSetAmmoTo = new Vector();

    public ScenarioLoader(File file) {
        this.m_scenFile = file;
    }

    public void applyDamage(Server server) {
        CriticalSlot criticalSlot;
        Object object;
        int n;
        int n2;
        Object object2;
        int n3;
        int n4 = this.m_vDamagePlans.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = this.m_vDamagePlans.elementAt(n3);
            System.out.println("Applying damage to " + ((DamagePlan)object2).entity.getShortName());
            for (n2 = 0; n2 < ((DamagePlan)object2).nBlocks; ++n2) {
                HitData hitData = ((DamagePlan)object2).entity.rollHitLocation(0, 0);
                System.out.println("[s.damageEntity(dp.entity, hit, 5)]");
                server.damageEntity(((DamagePlan)object2).entity, hitData, 5);
            }
            n = ((DamagePlan)object2).specificDammage.size();
            for (n2 = 0; n2 < n; ++n2) {
                object = ((DamagePlan)object2).specificDammage.elementAt(n2);
                if (((DamagePlan)object2).entity.locations() <= ((SpecDam)object).loc) {
                    System.out.println("\tInvalid Location Specified " + ((SpecDam)object).loc);
                    continue;
                }
                if (((SpecDam)object).internal || ((DamagePlan)object2).entity instanceof Infantry && !(((DamagePlan)object2).entity instanceof BattleArmor)) {
                    if (((DamagePlan)object2).entity.getOInternal(((SpecDam)object).loc) <= ((SpecDam)object).setArmorTo) continue;
                    ((DamagePlan)object2).entity.setInternal(((SpecDam)object).setArmorTo, ((SpecDam)object).loc);
                    System.out.println("\tSet Armor Value for (Internal " + ((DamagePlan)object2).entity.getLocationName(((SpecDam)object).loc) + ") To " + ((SpecDam)object).setArmorTo);
                    if (((SpecDam)object).setArmorTo != 0) continue;
                    System.out.println("\tSection Destoyed " + ((DamagePlan)object2).entity.getLocationName(((SpecDam)object).loc));
                    ((DamagePlan)object2).entity.destroyLocation(((SpecDam)object).loc);
                    continue;
                }
                if (((SpecDam)object).rear && ((DamagePlan)object2).entity.hasRearArmor(((SpecDam)object).loc)) {
                    if (((DamagePlan)object2).entity.getOArmor(((SpecDam)object).loc, true) <= ((SpecDam)object).setArmorTo) continue;
                    System.out.println("\tSet Armor Value for (Rear " + ((DamagePlan)object2).entity.getLocationName(((SpecDam)object).loc) + ") To " + ((SpecDam)object).setArmorTo);
                    ((DamagePlan)object2).entity.setArmor(((SpecDam)object).setArmorTo, ((SpecDam)object).loc, true);
                    continue;
                }
                if (((DamagePlan)object2).entity.getOArmor(((SpecDam)object).loc, false) <= ((SpecDam)object).setArmorTo) continue;
                System.out.println("\tSet Armor Value for (" + ((DamagePlan)object2).entity.getLocationName(((SpecDam)object).loc) + ") To " + ((SpecDam)object).setArmorTo);
                if (((DamagePlan)object2).entity instanceof BattleArmor) {
                    if (((SpecDam)object).setArmorTo == 0) {
                        ((DamagePlan)object2).entity.setArmor(-2, ((SpecDam)object).loc, false);
                        ((DamagePlan)object2).entity.setInternal(-2, ((SpecDam)object).loc);
                        continue;
                    }
                    ((DamagePlan)object2).entity.setArmor(((SpecDam)object).setArmorTo - 1, ((SpecDam)object).loc);
                    continue;
                }
                ((DamagePlan)object2).entity.setArmor(((SpecDam)object).setArmorTo, ((SpecDam)object).loc);
            }
        }
        n4 = this.m_vCritHitPlans.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = this.m_vCritHitPlans.elementAt(n3);
            System.out.print("Applying Critical Hits to " + ((CritHitPlan)object2).entity.getShortName());
            n = ((CritHitPlan)object2).critHits.size();
            for (n2 = 0; n2 < n; ++n2) {
                object = ((CritHitPlan)object2).critHits.elementAt(n2);
                if (((CritHitPlan)object2).entity.locations() <= ((CritHit)object).loc) {
                    System.out.println("\n\tInvalid Location Specified " + ((CritHit)object).loc);
                    continue;
                }
                if (((CritHitPlan)object2).entity instanceof Mech || ((CritHitPlan)object2).entity instanceof Protomech) {
                    criticalSlot = null;
                    if (((CritHitPlan)object2).entity instanceof Protomech && 1 == ((CritHit)object).loc && (4 == ((CritHit)object).slot || 5 == ((CritHit)object).slot)) {
                        criticalSlot = new CriticalSlot(0, ((CritHit)object).slot);
                    } else if (((CritHit)object).slot < 0 || ((CritHit)object).slot > ((CritHitPlan)object2).entity.getNumberOfCriticals(((CritHit)object).loc)) {
                        System.out.println("\n\tInvalid Slot Specified " + ((CritHit)object).loc + ":" + (((CritHit)object).slot + 1));
                    } else {
                        criticalSlot = ((CritHitPlan)object2).entity.getCritical(((CritHit)object).loc, ((CritHit)object).slot);
                    }
                    if (null == criticalSlot || !criticalSlot.isHittable()) {
                        System.out.println("\n\tSlot not hittable " + ((CritHit)object).loc + ":" + (((CritHit)object).slot + 1));
                        continue;
                    }
                    System.out.print("[s.applyCriticalHit(chp.entity, ch.loc, cs, false)]");
                    server.applyCriticalHit(((CritHitPlan)object2).entity, ((CritHit)object).loc, criticalSlot, false);
                    continue;
                }
                if (!(((CritHitPlan)object2).entity instanceof Tank)) continue;
                if (((CritHit)object).slot < 0 || ((CritHit)object).slot >= 6) {
                    System.out.println("\n\tInvalid Slot Specified " + ((CritHit)object).loc + ":" + (((CritHit)object).slot + 1));
                    continue;
                }
                criticalSlot = new CriticalSlot(0, ((CritHit)object).slot + 1);
                System.out.print("[s.applyCriticalHit(chp.entity, ch.loc, cs, false)]");
                server.applyCriticalHit(((CritHitPlan)object2).entity, -1, criticalSlot, false);
            }
            System.out.println();
        }
        n4 = this.m_vSetAmmoTo.size();
        for (n3 = 0; n3 < n4; ++n3) {
            object2 = this.m_vSetAmmoTo.elementAt(n3);
            System.out.println("Applying Ammo Adjustment to " + ((SetAmmoPlan)object2).entity.getShortName());
            n = ((SetAmmoPlan)object2).ammoSetTo.size();
            for (n2 = 0; n2 < n; ++n2) {
                Mounted mounted;
                object = ((SetAmmoPlan)object2).ammoSetTo.elementAt(n2);
                if (!(((SetAmmoPlan)object2).entity instanceof Mech) || ((SetAmmoTo)object).slot >= ((SetAmmoPlan)object2).entity.getNumberOfCriticals(((SetAmmoTo)object).loc) || (criticalSlot = ((SetAmmoPlan)object2).entity.getCritical(((SetAmmoTo)object).loc, ((SetAmmoTo)object).slot)) == null || !((mounted = ((SetAmmoPlan)object2).entity.getEquipment(((SetAmmoPlan)object2).entity.getCritical(((SetAmmoTo)object).loc, ((SetAmmoTo)object).slot).getIndex())).getType() instanceof AmmoType)) continue;
                mounted.setShotsLeft(Math.min(((SetAmmoTo)object).setAmmoTo, mounted.getShotsLeft()));
            }
        }
    }

    public IGame createGame() throws Exception {
        int n;
        System.out.println("Loading scenario from " + this.m_scenFile);
        Properties properties = this.loadProperties();
        String string = properties.getProperty("MMSVersion");
        if (string == null) {
            throw new Exception("Not a valid MMS file.  No MMSVersion.");
        }
        Game game = new Game();
        game.board = this.createBoard(properties);
        Player[] playerArray = this.createPlayers(properties);
        for (n = 0; n < playerArray.length; ++n) {
            game.addPlayer(n, playerArray[n]);
        }
        n = 0;
        for (int i = 0; i < playerArray.length; ++i) {
            Entity[] entityArray = this.buildFactionEntities(properties, playerArray[i]);
            for (int j = 0; j < entityArray.length; ++j) {
                entityArray[j].setOwner(playerArray[i]);
                entityArray[j].setId(n++);
                game.addEntity(entityArray[j].getId(), entityArray[j]);
            }
        }
        game.getOptions().initialize();
        String string2 = properties.getProperty("GameOptionsFile");
        if (string2 == null) {
            game.getOptions().loadOptions();
        } else {
            game.getOptions().loadOptions(new File(this.m_scenFile.getParentFile(), string2));
        }
        game.getPlanetaryConditions().determineWind();
        game.setupTeams();
        game.setPhase(IGame.Phase.PHASE_STARTING_SCENARIO);
        game.setupRoundDeployment();
        game.setExternalGameId(this.parseExternalGameId(properties));
        game.setVictoryContext(new HashMap<String, Object>());
        game.createVictoryConditions();
        return game;
    }

    private Entity[] buildFactionEntities(Properties properties, Player player) throws Exception {
        String string = player.getName();
        Vector<Object[]> vector = new Vector<Object[]>();
        int n = 1;
        while (true) {
            int n2;
            Object[] objectArray;
            String string2;
            if ((string2 = properties.getProperty("Unit_" + string + "_" + n)) == null) {
                objectArray = new Entity[vector.size()];
                vector.copyInto(objectArray);
                return objectArray;
            }
            objectArray = this.parseEntityLine(string2);
            boolean bl = false;
            DamagePlan damagePlan = new DamagePlan((Entity)objectArray);
            string2 = properties.getProperty("Unit_" + string + "_" + n + "_Damage");
            if (string2 != null) {
                n2 = Integer.parseInt(string2);
                this.m_vDamagePlans.addElement(new DamagePlan((Entity)objectArray, n2));
            }
            if ((string2 = properties.getProperty("Unit_" + string + "_" + n + "_DamageSpecific")) != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    damagePlan.AddSpecificDammage(stringTokenizer.nextToken());
                }
                bl = true;
            }
            n2 = 0;
            string2 = properties.getProperty("Unit_" + string + "_" + n + "_CritHit");
            CritHitPlan critHitPlan = new CritHitPlan((Entity)objectArray);
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    critHitPlan.AddCritHit(stringTokenizer.nextToken());
                }
                n2 = 1;
            }
            boolean bl2 = false;
            string2 = properties.getProperty("Unit_" + string + "_" + n + "_SetAmmoTo");
            SetAmmoPlan setAmmoPlan = new SetAmmoPlan((Entity)objectArray);
            if (string2 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    setAmmoPlan.AddSetAmmoTo(stringTokenizer.nextToken());
                }
                bl2 = true;
            }
            if (n2 != 0) {
                this.m_vCritHitPlans.addElement(critHitPlan);
            }
            if (bl) {
                this.m_vDamagePlans.addElement(damagePlan);
            }
            if (bl2) {
                this.m_vSetAmmoTo.addElement(setAmmoPlan);
            }
            if (null != (string2 = properties.getProperty("Unit_" + string + "_" + n + "_PilotHits"))) {
                int n3 = Integer.parseInt(string2);
                if (n3 > 5) {
                    n3 = 0;
                }
                objectArray.crew.setHits(n3);
            }
            if (null != (string2 = properties.getProperty("Unit_" + string + "_" + n + "_ExternalID"))) {
                objectArray.setExternalId(Integer.parseInt(string2));
            }
            if (null != (string2 = properties.getProperty("Unit_" + string + "_" + n + "_Advantages"))) {
                this.parseAdvantages((Entity)objectArray, string2);
            }
            if (null != (string2 = properties.getProperty("Unit_" + string + "_" + n + "_AutoEject"))) {
                this.parseAutoEject((Entity)objectArray, string2);
            }
            if (null != (string2 = properties.getProperty("Unit_" + string + "_" + n + "_Commander"))) {
                this.parseCommander((Entity)objectArray, string2);
            }
            if (null != (string2 = properties.getProperty("Unit_" + string + "_" + n + "_DeploymentRound"))) {
                int n4 = 0;
                try {
                    n4 = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    throw new Exception("Bad deployment round setting (" + string2 + ") for unit " + string + ":" + n);
                }
                if (n4 < 0) {
                    System.out.println("Deployment round setting of '" + n4 + "' for " + string + ":" + n + " will be ignored and set to 0");
                    n4 = 0;
                }
                if (n4 > 0) {
                    if (player.getStartingPos() == 0) {
                        throw new Exception("Can not combine a starting position of 'any' with delayed deployment.");
                    }
                    System.out.println(objectArray.getDisplayName() + " will be deployed before round " + n4);
                    objectArray.setDeployRound(n4);
                }
            }
            vector.addElement(objectArray);
            ++n;
        }
    }

    private Entity parseEntityLine(String string) throws Exception {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            MechSummary mechSummary = MechSummaryCache.getInstance().getMech(string2);
            if (mechSummary == null) {
                throw new Exception("Scenario requires missing entity: " + string2);
            }
            System.out.println("Loading " + mechSummary.getName());
            Entity entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
            entity.setCrew(new Pilot(stringTokenizer.nextToken(), Integer.parseInt(stringTokenizer.nextToken()), Integer.parseInt(stringTokenizer.nextToken())));
            try {
                String string3 = stringTokenizer.nextToken();
                if (string3.equalsIgnoreCase("N")) {
                    entity.setFacing(0);
                } else if (string3.equalsIgnoreCase("NW")) {
                    entity.setFacing(5);
                } else if (string3.equalsIgnoreCase("SW")) {
                    entity.setFacing(4);
                } else if (string3.equalsIgnoreCase("S")) {
                    entity.setFacing(3);
                } else if (string3.equalsIgnoreCase("SE")) {
                    entity.setFacing(2);
                } else if (string3.equalsIgnoreCase("NE")) {
                    entity.setFacing(1);
                }
                int n = Integer.parseInt(stringTokenizer.nextToken()) - 1;
                int n2 = Integer.parseInt(stringTokenizer.nextToken()) - 1;
                Coords coords = new Coords(n, n2);
                entity.setPosition(coords);
                entity.setDeployed(true);
            }
            catch (NoSuchElementException noSuchElementException) {
                // empty catch block
            }
            return entity;
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            throw new Exception("Unparseable entity line: " + string);
        }
        catch (NoSuchElementException noSuchElementException) {
            noSuchElementException.printStackTrace();
            throw new Exception("Unparseable entity line: " + string);
        }
        catch (EntityLoadingException entityLoadingException) {
            entityLoadingException.printStackTrace();
            throw new Exception("Unparseable entity line: " + string + "\n   Unable to load mech: " + entityLoadingException.getMessage());
        }
    }

    private void parseAdvantages(Entity entity, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            IOption iOption = entity.getCrew().getOptions().getOption(string2);
            if (null == iOption) {
                System.out.println("Ignoring invalid pilot advantage: " + string2);
                continue;
            }
            System.out.println("Adding pilot advantage '" + string2 + "' to " + entity.getDisplayName());
            iOption.setValue(true);
        }
    }

    private void parseAutoEject(Entity entity, String string) {
        if (entity instanceof Mech) {
            Mech mech = (Mech)entity;
            mech.setAutoEject(Boolean.valueOf(string));
        }
    }

    private void parseCommander(Entity entity, String string) {
        entity.setCommander(Boolean.valueOf(string));
    }

    private int findIndex(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    private Player[] createPlayers(Properties properties) throws Exception {
        String string = properties.getProperty("Factions");
        if (string == null) {
            throw new Exception("Not a valid MMS file.  No Factions");
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Player[] playerArray = new Player[stringTokenizer.countTokens()];
        for (int i = 0; i < playerArray.length; ++i) {
            int n;
            playerArray[i] = new Player(i, stringTokenizer.nextToken());
            playerArray[i].setGhost(true);
            String string2 = properties.getProperty("Location_" + playerArray[i].getName());
            if (string2 == null) {
                string2 = "Any";
            }
            if ((n = this.findIndex(IStartingPositions.START_LOCATION_NAMES, string2)) == -1) {
                n = 0;
            }
            playerArray[i].setStartingPos(n);
            int n2 = 0;
            try {
                n2 = Integer.parseInt(properties.getProperty("Team_" + playerArray[i].getName()));
            }
            catch (Exception exception) {
                n2 = 0;
            }
            playerArray[i].setTeam(n2);
            String string3 = properties.getProperty("Minefields_" + playerArray[i].getName());
            if (string3 == null) continue;
            try {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string3, ",");
                playerArray[i].setNbrMFConventional(Integer.parseInt(stringTokenizer2.nextToken()));
                playerArray[i].setNbrMFCommand(Integer.parseInt(stringTokenizer2.nextToken()));
                playerArray[i].setNbrMFVibra(Integer.parseInt(stringTokenizer2.nextToken()));
                continue;
            }
            catch (Exception exception) {
                playerArray[i].setNbrMFConventional(0);
                playerArray[i].setNbrMFCommand(0);
                playerArray[i].setNbrMFVibra(0);
                System.err.println("Something wrong with " + playerArray[i].getName() + "s minefields.");
            }
        }
        return playerArray;
    }

    private IBoard createBoard(Properties properties) throws Exception {
        int n = 16;
        int n2 = 17;
        if (properties.getProperty("MapWidth") == null) {
            System.out.println("No map width specified.  Using " + n);
        } else {
            n = Integer.parseInt(properties.getProperty("MapWidth"));
        }
        if (properties.getProperty("MapHeight") == null) {
            System.out.println("No map height specified.  Using " + n2);
        } else {
            n2 = Integer.parseInt(properties.getProperty("MapHeight"));
        }
        int n3 = 1;
        int n4 = 1;
        if (properties.getProperty("BoardWidth") == null) {
            System.out.println("No board width specified.  Using " + n3);
        } else {
            n3 = Integer.parseInt(properties.getProperty("BoardWidth"));
        }
        if (properties.getProperty("BoardHeight") == null) {
            System.out.println("No board height specified.  Using " + n4);
        } else {
            n4 = Integer.parseInt(properties.getProperty("BoardHeight"));
        }
        System.out.println("Mapsheets are " + n + " by " + n2 + " hexes.");
        System.out.println("Constructing " + n3 + " by " + n4 + " board.");
        int n5 = 0;
        if (properties.getProperty("BridgeCF") == null) {
            System.out.println("No CF for bridges defined. Using map file defaults.");
        } else {
            n5 = Integer.parseInt(properties.getProperty("BridgeCF"));
            System.out.println("Overriding map-defined bridge CFs with " + n5 + ".");
        }
        Vector<String> vector = new Vector<String>();
        File file = new File("data/boards");
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".board")) continue;
            vector.addElement(stringArray[i].substring(0, stringArray[i].lastIndexOf(".board")));
        }
        IBoard[] iBoardArray = new IBoard[n3 * n4];
        StringTokenizer stringTokenizer = new StringTokenizer(properties.getProperty("Maps"), ",");
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                String string;
                File file2;
                int n6 = j * n3 + i;
                String string2 = "RANDOM";
                if (stringTokenizer.hasMoreTokens()) {
                    string2 = stringTokenizer.nextToken();
                }
                System.out.println("(" + i + "," + j + ")" + string2);
                boolean bl = false;
                if (string2.startsWith("rotate:")) {
                    bl = true;
                    string2 = string2.substring("rotate:".length());
                }
                if (!(file2 = new File(file, string = string2.equals("RANDOM") ? (String)vector.elementAt(Compute.randomInt(vector.size())) + ".board" : string2 + ".board")).exists()) {
                    throw new Exception("Scenario requires nonexistant board: " + string2);
                }
                iBoardArray[n6] = new Board();
                iBoardArray[n6].load(string);
                if (n5 > 0) {
                    iBoardArray[n6].setBridgeCF(n5);
                }
                BoardUtilities.flip(iBoardArray[n6], bl, bl);
            }
        }
        if (iBoardArray.length == 1) {
            return iBoardArray[0];
        }
        return BoardUtilities.combine(n, n2, n3, n4, iBoardArray, 0);
    }

    private Properties loadProperties() throws Exception {
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(this.m_scenFile);
        properties.load(fileInputStream);
        fileInputStream.close();
        Properties properties2 = new Properties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            String string = enumeration.nextElement().toString();
            StringBuffer stringBuffer = new StringBuffer(properties.getProperty(string));
            for (n = stringBuffer.length() - 1; n >= 0 && Character.isWhitespace(stringBuffer.charAt(n)); --n) {
            }
            stringBuffer.setLength(n + 1);
            properties2.setProperty(string, stringBuffer.toString());
        }
        return properties2;
    }

    public static void main(String[] stringArray) throws Exception {
        ScenarioLoader scenarioLoader = new ScenarioLoader(new File(stringArray[0]));
        IGame iGame = scenarioLoader.createGame();
        if (iGame != null) {
            System.out.println("Successfully loaded.");
        }
    }

    private int parseExternalGameId(Properties properties) {
        String string = properties.getProperty("ExternalId");
        int n = 0;
        if (string != null) {
            n = Integer.parseInt(string);
        }
        return n;
    }

    class DamagePlan {
        public Entity entity;
        public int nBlocks;
        Vector<SpecDam> specificDammage = new Vector();
        Vector<SetAmmoTo> ammoSetTo = new Vector();

        public DamagePlan(Entity entity, int n) {
            this.entity = entity;
            this.nBlocks = n;
        }

        public DamagePlan(Entity entity) {
            this.entity = entity;
            this.nBlocks = 0;
        }

        public void AddSpecificDammage(String string) {
            int n = 0;
            int n2 = 0;
            boolean bl = false;
            boolean bl2 = false;
            if (string.substring(0, 1).equals("R")) {
                bl = true;
            }
            if (string.substring(0, 1).equals("I")) {
                bl2 = true;
            }
            int n3 = string.indexOf(":");
            n = Integer.parseInt(string.substring(1, n3));
            n2 = Integer.parseInt(string.substring(n3 + 1));
            this.specificDammage.addElement(new SpecDam(n, n2, bl, bl2));
        }
    }

    public class SpecDam {
        public int loc;
        public int setArmorTo;
        public boolean rear;
        public boolean internal;

        public SpecDam(int n, int n2, boolean bl, boolean bl2) {
            this.loc = n;
            this.setArmorTo = n2;
            this.rear = bl;
            this.internal = bl2;
        }
    }

    class SetAmmoPlan {
        public Entity entity;
        Vector<SetAmmoTo> ammoSetTo = new Vector();

        public SetAmmoPlan(Entity entity) {
            this.entity = entity;
        }

        public void AddSetAmmoTo(String string) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = string.indexOf(":");
            int n5 = string.indexOf("-");
            n = Integer.parseInt(string.substring(0, n4));
            n2 = Integer.parseInt(string.substring(n4 + 1, n5));
            n3 = Integer.parseInt(string.substring(n5 + 1));
            this.ammoSetTo.addElement(new SetAmmoTo(n, n2, n3));
        }
    }

    public class SetAmmoTo {
        public int loc;
        public int slot;
        public int setAmmoTo;

        public SetAmmoTo(int n, int n2, int n3) {
            this.loc = n;
            this.slot = n2;
            this.setAmmoTo = n3;
        }
    }

    class CritHitPlan {
        public Entity entity;
        Vector<CritHit> critHits = new Vector();

        public CritHitPlan(Entity entity) {
            this.entity = entity;
        }

        public void AddCritHit(String string) {
            int n = string.indexOf(":");
            int n2 = Integer.parseInt(string.substring(0, n));
            int n3 = Integer.parseInt(string.substring(n + 1));
            this.critHits.addElement(new CritHit(n2, n3 - 1));
        }
    }

    public class CritHit {
        public int loc;
        public int slot;

        public CritHit(int n, int n2) {
            this.loc = n;
            this.slot = n2;
        }
    }
}

