/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import megamek.common.Mounted;

public class CriticalSlot
implements Serializable {
    private static final long serialVersionUID = -8744251501251495923L;
    public static final int TYPE_SYSTEM = 0;
    public static final int TYPE_EQUIPMENT = 1;
    private int type;
    private int index;
    private Mounted mount;
    private boolean hit;
    private boolean missing;
    private boolean destroyed;
    private boolean hittable;
    private boolean breached;
    private boolean repairing = false;
    private boolean armored = false;

    public CriticalSlot(int n, int n2) {
        this(n, n2, true, null);
    }

    public CriticalSlot(int n, int n2, boolean bl, Mounted mounted) {
        this(n, n2, bl, mounted != null ? mounted.isArmored() : false, mounted);
    }

    public CriticalSlot(int n, int n2, boolean bl, boolean bl2, Mounted mounted) {
        this.type = n;
        this.index = n2;
        this.hittable = bl;
        if (bl) {
            this.armored = bl2;
        }
        this.mount = mounted;
    }

    public CriticalSlot(int n, Mounted mounted) {
        this(n, mounted, true);
    }

    public CriticalSlot(int n, Mounted mounted, boolean bl) {
        this.type = n;
        this.index = -1;
        this.hittable = bl;
        this.setMount(mounted);
    }

    public int getType() {
        return this.type;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public boolean isHit() {
        return this.hit;
    }

    public void setHit(boolean bl) {
        this.hit = bl;
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public void setMissing(boolean bl) {
        this.missing = bl;
    }

    public boolean isBreached() {
        return this.breached;
    }

    public void setBreached(boolean bl) {
        this.breached = bl;
    }

    public boolean isDamaged() {
        return this.hit || this.missing || this.destroyed;
    }

    public boolean isHittable() {
        return this.hittable && !this.hit && !this.destroyed;
    }

    public boolean isEverHittable() {
        return this.hittable;
    }

    public boolean isRepairing() {
        return this.repairing;
    }

    public void setRepairing(boolean bl) {
        this.repairing = bl;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CriticalSlot criticalSlot = (CriticalSlot)object;
        return criticalSlot.getType() == this.type && criticalSlot.getIndex() == this.index;
    }

    public void setMount(Mounted mounted) {
        this.mount = mounted;
    }

    public Mounted getMount() {
        return this.mount;
    }

    public void setArmored(boolean bl) {
        this.armored = bl;
    }

    public boolean isArmored() {
        return this.armored;
    }
}

