/*
 * Decompiled with CFR 0.152.
 */
package gd.xml.tiny;

import gd.xml.tiny.ParsedXML;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class ParseNode
implements ParsedXML {
    static final int ROOT = 0;
    static final int TAG = 1;
    static final int DOCTYPE = 2;
    static final int CHARDATA = 4;
    static final int CDSECTION = 8;
    static final int PI = 16;
    static final int COMMENT = 32;
    private static final Vector emptyvec = new Vector();
    private static final Hashtable emptyhash = new Hashtable();
    private int type;
    private String name = null;
    private Hashtable attributes = emptyhash;
    private Vector elements = emptyvec;
    private String content = null;

    ParseNode(int n) {
        this.type = n;
    }

    void addNode(ParseNode parseNode) {
        if (this.elements == emptyvec) {
            this.elements = new Vector();
        }
        this.elements.addElement(parseNode);
    }

    public Enumeration attributes() {
        return this.attributes.keys();
    }

    public Enumeration elements() {
        return this.elements.elements();
    }

    Enumeration elements(int n) {
        Vector<ParseNode> vector = new Vector<ParseNode>();
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            ParseNode parseNode = (ParseNode)enumeration.nextElement();
            if ((n | parseNode.getType()) == 0) continue;
            vector.addElement(parseNode);
        }
        return vector.elements();
    }

    public String getAttribute(String string) {
        return (String)this.attributes.get(string);
    }

    public String getContent() {
        return this.content;
    }

    public String getName() {
        return this.name;
    }

    int getType() {
        return this.type;
    }

    public String getTypeName() {
        switch (this.type) {
            case 0: {
                return "root";
            }
            case 1: {
                return "tag";
            }
            case 2: {
                return "dtd";
            }
            case 4: {
                return "text";
            }
            case 8: {
                return "cdata";
            }
            case 16: {
                return "pi";
            }
            case 32: {
                return "comment";
            }
        }
        return "unknown";
    }

    public boolean isEmpty() {
        return this.elements.size() == 0;
    }

    void setAttributes(Hashtable hashtable) {
        this.attributes = hashtable == null ? emptyhash : hashtable;
    }

    void setContent(String string) {
        this.content = string;
    }

    void setName(String string) {
        this.name = string;
    }
}

