from __future__ import absolute_import, division, print_function

import pandas as pd

import xarray as xr

from . import randn, requires_dask

try:
    import dask  # noqa
except ImportError:
    pass


def make_bench_data(shape, frac_nan, chunks):
    vals = randn(shape, frac_nan)
    coords = {'time': pd.date_range('2000-01-01', freq='D',
                                    periods=shape[0])}
    da = xr.DataArray(vals, dims=('time', 'x', 'y'), coords=coords)

    if chunks is not None:
        da = da.chunk(chunks)

    return da


def time_interpolate_na(shape, chunks, method, limit):
    if chunks is not None:
        requires_dask()
    da = make_bench_data(shape, 0.1, chunks=chunks)
    actual = da.interpolate_na(dim='time', method='linear', limit=limit)

    if chunks is not None:
        actual = actual.compute()


time_interpolate_na.param_names = ['shape', 'chunks', 'method', 'limit']
time_interpolate_na.params = ([(3650, 200, 400), (100, 25, 25)],
                              [None, {'x': 25, 'y': 25}],
                              ['linear', 'spline', 'quadratic', 'cubic'],
                              [None, 3])


def time_ffill(shape, chunks, limit):

    da = make_bench_data(shape, 0.1, chunks=chunks)
    actual = da.ffill(dim='time', limit=limit)

    if chunks is not None:
        actual = actual.compute()


time_ffill.param_names = ['shape', 'chunks', 'limit']
time_ffill.params = ([(3650, 200, 400), (100, 25, 25)],
                     [None, {'x': 25, 'y': 25}],
                     [None, 3])


def time_bfill(shape, chunks, limit):

    da = make_bench_data(shape, 0.1, chunks=chunks)
    actual = da.bfill(dim='time', limit=limit)

    if chunks is not None:
        actual = actual.compute()


time_bfill.param_names = ['shape', 'chunks', 'limit']
time_bfill.params = ([(3650, 200, 400), (100, 25, 25)],
                     [None, {'x': 25, 'y': 25}],
                     [None, 3])
