# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class Address(Model):
    """Address information for domain registration.

    All required parameters must be populated in order to send to Azure.

    :param address1: Required. First line of an Address.
    :type address1: str
    :param address2: The second line of the Address. Optional.
    :type address2: str
    :param city: Required. The city for the address.
    :type city: str
    :param country: Required. The country for the address.
    :type country: str
    :param postal_code: Required. The postal code for the address.
    :type postal_code: str
    :param state: Required. The state or province for the address.
    :type state: str
    """

    _validation = {
        'address1': {'required': True},
        'city': {'required': True},
        'country': {'required': True},
        'postal_code': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'address1': {'key': 'address1', 'type': 'str'},
        'address2': {'key': 'address2', 'type': 'str'},
        'city': {'key': 'city', 'type': 'str'},
        'country': {'key': 'country', 'type': 'str'},
        'postal_code': {'key': 'postalCode', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Address, self).__init__(**kwargs)
        self.address1 = kwargs.get('address1', None)
        self.address2 = kwargs.get('address2', None)
        self.city = kwargs.get('city', None)
        self.country = kwargs.get('country', None)
        self.postal_code = kwargs.get('postal_code', None)
        self.state = kwargs.get('state', None)
