/*
 * Decompiled with CFR 0.152.
 */
package gr.zeus.ui.table;

import java.awt.Color;
import java.awt.Component;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

public final class ProgressBarCellRenderer
extends JProgressBar
implements TableCellRenderer {
    private Hashtable m_limitColors;
    private int[] m_limitValues;

    public ProgressBarCellRenderer() {
        this(false, true, 0, 100, new Hashtable(), Color.WHITE);
    }

    public ProgressBarCellRenderer(boolean paintNum, boolean paintBorder, int min, int max, Hashtable limitColors, Color bg) {
        super(0, min, max);
        this.setStringPainted(paintNum);
        this.setBorderPainted(paintBorder);
        this.setBackground(bg);
        this.setLimits(limitColors);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color color;
        int n = 0;
        if (!(value instanceof Number)) {
            String str = value instanceof String ? (String)value : value.toString();
            try {
                n = Integer.valueOf(str);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        } else {
            n = ((Number)value).intValue();
        }
        if ((color = this.getColor(n)) != null) {
            this.setForeground(color);
        }
        this.setValue(n);
        return this;
    }

    public void setLimits(Hashtable limitColors) {
        this.m_limitColors = limitColors;
        if (this.m_limitColors != null) {
            int i = 0;
            int n = this.m_limitColors.size();
            this.m_limitValues = new int[n];
            Enumeration e = this.m_limitColors.keys();
            while (e.hasMoreElements()) {
                this.m_limitValues[i++] = (Integer)e.nextElement();
            }
            ProgressBarCellRenderer.sort(this.m_limitValues);
        }
    }

    private Color getColor(int value) {
        Color color = null;
        if (this.m_limitValues != null) {
            for (int i = 0; i < this.m_limitValues.length; ++i) {
                if (this.m_limitValues[i] >= value) continue;
                color = (Color)this.m_limitColors.get(new Integer(this.m_limitValues[i]));
            }
        }
        return color;
    }

    private static void sort(int[] a) {
        int n = a.length;
        for (int i = 0; i < n - 1; ++i) {
            int k = i;
            for (int j = i + 1; j < n; ++j) {
                if (a[j] >= a[k]) continue;
                k = j;
            }
            int tmp = a[i];
            a[i] = a[k];
            a[k] = tmp;
        }
    }
}

