/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.cojen.classfile.AbstractCodeAssembler;
import org.cojen.classfile.CodeAssembler;
import org.cojen.classfile.Label;
import org.cojen.classfile.LocalVariable;
import org.cojen.classfile.Location;
import org.cojen.classfile.Opcode;
import org.cojen.classfile.TypeDesc;

public class CodeAssemblerPrinter
extends AbstractCodeAssembler
implements CodeAssembler {
    private final LocalVariable[] mParams;
    private final boolean mIsStatic;
    private final PrintWriter mWriter;
    private final String mLinePrefix;
    private final String mLineSuffix;
    private final String mBulder;
    private boolean mNeedSeparatorLine;
    private int mLocalCounter;
    private int mLabelCounter;
    private int mTypeDescCounter;
    private Map mTypeDescNames;
    private int mTypeDescArrayCounter;
    private Map mTypeDescArrayNames;

    public CodeAssemblerPrinter(TypeDesc[] paramTypes, boolean isStatic, PrintWriter writer) {
        this(paramTypes, isStatic, writer, null, null, null);
    }

    public CodeAssemblerPrinter(TypeDesc[] paramTypes, boolean isStatic, PrintWriter writer, String linePrefix, String lineSuffix, String builder) {
        this.mIsStatic = isStatic;
        this.mWriter = writer;
        this.mLinePrefix = linePrefix;
        this.mLineSuffix = lineSuffix;
        if (builder == null || builder.length() == 0) {
            builder = "";
        } else if (!builder.endsWith(".")) {
            builder = builder + '.';
        }
        this.mBulder = builder;
        this.mTypeDescNames = new HashMap();
        this.mTypeDescArrayNames = new HashMap();
        this.mParams = new LocalVariable[paramTypes.length];
        int varNum = isStatic ? 0 : 1;
        for (int i = 0; i < paramTypes.length; ++i) {
            String varName = "var_" + ++this.mLocalCounter;
            this.println("LocalVariable " + varName + " = " + this.mBulder + "getParameter(" + i + ')');
            NamedLocal localVar = new NamedLocal(varName, paramTypes[i], varNum);
            varNum += localVar.isDoubleWord() ? 2 : 1;
            this.mParams[i] = localVar;
        }
    }

    public int getParameterCount() {
        return this.mParams.length;
    }

    public LocalVariable getParameter(int index) {
        return this.mParams[index];
    }

    public LocalVariable createLocalVariable(String name, TypeDesc type) {
        String varName = "var_" + ++this.mLocalCounter;
        if (name != null) {
            name = '\"' + name + '\"';
        }
        this.println("LocalVariable " + varName + " = " + this.mBulder + "createLocalVariable(" + name + ", " + this.getTypeDescName(type) + ')');
        return new NamedLocal(varName, type, -1);
    }

    public Label createLabel() {
        String name = "label_" + ++this.mLabelCounter;
        this.println("Label " + name + " = " + this.mBulder + "createLabel()");
        return new NamedLabel(name);
    }

    public void exceptionHandler(Location startLocation, Location endLocation, String catchClassName) {
        this.println(this.mBulder + "exceptionHandler(" + this.getLabelName(startLocation) + ", " + this.getLabelName(endLocation) + ", " + (catchClassName == null ? "null" : '\"' + catchClassName + '\"') + ')');
    }

    public void mapLineNumber(int lineNumber) {
        this.separatorLine();
        this.println(this.mBulder + "mapLineNumber(" + lineNumber + ')');
    }

    public void loadNull() {
        this.println(this.mBulder + "loadNull()");
    }

    public void loadConstant(String value) {
        if (value == null) {
            this.loadNull();
        } else {
            this.println(this.mBulder + "loadConstant(\"" + CodeAssemblerPrinter.escape(value) + "\")");
        }
    }

    public void loadConstant(TypeDesc type) {
        if (type == null) {
            this.loadNull();
        } else {
            this.println(this.mBulder + "loadConstant(" + this.getTypeDescName(type) + ')');
        }
    }

    public void loadConstant(boolean value) {
        this.println(this.mBulder + "loadConstant(" + value + ')');
    }

    public void loadConstant(int value) {
        this.println(this.mBulder + "loadConstant(" + value + ')');
    }

    public void loadConstant(long value) {
        this.println(this.mBulder + "loadConstant(" + value + "L)");
    }

    public void loadConstant(float value) {
        String str = value != value ? "0.0f/0.0f" : (value == Float.NEGATIVE_INFINITY ? "-1.0f/0.0f" : (value == Float.POSITIVE_INFINITY ? "1.0f/0.0f" : String.valueOf(value) + 'f'));
        this.println(this.mBulder + "loadConstant(" + str + ")");
    }

    public void loadConstant(double value) {
        String str = value != value ? "0.0d/0.0d" : (value == Double.NEGATIVE_INFINITY ? "-1.0d/0.0d" : (value == Double.POSITIVE_INFINITY ? "1.0d/0.0d" : String.valueOf(value) + 'd'));
        this.println(this.mBulder + "loadConstant(" + str + ")");
    }

    public void loadLocal(LocalVariable local) {
        this.println(this.mBulder + "loadLocal(" + local.getName() + ')');
    }

    public void loadThis() {
        this.println(this.mBulder + "loadThis()");
    }

    public void storeLocal(LocalVariable local) {
        this.println(this.mBulder + "storeLocal(" + local.getName() + ')');
    }

    public void loadFromArray(TypeDesc type) {
        this.println(this.mBulder + "loadFromArray(" + this.getTypeDescName(type) + ')');
    }

    public void storeToArray(TypeDesc type) {
        this.println(this.mBulder + "storeToArray(" + this.getTypeDescName(type) + ')');
    }

    public void loadField(String fieldName, TypeDesc type) {
        this.println(this.mBulder + "loadField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void loadField(String className, String fieldName, TypeDesc type) {
        this.println(this.mBulder + "loadField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void loadField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.println(this.mBulder + "loadField(\"" + this.getTypeDescName(classDesc) + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void loadStaticField(String fieldName, TypeDesc type) {
        this.println(this.mBulder + "loadStaticField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void loadStaticField(String className, String fieldName, TypeDesc type) {
        this.println(this.mBulder + "loadStaticField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void loadStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.println(this.mBulder + "loadStaticField(\"" + this.getTypeDescName(classDesc) + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void storeField(String fieldName, TypeDesc type) {
        this.println(this.mBulder + "storeField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void storeField(String className, String fieldName, TypeDesc type) {
        this.println(this.mBulder + "storeField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void storeField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.println(this.mBulder + "storeField(\"" + this.getTypeDescName(classDesc) + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void storeStaticField(String fieldName, TypeDesc type) {
        this.println(this.mBulder + "storeStaticField(\"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void storeStaticField(String className, String fieldName, TypeDesc type) {
        this.println(this.mBulder + "storeStaticField(\"" + className + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void storeStaticField(TypeDesc classDesc, String fieldName, TypeDesc type) {
        this.println(this.mBulder + "storeStaticField(\"" + this.getTypeDescName(classDesc) + "\", \"" + fieldName + "\", " + this.getTypeDescName(type) + ')');
    }

    public void returnVoid() {
        this.println(this.mBulder + "returnVoid()");
    }

    public void returnValue(TypeDesc type) {
        this.println(this.mBulder + "returnValue(" + this.getTypeDescName(type) + ')');
    }

    public void convert(TypeDesc fromType, TypeDesc toType) {
        this.println(this.mBulder + "convert(" + this.getTypeDescName(fromType) + ", " + this.getTypeDescName(toType) + ')');
    }

    public void convert(TypeDesc fromType, TypeDesc toType, int fpConvertMode) {
        switch (fpConvertMode) {
            default: {
                this.convert(fromType, toType);
                break;
            }
            case 1: {
                this.println(this.mBulder + "convert(" + this.getTypeDescName(fromType) + ", " + this.getTypeDescName(toType) + ", " + this.mBulder + ".CONVERT_FP_BITS" + ')');
                break;
            }
            case 2: {
                this.println(this.mBulder + "convert(" + this.getTypeDescName(fromType) + ", " + this.getTypeDescName(toType) + ", " + this.mBulder + ".CONVERT_FP_RAW_BITS" + ')');
            }
        }
    }

    public void invokeVirtual(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokeVirtual(\"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeVirtual(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokeVirtual(\"" + className + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeVirtual(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokeVirtual(\"" + this.getTypeDescName(classDesc) + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeStatic(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokeStatic(\"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeStatic(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokeStatic(\"" + className + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeStatic(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokeStatic(\"" + this.getTypeDescName(classDesc) + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeInterface(String className, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokeInterface(\"" + className + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeInterface(TypeDesc classDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokeInterface(\"" + this.getTypeDescName(classDesc) + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokePrivate(String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokePrivate(\"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeSuper(String superClassName, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokeSuper(\"" + superClassName + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeSuper(TypeDesc superClassDesc, String methodName, TypeDesc ret, TypeDesc[] params) {
        this.println(this.mBulder + "invokeSuper(\"" + this.getTypeDescName(superClassDesc) + "\", \"" + methodName + "\", " + this.getTypeDescName(ret) + ", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeConstructor(TypeDesc[] params) {
        this.println(this.mBulder + "invokeConstructor(" + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeConstructor(String className, TypeDesc[] params) {
        this.println(this.mBulder + "invokeConstructor(\"" + className + "\", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeConstructor(TypeDesc classDesc, TypeDesc[] params) {
        this.println(this.mBulder + "invokeConstructor(\"" + this.getTypeDescName(classDesc) + "\", " + this.getTypeDescArrayName(params) + ')');
    }

    public void invokeSuperConstructor(TypeDesc[] params) {
        this.println(this.mBulder + "invokeSuperConstructor(" + this.getTypeDescArrayName(params) + ')');
    }

    public void newObject(TypeDesc type) {
        this.println(this.mBulder + "newObject(" + this.getTypeDescName(type) + ')');
    }

    public void newObject(TypeDesc type, int dimensions) {
        if (dimensions == 0 && !type.isArray()) {
            this.newObject(type);
        } else {
            this.println(this.mBulder + "newObject(" + this.getTypeDescName(type) + ", " + dimensions + ')');
        }
    }

    public void dup() {
        this.println(this.mBulder + "dup()");
    }

    public void dupX1() {
        this.println(this.mBulder + "dupX1()");
    }

    public void dupX2() {
        this.println(this.mBulder + "dupX2()");
    }

    public void dup2() {
        this.println(this.mBulder + "dup2()");
    }

    public void dup2X1() {
        this.println(this.mBulder + "dup2X1()");
    }

    public void dup2X2() {
        this.println(this.mBulder + "dup2X2()");
    }

    public void pop() {
        this.println(this.mBulder + "pop()");
    }

    public void pop2() {
        this.println(this.mBulder + "pop2()");
    }

    public void swap() {
        this.println(this.mBulder + "swap()");
    }

    public void swap2() {
        this.println(this.mBulder + "swap2()");
    }

    public void branch(Location location) {
        this.println(this.mBulder + "branch(" + this.getLabelName(location) + ')');
    }

    public void ifNullBranch(Location location, boolean choice) {
        this.println(this.mBulder + "ifNullBranch(" + this.getLabelName(location) + ", " + choice + ')');
    }

    public void ifEqualBranch(Location location, boolean choice) {
        this.println(this.mBulder + "ifEqualBranch(" + this.getLabelName(location) + ", " + choice + ')');
    }

    public void ifZeroComparisonBranch(Location location, String choice) {
        this.println(this.mBulder + "ifZeroComparisonBranch(" + this.getLabelName(location) + ", \"" + choice + "\")");
    }

    public void ifComparisonBranch(Location location, String choice) {
        this.println(this.mBulder + "ifComparisonBranch(" + this.getLabelName(location) + ", \"" + choice + "\")");
    }

    public void switchBranch(int[] cases, Location[] locations, Location defaultLocation) {
        int i;
        StringBuffer buf = new StringBuffer(cases.length * 15);
        buf.append(this.mBulder + "switchBranch(");
        buf.append("new int[] {");
        for (i = 0; i < cases.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(cases[i]);
        }
        buf.append("}");
        buf.append(", ");
        buf.append("new Location[] {");
        for (i = 0; i < locations.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(this.getLabelName(locations[i]));
        }
        buf.append("}");
        buf.append(", ");
        buf.append(this.getLabelName(defaultLocation));
        buf.append(')');
        this.println(buf.toString());
    }

    public void jsr(Location location) {
        this.println(this.mBulder + "jsr(" + this.getLabelName(location) + ')');
    }

    public void ret(LocalVariable local) {
        this.println(this.mBulder + "ret(" + local.getName() + ')');
    }

    public void math(byte opcode) {
        this.println(this.mBulder + "math(Opcode." + Opcode.getMnemonic(opcode).toUpperCase() + ')');
    }

    public void arrayLength() {
        this.println(this.mBulder + "arrayLength()");
    }

    public void throwObject() {
        this.println(this.mBulder + "throwObject()");
    }

    public void checkCast(TypeDesc type) {
        this.println(this.mBulder + "checkCast(" + this.getTypeDescName(type) + ')');
    }

    public void instanceOf(TypeDesc type) {
        this.println(this.mBulder + "instanceOf(" + this.getTypeDescName(type) + ')');
    }

    public void integerIncrement(LocalVariable local, int amount) {
        this.println(this.mBulder + "integerIncrement(" + local.getName() + ", " + amount + ')');
    }

    public void monitorEnter() {
        this.println(this.mBulder + "monitorEnter()");
    }

    public void monitorExit() {
        this.println(this.mBulder + "monitorExit()");
    }

    public void nop() {
        this.println(this.mBulder + "nop()");
    }

    public void breakpoint() {
        this.println(this.mBulder + "breakpoint()");
    }

    private void separatorLine() {
        if (this.mNeedSeparatorLine) {
            this.mWriter.println();
            this.mNeedSeparatorLine = false;
        }
    }

    private void println(String str) {
        this.mNeedSeparatorLine = true;
        if (this.mLinePrefix != null) {
            this.mWriter.print(this.mLinePrefix);
        }
        if (this.mLineSuffix == null) {
            this.mWriter.println(str);
        } else {
            this.mWriter.print(str);
            this.mWriter.println(this.mLineSuffix);
        }
    }

    private String getLabelName(Location location) {
        if (location instanceof NamedLabel) {
            return ((NamedLabel)location).mName;
        }
        return ((NamedLabel)this.createLabel()).mName;
    }

    private String getTypeDescName(TypeDesc type) {
        if (type == null) {
            return "null";
        }
        String name = (String)this.mTypeDescNames.get(type);
        if (name == null) {
            if (type.isPrimitive()) {
                name = "TypeDesc.".concat(type.getRootName().toUpperCase());
                this.mTypeDescNames.put(type, name);
                return name;
            }
            if (type == TypeDesc.OBJECT) {
                name = "TypeDesc.OBJECT";
                this.mTypeDescNames.put(type, "TypeDesc.OBJECT");
                return name;
            }
            if (type == TypeDesc.STRING) {
                name = "TypeDesc.STRING";
                this.mTypeDescNames.put(type, "TypeDesc.STRING");
                return name;
            }
            name = "type_" + ++this.mTypeDescCounter;
            this.mTypeDescNames.put(type, name);
            StringBuffer buf = new StringBuffer("TypeDesc ");
            buf.append(name);
            buf.append(" = ");
            TypeDesc componentType = type.getComponentType();
            if (componentType != null) {
                buf.append(this.getTypeDescName(componentType));
                buf.append(".toArrayType(");
            } else {
                buf.append("TypeDesc.forClass(");
                buf.append('\"');
                buf.append(type.getRootName());
                buf.append('\"');
            }
            buf.append(')');
            this.println(buf.toString());
        }
        return name;
    }

    private String getTypeDescArrayName(TypeDesc[] types) {
        if (types == null) {
            return "null";
        }
        List<TypeDesc> key = Arrays.asList(types);
        String name = (String)this.mTypeDescArrayNames.get(key);
        if (name == null) {
            name = "params_" + ++this.mTypeDescArrayCounter;
            this.mTypeDescArrayNames.put(key, name);
            StringBuffer buf = new StringBuffer("TypeDesc[] ");
            buf.append(name);
            buf.append(" = new TypeDesc[] {");
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.getTypeDescName(types[i]));
            }
            buf.append('}');
            this.println(buf.toString());
        }
        return name;
    }

    static String escape(String value) {
        return CodeAssemblerPrinter.escape(value, false);
    }

    static String escape(String value, boolean forChar) {
        char c;
        int i;
        int length = value.length();
        for (i = 0; !(i >= length || (c = value.charAt(i)) < ' ' || c > '~' || c == '\"' || c == '\\' || forChar && c == '\''); ++i) {
        }
        if (i >= length) {
            return value;
        }
        StringBuffer buf = new StringBuffer(length + 16);
        block12: for (i = 0; i < length; ++i) {
            char c2 = value.charAt(i);
            if (!(c2 < ' ' || c2 > '~' || c2 == '\"' || c2 == '\\' || forChar && c2 == '\'')) {
                buf.append(c2);
                continue;
            }
            switch (c2) {
                case '\u0000': {
                    buf.append("\\0");
                    continue block12;
                }
                case '\"': {
                    buf.append("\\\"");
                    continue block12;
                }
                case '\'': {
                    buf.append("\\'");
                    continue block12;
                }
                case '\\': {
                    buf.append("\\\\");
                    continue block12;
                }
                case '\b': {
                    buf.append("\\b");
                    continue block12;
                }
                case '\f': {
                    buf.append("\\f");
                    continue block12;
                }
                case '\n': {
                    buf.append("\\n");
                    continue block12;
                }
                case '\r': {
                    buf.append("\\r");
                    continue block12;
                }
                case '\t': {
                    buf.append("\\t");
                    continue block12;
                }
                default: {
                    String u = Integer.toHexString(c2).toLowerCase();
                    buf.append("\\u");
                    for (int len = u.length(); len < 4; ++len) {
                        buf.append('0');
                    }
                    buf.append(u);
                }
            }
        }
        return buf.toString();
    }

    private class NamedLabel
    implements Label {
        public final String mName;

        public NamedLabel(String name) {
            this.mName = name;
        }

        public Label setLocation() {
            CodeAssemblerPrinter.this.println(this.mName + ".setLocation()");
            return this;
        }

        public int getLocation() {
            return -1;
        }

        public int compareTo(Object obj) {
            return 0;
        }
    }

    private class NamedLocal
    implements LocalVariable {
        private final String mName;
        private final TypeDesc mType;
        private final int mNumber;

        public NamedLocal(String name, TypeDesc type, int number) {
            this.mName = name;
            this.mType = type;
            this.mNumber = number;
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String name) {
            CodeAssemblerPrinter.this.println(this.mName + ".setName(" + name + ')');
        }

        public TypeDesc getType() {
            return this.mType;
        }

        public boolean isDoubleWord() {
            return this.mType.isDoubleWord();
        }

        public int getNumber() {
            return this.mNumber;
        }

        public Location getStartLocation() {
            return null;
        }

        public Location getEndLocation() {
            return null;
        }

        public Set getLocationRangeSet() {
            return null;
        }
    }
}

