/*
 * Decompiled with CFR 0.152.
 */
package alt.jiapi.file;

import alt.jiapi.file.Attribute;
import alt.jiapi.file.Configuration;
import alt.jiapi.file.ConstantPool;
import java.util.List;

public class Method {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_STRICT = 2048;
    private ConstantPool cp;
    private short access_flags;
    private short name_index;
    private short descriptor_index;
    private List attributes;
    private transient Configuration config = new Configuration();

    public Method(ConstantPool cp, short access_flags, String name, String descriptor, List attributes) {
        this.cp = cp;
        this.access_flags = access_flags;
        this.name_index = cp.addUtf8Info(name).getEntryIndex();
        this.descriptor_index = cp.addUtf8Info(descriptor).getEntryIndex();
        this.attributes = attributes;
    }

    Method(ConstantPool cp, short access_flags, short name_index, short descriptor_index, List attributes) {
        this.cp = cp;
        this.access_flags = access_flags;
        this.name_index = name_index;
        this.descriptor_index = descriptor_index;
        this.attributes = attributes;
    }

    public ConstantPool getConstantPool() {
        return this.cp;
    }

    public short getAccessFlags() {
        return this.access_flags;
    }

    public Attribute getAttribute(String name) {
        for (Attribute a : this.attributes) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    public List getAttributes() {
        return this.attributes;
    }

    public String getName() {
        return this.cp.getUtf8(this.name_index);
    }

    public String getDescriptor() {
        return this.cp.getUtf8(this.descriptor_index);
    }

    short getNameIndex() {
        return this.name_index;
    }

    short getDescriptorIndex() {
        return this.descriptor_index;
    }
}

