/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tinytree.TinyBuilder;

public class Doctype
extends Instruction {
    public void setInstructionDetails(Controller controller, NamePool namePool, InstructionDetails instructionDetails) {
        instructionDetails.setInstructionName("doctype");
        instructionDetails.setProperty("instruction-namespace", "http://saxon.sf.net/");
    }

    public TailCall processLeavingTail(XPathContext xPathContext) throws TransformerException {
        TinyBuilder tinyBuilder;
        Controller controller = xPathContext.getController();
        SequenceReceiver sequenceReceiver = controller.getReceiver();
        TinyBuilder tinyBuilder2 = tinyBuilder = new TinyBuilder();
        tinyBuilder2.setNamePool(controller.getNamePool());
        tinyBuilder2.startDocument();
        controller.changeOutputDestination(null, tinyBuilder2, false, 3, null);
        this.processChildren(xPathContext);
        controller.resetOutputDestination(sequenceReceiver);
        tinyBuilder2.endDocument();
        DocumentInfo documentInfo = tinyBuilder.getCurrentDocument();
        AxisIterator axisIterator = documentInfo.iterateAxis((byte)3);
        NodeInfo nodeInfo = (NodeInfo)axisIterator.next();
        if (nodeInfo == null || !"doctype".equals(nodeInfo.getLocalPart())) {
            throw new TransformerException("saxon:doctype instruction must contain dtd:doctype");
        }
        String string = Navigator.getAttributeValue(nodeInfo, "", "name");
        String string2 = Navigator.getAttributeValue(nodeInfo, "", "system");
        String string3 = Navigator.getAttributeValue(nodeInfo, "", "public");
        if (string == null) {
            throw new TransformerException("dtd:doctype must have a name attribute");
        }
        this.write(sequenceReceiver, "<!DOCTYPE " + string + " ");
        if (string2 != null) {
            if (string3 != null) {
                this.write(sequenceReceiver, "PUBLIC \"" + string3 + "\" \"" + string2 + "\"");
            } else {
                this.write(sequenceReceiver, "SYSTEM \"" + string2 + "\"");
            }
        }
        boolean bl = false;
        axisIterator = nodeInfo.iterateAxis((byte)3);
        NodeInfo nodeInfo2 = (NodeInfo)axisIterator.next();
        if (nodeInfo2 != null) {
            this.write(sequenceReceiver, " [");
            bl = true;
        }
        while (nodeInfo2 != null) {
            Object object;
            String string4;
            String string5;
            Object object2;
            Object object3;
            String string6;
            String string7 = nodeInfo2.getLocalPart();
            if ("element".equals(string7)) {
                string6 = Navigator.getAttributeValue(nodeInfo2, "", "name");
                object3 = Navigator.getAttributeValue(nodeInfo2, "", "content");
                if (string6 == null) {
                    throw new TransformerException("dtd:element must have a name attribute");
                }
                if (object3 == null) {
                    throw new TransformerException("dtd:element must have a content attribute");
                }
                this.write(sequenceReceiver, "\n  <!ELEMENT " + string6 + " " + (String)object3 + ">");
            } else if (string7.equals("attlist")) {
                string6 = Navigator.getAttributeValue(nodeInfo2, "", "element");
                if (string6 == null) {
                    throw new TransformerException("dtd:attlist must have an attribute named 'element'");
                }
                this.write(sequenceReceiver, "\n  <!ATTLIST " + string6 + " ");
                object3 = nodeInfo2.iterateAxis((byte)3);
                while ((object2 = (NodeInfo)object3.next()) != null) {
                    if ("attribute".equals(object2.getLocalPart())) {
                        string5 = Navigator.getAttributeValue((NodeInfo)object2, "", "name");
                        string4 = Navigator.getAttributeValue((NodeInfo)object2, "", "type");
                        object = Navigator.getAttributeValue((NodeInfo)object2, "", "value");
                        if (string5 == null) {
                            throw new TransformerException("dtd:attribute must have a name attribute");
                        }
                        if (string4 == null) {
                            throw new TransformerException("dtd:attribute must have a type attribute");
                        }
                        if (object == null) {
                            throw new TransformerException("dtd:attribute must have a value attribute");
                        }
                        this.write(sequenceReceiver, "\n    " + string5 + " " + string4 + " " + (String)object);
                        continue;
                    }
                    throw new TransformerException("Unrecognized element within dtd:attlist");
                }
                this.write(sequenceReceiver, ">");
            } else if (string7.equals("entity")) {
                NodeInfo nodeInfo3;
                string6 = Navigator.getAttributeValue(nodeInfo2, "", "name");
                object3 = Navigator.getAttributeValue(nodeInfo2, "", "parameter");
                object2 = Navigator.getAttributeValue(nodeInfo2, "", "system");
                string5 = Navigator.getAttributeValue(nodeInfo2, "", "public");
                string4 = Navigator.getAttributeValue(nodeInfo2, "", "notation");
                if (string6 == null) {
                    throw new TransformerException("dtd:entity must have a name attribute");
                }
                this.write(sequenceReceiver, "\n  <!ENTITY ");
                if ("yes".equals(object3)) {
                    this.write(sequenceReceiver, "% ");
                }
                this.write(sequenceReceiver, string6 + " ");
                if (object2 != null) {
                    if (string5 != null) {
                        this.write(sequenceReceiver, "PUBLIC \"" + string5 + "\" \"" + (String)object2 + "\" ");
                    } else {
                        this.write(sequenceReceiver, "SYSTEM \"" + (String)object2 + "\" ");
                    }
                }
                if (string4 != null) {
                    this.write(sequenceReceiver, "NDATA " + string4 + " ");
                }
                object = nodeInfo2.iterateAxis((byte)3);
                while ((nodeInfo3 = (NodeInfo)object.next()) != null) {
                    nodeInfo3.copy(sequenceReceiver, 0, false);
                }
            } else if (string7.equals("notation")) {
                string6 = Navigator.getAttributeValue(nodeInfo2, "", "name");
                object3 = Navigator.getAttributeValue(nodeInfo2, "", "system");
                object2 = Navigator.getAttributeValue(nodeInfo2, "", "public");
                if (string6 == null) {
                    throw new TransformerException("dtd:notation must have a name attribute");
                }
                if (object3 == null && object2 == null) {
                    throw new TransformerException("dtd:notation must have a system attribute or a public attribute");
                }
                this.write(sequenceReceiver, "\n  <!NOTATION " + string6);
                if (object2 != null) {
                    this.write(sequenceReceiver, " PUBLIC \"" + (String)object2 + "\" ");
                    if (object3 != null) {
                        this.write(sequenceReceiver, "\"" + (String)object3 + "\" ");
                    }
                } else {
                    this.write(sequenceReceiver, " SYSTEM \"" + (String)object3 + "\" ");
                }
            } else {
                throw new TransformerException("Unrecognized element " + string7 + " in DTD output");
            }
            nodeInfo2 = (NodeInfo)axisIterator.next();
        }
        if (bl) {
            this.write(sequenceReceiver, "\n]");
            bl = false;
        }
        this.write(sequenceReceiver, ">\n");
        return null;
    }

    private void write(Receiver receiver, String string) throws TransformerException {
        receiver.characters(string, 1);
    }
}

