/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FileManager {
    private ArrayList directories = new ArrayList();
    private boolean acceptInnerClasses = true;

    public void acceptInnerClasses(boolean b) {
        this.acceptInnerClasses = b;
    }

    public void addDirectory(String name) throws IOException {
        File directory = new File(name);
        if (!directory.isDirectory() && !this.acceptJarFile(directory)) {
            throw new IOException("Invalid directory or JAR file: " + name);
        }
        this.directories.add(directory);
    }

    public boolean acceptFile(File file) {
        return this.acceptClassFile(file) || this.acceptJarFile(file);
    }

    public boolean acceptClassFile(File file) {
        if (!file.isFile()) {
            return false;
        }
        return this.acceptClassFileName(file.getName());
    }

    public boolean acceptClassFileName(String name) {
        if (!this.acceptInnerClasses && name.toLowerCase().indexOf("$") > 0) {
            return false;
        }
        return name.toLowerCase().endsWith(".class");
    }

    public boolean acceptJarFile(File file) {
        return this.isJar(file) || this.isZip(file) || this.isWar(file);
    }

    public Collection extractFiles() {
        ArrayList files = new ArrayList();
        Iterator i = this.directories.iterator();
        while (i.hasNext()) {
            File directory = (File)i.next();
            this.collectFiles(directory, files);
        }
        return files;
    }

    private void collectFiles(File directory, Collection files) {
        if (directory.isFile()) {
            this.addFile(directory, files);
        } else {
            String[] directoryFiles = directory.list();
            for (int i = 0; i < directoryFiles.length; ++i) {
                File file = new File(directory, directoryFiles[i]);
                if (this.acceptFile(file)) {
                    this.addFile(file, files);
                    continue;
                }
                if (!file.isDirectory()) continue;
                this.collectFiles(file, files);
            }
        }
    }

    private void addFile(File f, Collection files) {
        if (!files.contains(f)) {
            files.add(f);
        }
    }

    private boolean isWar(File file) {
        return this.existsWithExtension(file, ".war");
    }

    private boolean isZip(File file) {
        return this.existsWithExtension(file, ".zip");
    }

    private boolean isJar(File file) {
        return this.existsWithExtension(file, ".jar");
    }

    private boolean existsWithExtension(File file, String extension) {
        return file.isFile() && file.getName().toLowerCase().endsWith(extension);
    }
}

