/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.whitespace;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CodePointUtil;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;

@StatelessCheck
public class NoWhitespaceBeforeCheck
extends AbstractCheck {
    public static final String MSG_KEY = "ws.preceded";
    private boolean allowLineBreaks;

    @Override
    public int[] getDefaultTokens() {
        return new int[]{74, 45, 25, 26, 171, 22};
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{74, 45, 25, 26, 59, 172, 173, 171, 22, 180};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        boolean isFirstToken;
        int[] line = this.getLineCodePoints(ast.getLineNo() - 1);
        int columnNoBeforeToken = ast.getColumnNo() - 1;
        boolean bl = isFirstToken = columnNoBeforeToken == -1;
        if ((isFirstToken || CommonUtil.isCodePointWhitespace(line, columnNoBeforeToken)) && !NoWhitespaceBeforeCheck.isInEmptyForInitializerOrCondition(ast)) {
            boolean isViolation;
            boolean bl2 = isViolation = !this.allowLineBreaks || !isFirstToken && !CodePointUtil.hasWhitespaceBefore(columnNoBeforeToken, line);
            if (isViolation) {
                this.log(ast, MSG_KEY, ast.getText());
            }
        }
    }

    private static boolean isInEmptyForInitializerOrCondition(DetailAST semicolonAst) {
        boolean result = false;
        DetailAST sibling = semicolonAst.getPreviousSibling();
        if (!(sibling == null || sibling.getType() != 35 && sibling.getType() != 36 || sibling.hasChildren())) {
            result = true;
        }
        return result;
    }

    public void setAllowLineBreaks(boolean allowLineBreaks) {
        this.allowLineBreaks = allowLineBreaks;
    }
}

