/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.util.L;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;

public class IdentifierExpr
extends Expr {
    String mName;
    String mUserDefinedType;

    IdentifierExpr(String name) {
        super(new Expr[0]);
        this.mName = name;
    }

    public String getName() {
        return this.mName;
    }

    public void setUserDefinedType(String userDefinedType) {
        this.mUserDefinedType = userDefinedType;
    }

    @Override
    protected String computeUniqueKey() {
        return sUniqueKeyJoiner.join(this.mName, super.computeUniqueKey(), new Object[0]);
    }

    public String getUserDefinedType() {
        return this.mUserDefinedType;
    }

    public String getExpandedUserDefinedType(ModelAnalyzer modelAnalyzer) {
        Preconditions.checkNotNull(this.mUserDefinedType, "Identifiers must have user defined types from the XML file. %s is missing it", this.mName);
        String expanded = modelAnalyzer.applyImports(this.mUserDefinedType, this.getModel().getImports());
        L.d("expanded version of %s is %s", this.mUserDefinedType, expanded);
        return expanded;
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        Preconditions.checkNotNull(this.mUserDefinedType, "Identifiers must have user defined types from the XML file. %s is missing it", this.mName);
        return modelAnalyzer.findClass(this.mUserDefinedType, this.getModel().getImports());
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return Lists.newArrayList();
    }

    @Override
    protected String asPackage() {
        return this.mUserDefinedType == null ? this.mName : null;
    }
}

