# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ChaosScheduleJob(Model):
    """Defines a repetition rule and parameters of Chaos to be used with the Chaos
    Schedule.

    :param chaos_parameters: A reference to which Chaos Parameters of the
     Chaos Schedule to use.
    :type chaos_parameters: str
    :param days: Defines the days of the week that a Chaos Schedule Job will
     run for.
    :type days: ~azure.servicefabric.models.ChaosScheduleJobActiveDaysOfWeek
    :param times: A list of Time Ranges that specify when during active days
     that this job will run. The times are interpreted as UTC.
    :type times: list[~azure.servicefabric.models.TimeRange]
    """

    _attribute_map = {
        'chaos_parameters': {'key': 'ChaosParameters', 'type': 'str'},
        'days': {'key': 'Days', 'type': 'ChaosScheduleJobActiveDaysOfWeek'},
        'times': {'key': 'Times', 'type': '[TimeRange]'},
    }

    def __init__(self, *, chaos_parameters: str=None, days=None, times=None, **kwargs) -> None:
        super(ChaosScheduleJob, self).__init__(**kwargs)
        self.chaos_parameters = chaos_parameters
        self.days = days
        self.times = times
